/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.client.renderer.ModularBoxRenderer;
import com.jaquadro.minecraft.storagedrawers.util.RenderHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class DrawersItemRenderer
implements IItemRenderer {
    private RenderHelper renderHelper = new RenderHelper();
    private ModularBoxRenderer boxRenderer = new ModularBoxRenderer();
    private float[] colorScratch = new float[3];

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        RenderBlocks renderer = this.getRenderer(data);
        if (renderer == null) {
            return;
        }
        Block block = Block.func_149634_a((Item)item.func_77973_b());
        if (!(block instanceof BlockDrawers)) {
            return;
        }
        this.renderDrawer((BlockDrawers)block, item, renderer, type);
    }

    private void renderDrawer(BlockDrawers block, ItemStack item, RenderBlocks renderer, IItemRenderer.ItemRenderType renderType) {
        int side = 4;
        this.boxRenderer.setUnit(0.0625);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        for (int i = 0; i < 6; ++i) {
            this.boxRenderer.setIcon(block.func_149691_a(i, item.func_77960_j()), i);
        }
        if (renderType == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (renderType == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (renderType == IItemRenderer.ItemRenderType.INVENTORY || renderType == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glTranslatef((float)(block.halfDepth ? -0.75f : -0.5f), (float)-0.5f, (float)-0.5f);
        }
        switch (side - 2) {
            case 0: {
                renderer.field_147867_u = 3;
                break;
            }
            case 1: {
                renderer.field_147867_u = 0;
                break;
            }
            case 2: {
                renderer.field_147867_u = 1;
                break;
            }
            case 3: {
                renderer.field_147867_u = 2;
            }
        }
        this.renderExterior(block, 0, 0, 0, side, renderer);
        renderer.field_147867_u = 0;
        this.boxRenderer.setUnit(0.0);
        this.boxRenderer.setInteriorIcon(block.func_149691_a(side, item.func_77960_j()), ForgeDirection.OPPOSITES[side]);
        this.renderInterior(block, 0, 0, 0, side, renderer);
        this.boxRenderer.setExteriorIcon(block.getTapeIcon(), side);
        if (item.func_77942_o() && item.func_77978_p().func_74764_b("tile")) {
            double depth = block.halfDepth ? 0.5 : 1.0;
            RenderHelper.instance.setRenderBounds(1.0 - depth - 0.005, 0.0, 0.0, 1.0, 1.0, 1.0);
            RenderHelper.instance.renderFace(side, null, (Block)block, block.getTapeIcon(), 1.0f, 1.0f, 1.0f);
        }
        if (renderType == IItemRenderer.ItemRenderType.INVENTORY || renderType == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glTranslatef((float)(block.halfDepth ? 0.75f : 0.5f), (float)0.5f, (float)0.5f);
        }
    }

    private void renderExterior(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer) {
        double depth = block.halfDepth ? 0.5 : 1.0;
        double xMin = 0.0;
        double xMax = 0.0;
        double zMin = 0.0;
        double zMax = 0.0;
        switch (side) {
            case 2: {
                xMin = 0.0;
                xMax = 1.0;
                zMin = 1.0 - depth;
                zMax = 1.0;
                break;
            }
            case 3: {
                xMin = 0.0;
                xMax = 1.0;
                zMin = 0.0;
                zMax = depth;
                break;
            }
            case 4: {
                xMin = 1.0 - depth;
                xMax = 1.0;
                zMin = 0.0;
                zMax = 1.0;
                break;
            }
            case 5: {
                xMin = 0.0;
                xMax = depth;
                zMin = 0.0;
                zMax = 1.0;
            }
        }
        this.boxRenderer.renderExterior(renderer, (Block)block, x, y, z, xMin, 0.0, zMin, xMax, 1.0, zMax, 0, ModularBoxRenderer.sideCut[side]);
    }

    private void renderInterior(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer) {
        double unit = block.getTrimDepth();
        double depth = block.halfDepth ? 0.5 : 1.0;
        double xMin = 0.0;
        double xMax = 0.0;
        double zMin = 0.0;
        double zMax = 0.0;
        switch (side) {
            case 2: {
                xMin = unit;
                xMax = 1.0 - unit;
                zMin = 1.0 - depth;
                zMax = 1.0 - depth + unit;
                break;
            }
            case 3: {
                xMin = unit;
                xMax = 1.0 - unit;
                zMin = depth - unit;
                zMax = depth;
                break;
            }
            case 4: {
                xMin = 1.0 - depth;
                xMax = 1.0 - depth + unit;
                zMin = unit;
                zMax = 1.0 - unit;
                break;
            }
            case 5: {
                xMin = depth - unit;
                xMax = depth;
                zMin = unit;
                zMax = 1.0 - unit;
            }
        }
        this.boxRenderer.renderInterior(renderer, (Block)block, x, y, z, xMin, unit, zMin, xMax, 1.0 - unit, zMax, 0, ModularBoxRenderer.sideCut[side]);
    }

    private RenderBlocks getRenderer(Object[] data) {
        for (Object obj : data) {
            if (!(obj instanceof RenderBlocks)) continue;
            return (RenderBlocks)obj;
        }
        return null;
    }
}

