/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.utills;

import com.brandon3055.brandonscore.common.utills.DataUtills;
import com.brandon3055.brandonscore.common.utills.InfoHelper;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.network.ItemConfigPacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;

public class ItemConfigField {
    public Object value;
    public int slot;
    public int datatype;
    public String name;
    public int fieldid;
    public Object max;
    public Object min;
    public Object incroment;
    public String modifier;

    public ItemConfigField(int datatype, int slot, String name) {
        this.slot = slot;
        this.datatype = datatype;
        this.name = name;
    }

    public ItemConfigField(int datatype, Object value, int slot, String name) {
        this.value = value;
        this.slot = slot;
        this.datatype = datatype;
        this.name = name;
    }

    public ItemConfigField setMinMaxAndIncromente(Object min, Object max, Object incroment) {
        this.max = max;
        this.min = min;
        this.incroment = incroment;
        return this;
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)("button.de." + this.name + ".name"));
    }

    public ItemConfigField readFromItem(ItemStack stack, Object defaultExpected) {
        this.value = DataUtills.readObjectFromItem((ItemStack)stack, (int)this.datatype, (String)this.name, (Object)defaultExpected);
        return this;
    }

    public ItemConfigField setModifier(String modifier) {
        this.modifier = modifier;
        return this;
    }

    public String getFormatedValue() {
        if (this.datatype == 2 && !StringUtils.func_151246_b((String)this.modifier) && this.modifier.equals("AOE")) {
            int i = (Integer)this.value;
            return String.valueOf((i *= 2) + 1 + "x" + (i + 1));
        }
        return String.valueOf(this.value);
    }

    public String getTooltipInfo() {
        return InfoHelper.ITC() + this.getLocalizedName() + ": " + InfoHelper.HITC() + this.getFormatedValue();
    }

    public void sendChanges() {
        DraconicEvolution.network.sendToServer((IMessage)new ItemConfigPacket(this));
    }

    public int castToInt() {
        switch (this.datatype) {
            case 0: {
                return ((Byte)this.value).byteValue();
            }
            case 1: {
                return ((Short)this.value).shortValue();
            }
            case 2: {
                return (Integer)this.value;
            }
            case 3: {
                long l = (Long)this.value;
                return (int)l;
            }
            case 4: {
                float f = ((Float)this.value).floatValue();
                return (int)f;
            }
            case 5: {
                double d = (Double)this.value;
                return (int)d;
            }
            case 6: {
                return (Boolean)this.value != false ? 1 : 0;
            }
        }
        return 0;
    }

    public double castToDouble() {
        switch (this.datatype) {
            case 0: {
                return ((Byte)this.value).byteValue();
            }
            case 1: {
                return ((Short)this.value).shortValue();
            }
            case 2: {
                return ((Integer)this.value).intValue();
            }
            case 3: {
                long l = (Long)this.value;
                return l;
            }
            case 4: {
                float f = ((Float)this.value).floatValue();
                return f;
            }
            case 5: {
                return (Double)this.value;
            }
            case 6: {
                return (Boolean)this.value != false ? 1.0 : 0.0;
            }
        }
        return 0.0;
    }
}

