/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyReceiver;
import com.brandon3055.brandonscore.common.utills.InventoryUtils;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.DraconiumChest;
import com.brandon3055.draconicevolution.common.container.ContainerDraconiumChest;
import com.brandon3055.draconicevolution.common.lib.OreDoublingRegistry;
import com.brandon3055.draconicevolution.common.utills.EnergyStorage;
import com.brandon3055.draconicevolution.common.utills.ICustomItemData;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class TileDraconiumChest
extends TileEntity
implements ISidedInventory,
IEnergyReceiver,
ICustomItemData {
    ItemStack[] items = new ItemStack[240];
    ItemStack[] itemsCrafting = new ItemStack[10];
    private int ticksSinceSync = -1;
    public float prevLidAngle;
    public float lidAngle;
    private int numUsingPlayers;
    private int facing;
    public int red = 100;
    public int green = 0;
    public int blue = 150;
    public boolean editMode = false;
    public boolean lockOutputSlots = false;
    private String customName;
    public EnergyStorage energy = new EnergyStorage(1000000, 10000, 0);
    public int smeltingProgressTime;
    public int smeltingBurnSpeed;
    public final int smeltingMaxBurnSpeed = 50;
    public final int smeltingCompleateTime = 1600;
    public int smeltingAutoFeed = 0;
    public int tick;
    private boolean inTick = false;
    private boolean requiresUpdate = false;
    private boolean smeltInProgress = false;
    private boolean updateSuspended = false;

    public void func_145845_h() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.numUsingPlayers != 0 && (this.ticksSinceSync + this.field_145851_c + this.field_145848_d + this.field_145849_e) % 200 == 0) {
            this.numUsingPlayers = 0;
            float var1 = 5.0f;
            List var2 = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - var1), (double)((float)this.field_145848_d - var1), (double)((float)this.field_145849_e - var1), (double)((float)(this.field_145851_c + 1) + var1), (double)((float)(this.field_145848_d + 1) + var1), (double)((float)(this.field_145849_e + 1) + var1)));
            for (EntityPlayer var4 : var2) {
                if (!(var4.field_71070_bA instanceof ContainerDraconiumChest)) continue;
                ++this.numUsingPlayers;
            }
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.ticksSinceSync < 0) {
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)ModBlocks.draconiumChest, 3, this.numUsingPlayers << 3 & 0xF8 | this.facing & 7);
        }
        ++this.ticksSinceSync;
        this.prevLidAngle = this.lidAngle;
        float f = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double d = (double)this.field_145851_c + 0.5;
            double d1 = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(d, (double)this.field_145848_d + 0.5, d1, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                double d2 = (double)this.field_145851_c + 0.5;
                double d3 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(d2, (double)this.field_145848_d + 0.5, d3, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
        this.updateFurnace();
        this.updateEnergy();
    }

    public void updateEnergy() {
        if (this.energy.getEnergyStored() < this.energy.getMaxEnergyStored() && this.func_70301_a(239) != null && this.func_70301_a(239).func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem item = (IEnergyContainerItem)this.func_70301_a(239).func_77973_b();
            item.extractEnergy(this.func_70301_a(239), this.receiveEnergy(ForgeDirection.DOWN, item.extractEnergy(this.func_70301_a(239), this.energy.getMaxReceive(), true), false), false);
        }
    }

    public void updateFurnace() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.tick;
        if (this.requiresUpdate && this.numUsingPlayers > 0) {
            if (!this.smeltInProgress && !this.updateSuspended) {
                if (this.getFill() || this.getLock() || this.getAll()) {
                    this.feedNextItem();
                }
                this.smeltInProgress = this.canFurnaceRun();
            }
            this.requiresUpdate = false;
        }
        if (this.updateSuspended && this.getTick() % 500 != 0) {
            return;
        }
        this.updateSuspended = false;
        this.inTick = true;
        if (!this.smeltInProgress && this.getTick() % 500 == 0 && this.energy.getEnergyStored() > 1000) {
            if (this.getFill() || this.getLock() || this.getAll()) {
                this.feedNextItem();
            }
            this.smeltInProgress = this.canFurnaceRun();
        }
        if (this.smeltInProgress) {
            this.smeltingBurnSpeed = Math.min(this.energy.getEnergyStored() / 1000, 50);
            this.energy.modifyEnergyStored(-this.smeltingBurnSpeed * 20);
            this.smeltingProgressTime += this.smeltingBurnSpeed;
            if (this.smeltingProgressTime >= 1600) {
                if (this.canFurnaceRun() && this.trySmelt()) {
                    if (this.getFill() || this.getLock() || this.getAll()) {
                        this.feedNextItem();
                    }
                    this.smeltInProgress = this.canFurnaceRun();
                } else {
                    this.updateSuspended = true;
                    this.smeltInProgress = false;
                    this.smeltingProgressTime = 0;
                    this.smeltingBurnSpeed = 0;
                }
                this.smeltingProgressTime = 0;
            }
        } else {
            this.smeltingProgressTime = 0;
            this.smeltingBurnSpeed = 0;
        }
        this.inTick = false;
    }

    private void confirmRunningState() {
    }

    private boolean canFurnaceRun() {
        int i;
        boolean flag = false;
        for (i = 0; i < 5; ++i) {
            ItemStack stack;
            if (this.func_70301_a(234 + i) == null || !this.isSmeltable(stack = this.func_70301_a(234 + i))) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        if (this.getLock()) {
            flag = false;
            for (i = 0; i < 5; ++i) {
                ItemStack recipe = this.func_70301_a(234 + i);
                if (recipe == null || recipe.field_77994_a == 1) continue;
                flag = true;
            }
            if (!flag) {
                return false;
            }
        }
        for (i = 0; i < 5; ++i) {
            if (this.func_70301_a(234 + i) == null) continue;
            ItemStack output = this.getResult(this.func_70301_a(234 + i)).func_77946_l();
            for (int j = 0; j < this.func_70302_i_(); ++j) {
                InventoryUtils.insertItemIntoInventory((IInventory)this, (ItemStack)output, (ForgeDirection)ForgeDirection.DOWN, (int)j, (boolean)false);
                if (output.field_77994_a == 0) break;
            }
            if (output.field_77994_a <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean trySmelt() {
        int itemsToProcess = 5;
        int processAttempts = 0;
        boolean itemSmelted = false;
        block0: do {
            for (int i = 0; i < 5; ++i) {
                ItemStack recipe = this.func_70301_a(234 + i);
                if (recipe == null || this.getLock() && recipe.field_77994_a == 1) continue;
                ItemStack result = this.getResult(recipe).func_77946_l();
                for (int j = 0; j < this.func_70302_i_(); ++j) {
                    if (this.func_70301_a(j) == null) continue;
                    InventoryUtils.tryMergeStacks((ItemStack)result, (ItemStack)this.func_70301_a(j));
                }
                if (result.field_77994_a > 0) {
                    InventoryUtils.insertItemIntoInventory((IInventory)this, (ItemStack)result);
                }
                if (result.field_77994_a == 0) {
                    --recipe.field_77994_a;
                    if (recipe.field_77994_a == 0) {
                        this.func_70299_a(234 + i, null);
                    }
                    --itemsToProcess;
                    itemSmelted = true;
                }
                if (itemsToProcess == 0) continue block0;
            }
        } while (itemsToProcess > 0 && ++processAttempts < 5);
        return itemSmelted;
    }

    public void feedNextItem() {
        boolean[] stacksFull = new boolean[]{false, false, false, false, false};
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            ItemStack candidate = this.func_70301_a(i);
            for (int j = 0; j < 5; ++j) {
                if (this.func_70301_a(234 + j) == null && this.getAll()) {
                    boolean candidateSmeltable;
                    if (candidate == null) break;
                    boolean bl = candidateSmeltable = this.getResult(candidate) != null;
                    if (candidateSmeltable) {
                        this.func_70299_a(234 + j, candidate.func_77946_l());
                        this.func_70299_a(i, null);
                        candidate = null;
                    }
                }
                if (this.func_70301_a(234 + j) == null || candidate == null) continue;
                ItemStack inputSlot = this.func_70301_a(234 + j);
                InventoryUtils.tryMergeStacks((ItemStack)candidate, (ItemStack)inputSlot);
                if (candidate.field_77994_a == 0) {
                    this.func_70299_a(i, null);
                    candidate = null;
                }
                if (inputSlot.field_77994_a != inputSlot.func_77976_d()) continue;
                stacksFull[j] = true;
            }
            if (candidate != null && candidate.field_77994_a == 0) {
                this.func_70299_a(i, null);
            }
            if (stacksFull[0] && stacksFull[1] && stacksFull[2] && stacksFull[3] && stacksFull[4]) break;
        }
    }

    private boolean getFill() {
        return this.smeltingAutoFeed == 1;
    }

    private boolean getLock() {
        return this.smeltingAutoFeed == 2;
    }

    private boolean getAll() {
        return this.smeltingAutoFeed == 3;
    }

    private boolean isSmeltable(ItemStack stack) {
        return FurnaceRecipes.func_77602_a().func_151395_a(stack) != null || OreDoublingRegistry.getOreResult(stack) != null;
    }

    private ItemStack getResult(ItemStack stack) {
        ItemStack oreResult = OreDoublingRegistry.getOreResult(stack);
        return oreResult != null ? oreResult : FurnaceRecipes.func_77602_a().func_151395_a(stack);
    }

    public void setAutoFeed(int i) {
        this.smeltingAutoFeed = i;
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.numUsingPlayers = j;
        } else if (i == 2) {
            this.facing = (byte)j;
        } else if (i == 3) {
            this.facing = (byte)(j & 7);
            this.numUsingPlayers = (j & 0xF8) >> 3;
        }
        return true;
    }

    public void rotateAround(ForgeDirection axis) {
        this.setFacing((byte)ForgeDirection.getOrientation((int)this.facing).getRotation(axis).ordinal());
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)ModBlocks.draconiumChest, 3, this.numUsingPlayers << 3 & 0xF8 | this.facing & 7);
    }

    public int getFacing() {
        return this.facing;
    }

    public void setFacing(int facing2) {
        this.facing = facing2;
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("facing", (byte)this.facing);
        compound.func_74768_a("Red", this.red);
        compound.func_74768_a("Green", this.green);
        compound.func_74768_a("Blue", this.blue);
        compound.func_74757_a("Edit", this.editMode);
        compound.func_74774_a("AutoFeed", (byte)this.smeltingAutoFeed);
        if (this.customName != null && this.customName.length() > 0) {
            compound.func_74778_a("CustomName", this.customName);
        }
        this.energy.writeToNBT(compound);
        super.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int func_70302_i_() {
        return this.items.length - 6;
    }

    public ItemStack func_70301_a(int i) {
        return this.items[i];
    }

    public ItemStack getStackInCraftingSlot(int i) {
        return this.itemsCrafting[i];
    }

    public ItemStack func_70298_a(int i, int count) {
        ItemStack itemstack = this.func_70301_a(i);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= count) {
                this.func_70299_a(i, null);
            } else {
                itemstack = itemstack.func_77979_a(count);
                if (itemstack.field_77994_a == 0) {
                    this.func_70299_a(i, null);
                }
            }
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack item = this.func_70301_a(i);
        if (item != null) {
            this.func_70299_a(i, null);
        }
        return item;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.items[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public void setInventoryCraftingSlotContents(int i, ItemStack itemstack) {
        this.itemsCrafting[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : StatCollector.func_74838_a((String)(ModBlocks.draconiumChest.func_149739_a() + ".name"));
    }

    public void setCustomName(String s) {
        this.customName = s;
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.4) < 64.0;
    }

    public void func_70295_k_() {
        if (this.field_145850_b == null) {
            return;
        }
        ++this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)ModBlocks.draconiumChest, 1, this.numUsingPlayers);
    }

    public void func_70305_f() {
        if (this.field_145850_b == null) {
            return;
        }
        --this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)ModBlocks.draconiumChest, 1, this.numUsingPlayers);
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return DraconiumChest.isStackValid(itemstack);
    }

    public void func_145841_b(NBTTagCompound compound) {
        int i;
        super.func_145841_b(compound);
        NBTTagCompound[] tag = new NBTTagCompound[this.items.length];
        for (i = 0; i < this.items.length; ++i) {
            tag[i] = new NBTTagCompound();
            if (this.items[i] != null) {
                tag[i] = this.items[i].func_77955_b(tag[i]);
            }
            compound.func_74782_a("Item" + i, (NBTBase)tag[i]);
        }
        for (i = 0; i < this.itemsCrafting.length; ++i) {
            tag[i] = new NBTTagCompound();
            if (this.itemsCrafting[i] != null) {
                tag[i] = this.itemsCrafting[i].func_77955_b(tag[i]);
            }
            compound.func_74782_a("CraftingItem" + i, (NBTBase)tag[i]);
        }
        compound.func_74774_a("facing", (byte)this.facing);
        compound.func_74768_a("Red", this.red);
        compound.func_74768_a("Green", this.green);
        compound.func_74768_a("Blue", this.blue);
        compound.func_74757_a("Edit", this.editMode);
        compound.func_74757_a("LockOutputSlots", this.lockOutputSlots);
        compound.func_74774_a("AutoFeed", (byte)this.smeltingAutoFeed);
        if (this.customName != null && this.customName.length() > 0) {
            compound.func_74778_a("CustomName", this.customName);
        }
        this.energy.writeToNBT(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        int i;
        super.func_145839_a(compound);
        NBTTagCompound[] tag = new NBTTagCompound[this.items.length];
        for (i = 0; i < this.items.length; ++i) {
            tag[i] = compound.func_74775_l("Item" + i);
            this.items[i] = ItemStack.func_77949_a((NBTTagCompound)tag[i]);
        }
        for (i = 0; i < this.itemsCrafting.length; ++i) {
            tag[i] = compound.func_74775_l("CraftingItem" + i);
            this.itemsCrafting[i] = ItemStack.func_77949_a((NBTTagCompound)tag[i]);
        }
        this.facing = compound.func_74771_c("facing");
        this.red = compound.func_74762_e("Red");
        this.green = compound.func_74762_e("Green");
        this.blue = compound.func_74762_e("Blue");
        this.editMode = compound.func_74767_n("Edit");
        this.lockOutputSlots = compound.func_74767_n("LockOutputSlots");
        this.smeltingAutoFeed = compound.func_74771_c("AutoFeed");
        this.customName = compound.func_74779_i("CustomName");
        this.energy.readFromNBT(compound);
    }

    @Override
    public void writeDataToItem(NBTTagCompound compound, ItemStack stack) {
        NBTTagCompound tag;
        int i;
        NBTTagList tagList = new NBTTagList();
        for (i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            tag = new NBTTagCompound();
            tag.func_74777_a("IS", (short)i);
            this.items[i].func_77955_b(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        for (i = 0; i < this.itemsCrafting.length; ++i) {
            if (this.itemsCrafting[i] == null) continue;
            tag = new NBTTagCompound();
            tag.func_74777_a("CS", (short)i);
            this.itemsCrafting[i].func_77955_b(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("Inventory", (NBTBase)tagList);
        compound.func_74768_a("Red", this.red);
        compound.func_74768_a("Green", this.green);
        compound.func_74768_a("Blue", this.blue);
        compound.func_74757_a("Edit", this.editMode);
        compound.func_74774_a("AutoFeed", (byte)this.smeltingAutoFeed);
        if (this.func_145818_k_()) {
            stack.func_151001_c(this.customName);
        }
        this.energy.writeToNBT(compound);
    }

    @Override
    public void readDataFromItem(NBTTagCompound compound, ItemStack stack) {
        if (compound.func_74764_b("Inventory")) {
            NBTTagList tagList = compound.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                if (tag.func_74764_b("IS")) {
                    this.items[tag.func_74765_d((String)"IS")] = ItemStack.func_77949_a((NBTTagCompound)tag);
                    continue;
                }
                if (!tag.func_74764_b("CS")) continue;
                this.itemsCrafting[tag.func_74765_d((String)"CS")] = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
        }
        this.red = compound.func_74762_e("Red");
        this.green = compound.func_74762_e("Green");
        this.blue = compound.func_74762_e("Blue");
        this.editMode = compound.func_74767_n("Edit");
        this.smeltingAutoFeed = compound.func_74771_c("AutoFeed");
        this.energy.readFromNBT(compound);
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energy.receiveEnergy(maxReceive, simulate);
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.energy.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energy.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int[] func_94128_d(int side) {
        int[] i = new int[this.func_70302_i_()];
        for (int i1 = 0; i1 < i.length; ++i1) {
            i[i1] = i1;
        }
        return i;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return !this.lockOutputSlots || this.inTick || slot < this.func_70302_i_() - 5;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return true;
    }

    private int getTick() {
        return this.field_145851_c + this.field_145848_d + this.field_145849_e + this.tick;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            this.requiresUpdate = true;
        }
    }
}

