/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.network;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.draconicevolution.client.handler.ParticleHandler;
import com.brandon3055.draconicevolution.client.render.particle.Particles;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;

public class GenericParticlePacket
implements IMessage {
    public static final byte ENERGY_BALL_KILL = 0;
    public static final byte CHAOS_BALL_KILL = 1;
    public static final byte CHAOS_IMPLOSION = 3;
    byte particleId = 0;
    double posX;
    double posY;
    double posZ;

    public GenericParticlePacket() {
    }

    public GenericParticlePacket(byte particleId, double posX, double posY, double posZ) {
        this.particleId = particleId;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public void fromBytes(ByteBuf bytes) {
        this.particleId = bytes.readByte();
        this.posX = bytes.readFloat();
        this.posY = bytes.readFloat();
        this.posZ = bytes.readFloat();
    }

    public void toBytes(ByteBuf bytes) {
        bytes.writeByte((int)this.particleId);
        bytes.writeFloat((float)this.posX);
        bytes.writeFloat((float)this.posY);
        bytes.writeFloat((float)this.posZ);
    }

    public static class Handler
    implements IMessageHandler<GenericParticlePacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(GenericParticlePacket message, MessageContext ctx) {
            switch (message.particleId) {
                case 0: {
                    for (int i = 0; i < 100; ++i) {
                        Particles.DragonProjectileParticle particle = new Particles.DragonProjectileParticle(BrandonsCore.proxy.getClientWorld(), message.posX, message.posY, message.posZ, 65535);
                        double m = 0.5;
                        particle.field_70159_w = (particle.field_70170_p.field_73012_v.nextDouble() - 0.5) * m;
                        particle.field_70181_x = (particle.field_70170_p.field_73012_v.nextDouble() - 0.5) * m;
                        particle.field_70179_y = (particle.field_70170_p.field_73012_v.nextDouble() - 0.5) * m;
                        ParticleHandler.spawnCustomParticle(particle);
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < 100; ++i) {
                        Particles.DragonProjectileParticle particle = new Particles.DragonProjectileParticle(BrandonsCore.proxy.getClientWorld(), message.posX, message.posY, message.posZ, 0x440000);
                        double m = 0.5;
                        particle.field_70159_w = (particle.field_70170_p.field_73012_v.nextDouble() - 0.5) * m;
                        particle.field_70181_x = (particle.field_70170_p.field_73012_v.nextDouble() - 0.5) * m;
                        particle.field_70179_y = (particle.field_70170_p.field_73012_v.nextDouble() - 0.5) * m;
                        ParticleHandler.spawnCustomParticle(particle);
                    }
                    break;
                }
                case 3: {
                    ParticleHandler.spawnCustomParticle(new Particles.ChaosImplosionParticle(BrandonsCore.proxy.getClientWorld(), message.posX, message.posY, message.posZ, 200.0), 512.0);
                    break;
                }
            }
            return null;
        }
    }
}

