/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.blocks.machine;

import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.blocks.BlockDE;
import com.brandon3055.draconicevolution.common.blocks.itemblocks.ItemBlockFrowGate;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.tileentities.gates.TileFluidGate;
import com.brandon3055.draconicevolution.common.tileentities.gates.TileFluxGate;
import com.brandon3055.draconicevolution.common.tileentities.gates.TileGate;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FlowGate
extends BlockDE {
    IIcon icon_input;
    IIcon icon_output;
    IIcon[] icon_fluid = new IIcon[4];
    IIcon[] icon_flux = new IIcon[4];

    public FlowGate() {
        this.func_149663_c("flowGate");
        this.func_149647_a(DraconicEvolution.tabBlocksItems);
        ModBlocks.register(this, ItemBlockFrowGate.class);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return metadata < 6 ? new TileFluxGate() : new TileFluidGate();
    }

    public void func_149666_a(Item item, CreativeTabs p_149666_2_, List list) {
        list.add(new ItemStack(item));
        list.add(new ItemStack(item, 1, 6));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(References.RESOURCESPREFIX + "machine_side");
        this.icon_input = iconRegister.func_94245_a(References.RESOURCESPREFIX + "machine_io_i");
        this.icon_output = iconRegister.func_94245_a(References.RESOURCESPREFIX + "machine_io_o");
        for (int i = 0; i < 4; ++i) {
            this.icon_fluid[i] = iconRegister.func_94245_a(References.RESOURCESPREFIX + "gates/fluidGate" + i);
            this.icon_flux[i] = iconRegister.func_94245_a(References.RESOURCESPREFIX + "gates/fluxGate" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int f = meta % 6;
        int type = meta / 6;
        if (side == f) {
            return this.icon_output;
        }
        if (ForgeDirection.getOrientation((int)side).getOpposite().ordinal() == f) {
            return this.icon_input;
        }
        int t = 0;
        if (f == 0) {
            t = 1;
        } else if (f == 1) {
            t = 3;
        } else if (f == 2) {
            t = side == 0 ? 3 : (side == 1 ? 3 : (side == 4 ? 2 : 0));
        } else if (f == 3) {
            t = side == 0 ? 1 : (side == 1 ? 1 : (side == 4 ? 0 : 2));
        } else if (f == 4) {
            t = side == 0 ? 2 : (side == 1 ? 2 : (side == 2 ? 0 : 2));
        } else if (f == 5) {
            t = side == 0 ? 0 : (side == 1 ? 0 : (side == 2 ? 2 : 0));
        }
        return type == 0 ? this.icon_flux[t] : this.icon_fluid[t];
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int d = FlowGate.determineOrientation(world, x, y, z, entity) + stack.func_77960_j();
        TileGate gate = (TileGate)world.func_147438_o(x, y, z);
        gate.output = ForgeDirection.getOrientation((int)(d % 6));
        world.func_72921_c(x, y, z, d, 2);
    }

    public static int determineOrientation(World world, int x, int y, int z, EntityLivingBase entity) {
        int l;
        if (MathHelper.func_76135_e((float)((float)entity.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entity.field_70161_v - (float)z)) < 2.0f) {
            double d0 = entity.field_70163_u + 1.82 - (double)entity.field_70129_M;
            if (d0 - (double)y > 2.0) {
                return 0;
            }
            if ((double)y - d0 > 0.0) {
                return 1;
            }
        }
        return (l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 3 : (l == 1 ? 4 : (l == 2 ? 2 : (l == 3 ? 5 : 0)));
    }

    public int func_149692_a(int meta) {
        return meta / 6 * 6;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        int meta = worldObj.func_72805_g(x, y, z);
        int type = meta / 6;
        ForgeDirection facing = ForgeDirection.getOrientation((int)(meta % 6));
        if (facing == axis || facing == axis.getOpposite()) {
            return false;
        }
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            if (facing == ForgeDirection.NORTH) {
                facing = ForgeDirection.EAST;
            } else if (facing == ForgeDirection.SOUTH) {
                facing = ForgeDirection.WEST;
            } else if (facing == ForgeDirection.EAST) {
                facing = ForgeDirection.SOUTH;
            } else if (facing == ForgeDirection.WEST) {
                facing = ForgeDirection.NORTH;
            }
        } else if (axis == ForgeDirection.NORTH || axis == ForgeDirection.SOUTH) {
            if (facing == ForgeDirection.UP) {
                facing = ForgeDirection.WEST;
            } else if (facing == ForgeDirection.DOWN) {
                facing = ForgeDirection.EAST;
            } else if (facing == ForgeDirection.EAST) {
                facing = ForgeDirection.UP;
            } else if (facing == ForgeDirection.WEST) {
                facing = ForgeDirection.DOWN;
            }
        } else if (axis == ForgeDirection.EAST || axis == ForgeDirection.WEST) {
            if (facing == ForgeDirection.UP) {
                facing = ForgeDirection.NORTH;
            } else if (facing == ForgeDirection.DOWN) {
                facing = ForgeDirection.SOUTH;
            } else if (facing == ForgeDirection.SOUTH) {
                facing = ForgeDirection.UP;
            } else if (facing == ForgeDirection.NORTH) {
                facing = ForgeDirection.DOWN;
            }
        }
        ((TileGate)worldObj.func_147438_o((int)x, (int)y, (int)z)).output = facing;
        worldObj.func_72921_c(x, y, z, facing.ordinal() + type * 6, 2);
        Utills.updateNeabourBlocks((World)worldObj, (int)x, (int)y, (int)z);
        return true;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return new ItemStack((Block)this, 1, world.func_72805_g(x, y, z) / 6 * 6);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        if (world.field_72995_K && (player.func_70694_bm() == null || !player.func_70694_bm().func_77973_b().equals((Object)ModItems.wrench))) {
            player.openGui((Object)DraconicEvolution.instance, 13, world, x, y, z);
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.updateSignal((IBlockAccess)world, x, y, z);
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        this.updateSignal(world, x, y, z);
    }

    private void updateSignal(IBlockAccess world, int x, int y, int z) {
        TileGate gate;
        TileGate tileGate = gate = world.func_147438_o(x, y, z) instanceof TileGate ? (TileGate)world.func_147438_o(x, y, z) : null;
        if (gate != null && world instanceof World) {
            gate.signal = ((World)world).func_94572_D(x, y, z);
            ((World)world).func_147471_g(x, y, z);
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }
}

