/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.creativetab.DETab;
import com.brandon3055.draconicevolution.client.gui.GuiHandler;
import com.brandon3055.draconicevolution.client.render.particle.ParticleEnergyBeam;
import com.brandon3055.draconicevolution.client.render.particle.ParticleEnergyField;
import com.brandon3055.draconicevolution.client.render.particle.ParticleReactorBeam;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.achievements.Achievements;
import com.brandon3055.draconicevolution.common.entity.EntityChaosBolt;
import com.brandon3055.draconicevolution.common.entity.EntityChaosCrystal;
import com.brandon3055.draconicevolution.common.entity.EntityChaosGuardian;
import com.brandon3055.draconicevolution.common.entity.EntityChaosVortex;
import com.brandon3055.draconicevolution.common.entity.EntityCustomDragon;
import com.brandon3055.draconicevolution.common.entity.EntityDraconicArrow;
import com.brandon3055.draconicevolution.common.entity.EntityDragonHeart;
import com.brandon3055.draconicevolution.common.entity.EntityDragonProjectile;
import com.brandon3055.draconicevolution.common.entity.EntityEnderArrow;
import com.brandon3055.draconicevolution.common.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.handler.CraftingHandler;
import com.brandon3055.draconicevolution.common.handler.FMLEventHandler;
import com.brandon3055.draconicevolution.common.handler.MinecraftForgeEventHandler;
import com.brandon3055.draconicevolution.common.lib.OreDoublingRegistry;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.magic.EnchantmentReaper;
import com.brandon3055.draconicevolution.common.magic.PotionHandler;
import com.brandon3055.draconicevolution.common.network.BlockUpdatePacket;
import com.brandon3055.draconicevolution.common.network.ButtonPacket;
import com.brandon3055.draconicevolution.common.network.GenericParticlePacket;
import com.brandon3055.draconicevolution.common.network.ItemConfigPacket;
import com.brandon3055.draconicevolution.common.network.MountUpdatePacket;
import com.brandon3055.draconicevolution.common.network.ParticleGenPacket;
import com.brandon3055.draconicevolution.common.network.PlacedItemPacket;
import com.brandon3055.draconicevolution.common.network.PlayerDetectorButtonPacket;
import com.brandon3055.draconicevolution.common.network.PlayerDetectorStringPacket;
import com.brandon3055.draconicevolution.common.network.SpeedRequestPacket;
import com.brandon3055.draconicevolution.common.network.TeleporterPacket;
import com.brandon3055.draconicevolution.common.network.TileObjectPacket;
import com.brandon3055.draconicevolution.common.network.ToolModePacket;
import com.brandon3055.draconicevolution.common.tileentities.TileCKeyStone;
import com.brandon3055.draconicevolution.common.tileentities.TileChaosShard;
import com.brandon3055.draconicevolution.common.tileentities.TileContainerTemplate;
import com.brandon3055.draconicevolution.common.tileentities.TileCustomSpawner;
import com.brandon3055.draconicevolution.common.tileentities.TileDissEnchanter;
import com.brandon3055.draconicevolution.common.tileentities.TileDraconiumChest;
import com.brandon3055.draconicevolution.common.tileentities.TileEnergyInfuser;
import com.brandon3055.draconicevolution.common.tileentities.TileGenerator;
import com.brandon3055.draconicevolution.common.tileentities.TileGrinder;
import com.brandon3055.draconicevolution.common.tileentities.TileParticleGenerator;
import com.brandon3055.draconicevolution.common.tileentities.TilePlacedItem;
import com.brandon3055.draconicevolution.common.tileentities.TilePlayerDetector;
import com.brandon3055.draconicevolution.common.tileentities.TilePlayerDetectorAdvanced;
import com.brandon3055.draconicevolution.common.tileentities.TilePotentiometer;
import com.brandon3055.draconicevolution.common.tileentities.TileSunDial;
import com.brandon3055.draconicevolution.common.tileentities.TileTeleporterStand;
import com.brandon3055.draconicevolution.common.tileentities.TileTestBlock;
import com.brandon3055.draconicevolution.common.tileentities.TileWeatherController;
import com.brandon3055.draconicevolution.common.tileentities.energynet.TileEnergyRelay;
import com.brandon3055.draconicevolution.common.tileentities.energynet.TileEnergyTransceiver;
import com.brandon3055.draconicevolution.common.tileentities.energynet.TileWirelessEnergyTransceiver;
import com.brandon3055.draconicevolution.common.tileentities.gates.TileFluidGate;
import com.brandon3055.draconicevolution.common.tileentities.gates.TileFluxGate;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileDislocatorReceptacle;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnderResurrection;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyPylon;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileInvisibleMultiblock;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TilePortalBlock;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorCore;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorEnergyInjector;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorStabilizer;
import com.brandon3055.draconicevolution.common.utills.DragonChunkLoader;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import com.brandon3055.draconicevolution.common.world.DraconicWorldGenerator;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.brandon3055.draconicevolution.integration.computers.CCOCIntegration;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import li.cil.oc.api.machine.Callback;
import net.minecraft.block.Block;
import net.minecraft.client.audio.ISound;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.init(event.getSuggestedConfigurationFile());
        this.registerEventListeners(event.getSide());
        ModBlocks.init();
        ModItems.init();
        this.registerTileEntities();
        this.initializeNetwork();
        this.registerOres();
        DraconicEvolution.reaperEnchant = new EnchantmentReaper(ConfigHandler.reaperEnchantID);
        Achievements.addModAchievements();
        LogHelper.info("Finished PreInitialization");
    }

    public void init(FMLInitializationEvent event) {
        CraftingHandler.init();
        this.registerGuiHandeler();
        this.registerWorldGen();
        this.registerEntities();
        DETab.initialize();
        PotionHandler.init();
        CCOCIntegration.init();
        ModHelper.init();
        DragonChunkLoader.init();
        LogHelper.info("Finished Initialization");
    }

    public void postInit(FMLPostInitializationEvent event) {
        OreDoublingRegistry.init();
        Achievements.registerAchievementPane();
        LogHelper.info("Finished PostInitialization");
    }

    public void initializeNetwork() {
        DraconicEvolution.network = NetworkRegistry.INSTANCE.newSimpleChannel("DEvolutionNC");
        DraconicEvolution.network.registerMessage(ButtonPacket.Handler.class, ButtonPacket.class, 0, Side.SERVER);
        DraconicEvolution.network.registerMessage(ParticleGenPacket.Handler.class, ParticleGenPacket.class, 1, Side.SERVER);
        DraconicEvolution.network.registerMessage(PlacedItemPacket.Handler.class, PlacedItemPacket.class, 2, Side.SERVER);
        DraconicEvolution.network.registerMessage(PlayerDetectorButtonPacket.Handler.class, PlayerDetectorButtonPacket.class, 3, Side.SERVER);
        DraconicEvolution.network.registerMessage(PlayerDetectorStringPacket.Handler.class, PlayerDetectorStringPacket.class, 4, Side.SERVER);
        DraconicEvolution.network.registerMessage(TeleporterPacket.Handler.class, TeleporterPacket.class, 5, Side.SERVER);
        DraconicEvolution.network.registerMessage(TileObjectPacket.Handler.class, TileObjectPacket.class, 6, Side.CLIENT);
        DraconicEvolution.network.registerMessage(MountUpdatePacket.Handler.class, MountUpdatePacket.class, 7, Side.CLIENT);
        DraconicEvolution.network.registerMessage(MountUpdatePacket.Handler.class, MountUpdatePacket.class, 8, Side.SERVER);
        DraconicEvolution.network.registerMessage(ItemConfigPacket.Handler.class, ItemConfigPacket.class, 9, Side.SERVER);
        DraconicEvolution.network.registerMessage(TileObjectPacket.Handler.class, TileObjectPacket.class, 10, Side.SERVER);
        DraconicEvolution.network.registerMessage(BlockUpdatePacket.Handler.class, BlockUpdatePacket.class, 11, Side.SERVER);
        DraconicEvolution.network.registerMessage(SpeedRequestPacket.Handler.class, SpeedRequestPacket.class, 12, Side.SERVER);
        DraconicEvolution.network.registerMessage(SpeedRequestPacket.Handler.class, SpeedRequestPacket.class, 13, Side.CLIENT);
        DraconicEvolution.network.registerMessage(ToolModePacket.Handler.class, ToolModePacket.class, 14, Side.SERVER);
        DraconicEvolution.network.registerMessage(GenericParticlePacket.Handler.class, GenericParticlePacket.class, 15, Side.CLIENT);
    }

    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileWeatherController.class, (String)(References.RESOURCESPREFIX + "TileWeatherController"));
        GameRegistry.registerTileEntity(TileSunDial.class, (String)(References.RESOURCESPREFIX + "TileSunDial"));
        GameRegistry.registerTileEntity(TileGrinder.class, (String)(References.RESOURCESPREFIX + "TileGrinder"));
        GameRegistry.registerTileEntity(TilePotentiometer.class, (String)(References.RESOURCESPREFIX + "TilePotentiometer"));
        GameRegistry.registerTileEntity(TileParticleGenerator.class, (String)(References.RESOURCESPREFIX + "TileParticleGenerator"));
        GameRegistry.registerTileEntity(TilePlayerDetector.class, (String)(References.RESOURCESPREFIX + "TilePlayerDetector"));
        GameRegistry.registerTileEntity(TilePlayerDetectorAdvanced.class, (String)(References.RESOURCESPREFIX + "TilePlayerDetectorAdvanced"));
        GameRegistry.registerTileEntity(TileEnergyInfuser.class, (String)(References.RESOURCESPREFIX + "TileEnergyInfuser"));
        GameRegistry.registerTileEntity(TileCustomSpawner.class, (String)(References.RESOURCESPREFIX + "TileCustomSpawner"));
        GameRegistry.registerTileEntity(TileGenerator.class, (String)(References.RESOURCESPREFIX + "TileGenerator"));
        GameRegistry.registerTileEntity(TileEnergyStorageCore.class, (String)(References.RESOURCESPREFIX + "TileEnergyStorageCore"));
        GameRegistry.registerTileEntity(TileInvisibleMultiblock.class, (String)(References.RESOURCESPREFIX + "TileInvisibleMultiblock"));
        GameRegistry.registerTileEntity(TileEnergyPylon.class, (String)(References.RESOURCESPREFIX + "TileEnergyPylon"));
        GameRegistry.registerTileEntity(TileEnderResurrection.class, (String)(References.RESOURCESPREFIX + "TileEnderResurrection"));
        GameRegistry.registerTileEntity(TilePlacedItem.class, (String)(References.RESOURCESPREFIX + "TilePlacedItem"));
        GameRegistry.registerTileEntity(TileCKeyStone.class, (String)(References.RESOURCESPREFIX + "TileCKeyStone"));
        GameRegistry.registerTileEntity(TileDissEnchanter.class, (String)(References.RESOURCESPREFIX + "TileDissEnchanter"));
        GameRegistry.registerTileEntity(TileTeleporterStand.class, (String)(References.RESOURCESPREFIX + "TileTeleporterStand"));
        GameRegistry.registerTileEntity(TileDraconiumChest.class, (String)(References.RESOURCESPREFIX + "TileDraconiumChest"));
        GameRegistry.registerTileEntity(TileEnergyRelay.class, (String)(References.RESOURCESPREFIX + "TileEnergyRelay"));
        GameRegistry.registerTileEntity(TileEnergyTransceiver.class, (String)(References.RESOURCESPREFIX + "TileEnergyTransceiver"));
        GameRegistry.registerTileEntity(TileWirelessEnergyTransceiver.class, (String)(References.RESOURCESPREFIX + "TileWirelessEnergyTransceiver"));
        GameRegistry.registerTileEntity(TileDislocatorReceptacle.class, (String)(References.RESOURCESPREFIX + "TileDislocatorReceptacle"));
        GameRegistry.registerTileEntity(TilePortalBlock.class, (String)(References.RESOURCESPREFIX + "TilePortalBlock"));
        GameRegistry.registerTileEntity(TileReactorCore.class, (String)(References.RESOURCESPREFIX + "TileReactorCore"));
        GameRegistry.registerTileEntity(TileFluxGate.class, (String)(References.RESOURCESPREFIX + "TileFluxGate"));
        GameRegistry.registerTileEntity(TileFluidGate.class, (String)(References.RESOURCESPREFIX + "TileFluidGate"));
        GameRegistry.registerTileEntity(TileReactorStabilizer.class, (String)(References.RESOURCESPREFIX + "TileReactorStabilizer"));
        GameRegistry.registerTileEntity(TileReactorEnergyInjector.class, (String)(References.RESOURCESPREFIX + "TileReactorEnergyInjector"));
        GameRegistry.registerTileEntity(TileChaosShard.class, (String)(References.RESOURCESPREFIX + "TileChaosShard"));
        if (DraconicEvolution.debug) {
            GameRegistry.registerTileEntity(TileTestBlock.class, (String)(References.RESOURCESPREFIX + "TileTestBlock"));
            GameRegistry.registerTileEntity(TileContainerTemplate.class, (String)(References.RESOURCESPREFIX + "TileContainerTemplate"));
        }
    }

    public void registerEventListeners(Side s) {
        MinecraftForge.EVENT_BUS.register((Object)new MinecraftForgeEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new Achievements());
        FMLCommonHandler.instance().bus().register((Object)new Achievements());
        FMLCommonHandler.instance().bus().register((Object)new FMLEventHandler());
    }

    public void registerGuiHandeler() {
        new GuiHandler();
    }

    public void registerWorldGen() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new DraconicWorldGenerator(), (int)0);
    }

    public void registerOres() {
        if (ModBlocks.isEnabled(ModBlocks.draconiumOre)) {
            OreDictionary.registerOre((String)"oreDraconium", (Block)ModBlocks.draconiumOre);
        }
        if (ModBlocks.isEnabled(ModBlocks.draconiumBlock)) {
            OreDictionary.registerOre((String)"blockDraconium", (ItemStack)new ItemStack((Block)ModBlocks.draconiumBlock));
        }
        if (ModBlocks.isEnabled(ModBlocks.draconicBlock)) {
            OreDictionary.registerOre((String)"blockDraconiumAwakened", (ItemStack)new ItemStack((Block)ModBlocks.draconicBlock));
        }
        if (ModItems.isEnabled(ModItems.draconiumIngot)) {
            OreDictionary.registerOre((String)"ingotDraconium", (Item)ModItems.draconiumIngot);
        }
        if (ModItems.isEnabled(ModItems.draconiumDust)) {
            OreDictionary.registerOre((String)"dustDraconium", (Item)ModItems.draconiumDust);
        }
        if (ModItems.isEnabled(ModItems.draconicIngot)) {
            OreDictionary.registerOre((String)"ingotDraconiumAwakened", (Item)ModItems.draconicIngot);
        }
        if (ModItems.isEnabled(ModItems.nugget)) {
            OreDictionary.registerOre((String)"nuggetDraconium", (ItemStack)ModItems.nuggetDraconium.func_77946_l());
            OreDictionary.registerOre((String)"nuggetDraconiumAwakened", (ItemStack)ModItems.nuggetAwakened.func_77946_l());
        }
    }

    @Callback
    public void registerEntities() {
        EntityRegistry.registerModEntity(EntityCustomDragon.class, (String)"EnderDragon", (int)0, (Object)DraconicEvolution.instance, (int)256, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityPersistentItem.class, (String)"Persistent Item", (int)1, (Object)DraconicEvolution.instance, (int)32, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityDraconicArrow.class, (String)"Arrow", (int)2, (Object)DraconicEvolution.instance, (int)32, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityEnderArrow.class, (String)"Ender Arrow", (int)3, (Object)DraconicEvolution.instance, (int)32, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityDragonHeart.class, (String)"Dragon Heart Item", (int)5, (Object)DraconicEvolution.instance, (int)32, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityChaosGuardian.class, (String)"ChaosGuardian", (int)6, (Object)DraconicEvolution.instance, (int)256, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityDragonProjectile.class, (String)"DragonProjectile", (int)7, (Object)DraconicEvolution.instance, (int)256, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityChaosCrystal.class, (String)"ChaosCrystal", (int)8, (Object)DraconicEvolution.instance, (int)256, (int)5, (boolean)false);
        EntityRegistry.registerModEntity(EntityChaosBolt.class, (String)"ChaosBolt", (int)9, (Object)DraconicEvolution.instance, (int)32, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityChaosVortex.class, (String)"EntityChaosEnergyVortex", (int)10, (Object)DraconicEvolution.instance, (int)512, (int)5, (boolean)true);
    }

    public ParticleEnergyBeam energyBeam(World worldObj, double x, double y, double z, double tx, double ty, double tz, int powerFlow, boolean advanced, ParticleEnergyBeam oldBeam, boolean render, int beamType) {
        return null;
    }

    public ParticleEnergyField energyField(World worldObj, double x, double y, double z, int type, boolean advanced, ParticleEnergyField oldBeam, boolean render) {
        return null;
    }

    public ParticleReactorBeam reactorBeam(TileEntity tile, ParticleReactorBeam oldBeam, boolean render) {
        return null;
    }

    public void spawnParticle(Object particle, int range) {
    }

    public ISound playISound(ISound sound) {
        return null;
    }
}

