/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.draconicevolution.client.handler.ResourceHandler;
import com.brandon3055.draconicevolution.common.ModItems;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class RenderBowModel
implements IItemRenderer {
    private boolean draconic;
    private IModelCustom[] wyvernModels = new IModelCustom[4];
    private IModelCustom[] draconicModels = new IModelCustom[4];
    private IModelCustom arrow;

    public RenderBowModel(boolean draconic) {
        int i;
        this.draconic = draconic;
        for (i = 0; i < 4; ++i) {
            this.wyvernModels[i] = AdvancedModelLoader.loadModel((ResourceLocation)ResourceHandler.getResource("models/tools/WyvernBow0" + i + ".obj"));
        }
        for (i = 0; i < 4; ++i) {
            this.draconicModels[i] = AdvancedModelLoader.loadModel((ResourceLocation)ResourceHandler.getResource("models/tools/DraconicBow0" + i + ".obj"));
        }
        this.arrow = AdvancedModelLoader.loadModel((ResourceLocation)ResourceHandler.getResource("models/tools/ArrowCommon.obj"));
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        String currentMode = ItemNBTHelper.getString((ItemStack)item, (String)"mode", (String)"rapidfire");
        int j = 0;
        if (data.length >= 2 && data[1] instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)data[1];
            if (player.field_71071_by.func_146028_b((Item)ModItems.enderArrow)) {
                currentMode = "sharpshooter";
            }
            j = player.func_71057_bx();
        }
        IModelCustom activeModel = null;
        int selection = 0;
        if (this.draconic) {
            if (currentMode.equals("rapidfire")) {
                if (j >= 4) {
                    selection = 3;
                } else if (j > 2) {
                    selection = 2;
                } else if (j > 0) {
                    selection = 1;
                }
            } else if (currentMode.equals("devistation")) {
                if (j >= 2) {
                    selection = 3;
                } else if (j > 1) {
                    selection = 2;
                } else if (j > 0) {
                    selection = 1;
                }
            } else if (currentMode.equals("sharpshooter")) {
                if (j >= 20) {
                    selection = 3;
                } else if (j > 10) {
                    selection = 2;
                } else if (j > 0) {
                    selection = 1;
                }
            } else if (j >= 80) {
                selection = 3;
            } else if (j > 40) {
                selection = 2;
            } else if (j > 0) {
                selection = 1;
            }
            activeModel = this.draconicModels[selection];
            ResourceHandler.bindResource("textures/models/tools/DraconicBow0" + selection + ".png");
        } else {
            if (currentMode.equals("rapidfire")) {
                if (j >= 13) {
                    selection = 2;
                } else if (j > 7) {
                    selection = 1;
                } else if (j > 0) {
                    selection = 0;
                }
            } else if (currentMode.equals("sharpshooter")) {
                if (j >= 30) {
                    selection = 2;
                } else if (j > 15) {
                    selection = 1;
                } else if (j > 0) {
                    selection = 0;
                }
            }
            activeModel = this.draconicModels[selection];
            ResourceHandler.bindResource("textures/models/tools/WyvernBow0" + selection + ".png");
        }
        if (activeModel != null) {
            this.doRender(activeModel, type, j > 0 ? selection : -1);
        }
        GL11.glPopMatrix();
    }

    private void doRender(IModelCustom modelCustom, IItemRenderer.ItemRenderType type, int drawState) {
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
            GL11.glTranslated((double)0.7, (double)0.0, (double)0.2);
            GL11.glRotatef((float)87.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)190.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
            GL11.glTranslated((double)0.7, (double)0.7, (double)0.2);
            GL11.glRotatef((float)130.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glScalef((float)6.0f, (float)6.0f, (float)6.0f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)0.0, (double)0.0, (double)1.5);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glRotatef((float)-34.5f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)-1.1, (double)0.0, (double)-0.2);
        }
        modelCustom.renderAll();
        GL11.glTranslated((double)0.3, (double)0.151, (double)(-0.2 + (drawState == 1 ? 0.0 : (drawState == 2 ? 0.55 : (drawState == 3 ? 1.0 : -0.7)))));
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (drawState != -1) {
            this.arrow.renderAll();
        }
    }
}

