/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.componentguis;

import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentBase;
import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentButton;
import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentCollection;
import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentTextureButton;
import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentTexturedRect;
import com.brandon3055.brandonscore.client.gui.guicomponents.GUIBase;
import com.brandon3055.brandonscore.client.utills.GuiHelper;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.client.handler.ResourceHandler;
import com.brandon3055.draconicevolution.common.container.ContainerReactor;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorCore;
import java.util.ArrayList;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GUIReactor
extends GUIBase {
    private TileReactorCore reactor;
    private ContainerReactor container;
    private static boolean showStats = false;

    public GUIReactor(EntityPlayer player, TileReactorCore reactor, ContainerReactor container) {
        super((Container)container, 248, 222);
        this.reactor = reactor;
        this.container = container;
    }

    protected ComponentCollection assembleComponents() {
        this.collection = new ComponentCollection(0, 0, 248, 222, (GUIBase)this);
        this.collection.addComponent((ComponentBase)new ComponentTexturedRect(0, 0, this.field_146999_f, this.field_147000_g, ResourceHandler.getResource("textures/gui/Reactor.png")));
        this.collection.addComponent((ComponentBase)new ComponentTextureButton(14, 190, 18, 162, 18, 18, 0, (GUIBase)this, "", StatCollector.func_74838_a((String)"button.de.reactorCharge.txt"), ResourceHandler.getResource("textures/gui/Widgets.png"))).setName("CHARGE");
        this.collection.addComponent((ComponentBase)new ComponentTextureButton(14, 190, 18, 54, 18, 18, 1, (GUIBase)this, "", StatCollector.func_74838_a((String)"button.de.reactorStart.txt"), ResourceHandler.getResource("textures/gui/Widgets.png"))).setName("ACTIVATE");
        this.collection.addComponent((ComponentBase)new ComponentTextureButton(216, 190, 18, 108, 18, 18, 2, (GUIBase)this, "", StatCollector.func_74838_a((String)"button.de.reactorStop.txt"), ResourceHandler.getResource("textures/gui/Widgets.png"))).setName("DEACTIVATE");
        this.collection.addComponent((ComponentBase)new ComponentButton(9, 120, 43, 15, 3, (GUIBase)this, StatCollector.func_74838_a((String)"button.de.stats.txt"), StatCollector.func_74838_a((String)"button.de.statsShow.txt"))).setName("STATS");
        return this.collection;
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
        if (this.reactor.reactorState == 0) {
            RenderHelper.func_74520_c();
            this.func_73729_b(this.field_147003_i + 14, this.field_147009_r + 139, 14, this.field_147000_g, 18, 18);
            this.func_73729_b(this.field_147003_i + 216, this.field_147009_r + 139, 32, this.field_147000_g, 18, 18);
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.insert.txt"), this.field_147003_i + 8, this.field_147009_r + 159, 0);
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.fuel.txt"), this.field_147003_i + 13, this.field_147009_r + 168, 0);
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.extract.txt"), this.field_147003_i + 206, this.field_147009_r + 159, 0);
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.fuel.txt"), this.field_147003_i + 215, this.field_147009_r + 168, 0);
        }
        this.func_73732_a(this.field_146289_q, "Draconic Reactor", this.field_147003_i + this.field_146999_f / 2, this.field_147009_r + 4, 65535);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        ResourceHandler.bindResource("textures/gui/Reactor.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double value = Math.min(this.reactor.reactionTemperature, this.reactor.maxReactTemperature) / this.reactor.maxReactTemperature;
        int pixOffset = (int)(value * 108.0);
        this.func_73729_b(11, 112 - pixOffset, 0, 222, 14, 5);
        value = this.reactor.fieldCharge / this.reactor.maxFieldCharge;
        pixOffset = (int)(value * 108.0);
        this.func_73729_b(35, 112 - pixOffset, 0, 222, 14, 5);
        value = (double)this.reactor.energySaturation / (double)this.reactor.maxEnergySaturation;
        pixOffset = (int)(value * 108.0);
        this.func_73729_b(199, 112 - pixOffset, 0, 222, 14, 5);
        value = (double)this.reactor.convertedFuel / ((double)this.reactor.reactorFuel + (double)this.reactor.convertedFuel);
        pixOffset = (int)(value * 108.0);
        this.func_73729_b(223, 112 - pixOffset, 0, 222, 14, 5);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!showStats) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            GL11.glTranslated((double)124.0, (double)71.0, (double)100.0);
            double scale = 100.0 / this.reactor.getCoreDiameter();
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2884);
            TileEntityRendererDispatcher.field_147556_a.func_147549_a((TileEntity)this.reactor, -0.5, -0.5, -0.5, 0.0f);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        } else {
            ResourceHandler.bindResource("textures/gui/Reactor.png");
            for (int i = 1; i <= 10; ++i) {
                this.func_73729_b(63, i * 12, 0, 240, 122, 16);
            }
            this.drawStats();
        }
        String status = StatCollector.func_74838_a((String)"gui.de.status.txt") + ": " + (this.reactor.reactorState == 0 ? EnumChatFormatting.DARK_GRAY : (this.reactor.reactorState == 1 ? EnumChatFormatting.RED : (this.reactor.reactorState == 2 ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.RED))) + StatCollector.func_74838_a((String)("gui.de.status" + this.reactor.reactorState + ".txt"));
        if (this.reactor.reactorState == 1 && this.reactor.canStart()) {
            status = StatCollector.func_74838_a((String)"gui.de.status.txt") + ": " + EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"gui.de.status1_5.txt");
        }
        if (!showStats) {
            this.field_146289_q.func_78276_b(status, this.field_146999_f - 5 - this.field_146289_q.func_78256_a(status), 125, 0);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        super.func_73863_a(mouseX, mouseY, par3);
        ArrayList<String> text = new ArrayList<String>();
        if (GuiHelper.isInRect((int)9, (int)4, (int)18, (int)114, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
            text.add(StatCollector.func_74838_a((String)"gui.de.reactionTemp.txt"));
            text.add((int)this.reactor.reactionTemperature + "\u00c2\u00b0C");
            this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
        } else if (GuiHelper.isInRect((int)33, (int)4, (int)18, (int)114, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
            text.add(StatCollector.func_74838_a((String)"gui.de.fieldStrength.txt"));
            if (this.reactor.maxFieldCharge > 0.0) {
                text.add(Utills.round((double)(this.reactor.fieldCharge / this.reactor.maxFieldCharge * 100.0), (double)100.0) + "%");
            }
            text.add(Utills.addCommas((int)((int)this.reactor.fieldCharge)) + " / " + Utills.addCommas((int)((int)this.reactor.maxFieldCharge)));
            this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
        } else if (GuiHelper.isInRect((int)197, (int)4, (int)18, (int)114, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
            text.add(StatCollector.func_74838_a((String)"gui.de.energySaturation.txt"));
            if (this.reactor.maxEnergySaturation > 0) {
                text.add(Utills.round((double)((double)this.reactor.energySaturation / (double)this.reactor.maxEnergySaturation * 100.0), (double)100.0) + "%");
            }
            text.add(Utills.addCommas((int)this.reactor.energySaturation) + " / " + Utills.addCommas((int)this.reactor.maxEnergySaturation));
            this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
        } else if (GuiHelper.isInRect((int)221, (int)4, (int)18, (int)114, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
            text.add(StatCollector.func_74838_a((String)"gui.de.fuelConversion.txt"));
            if (this.reactor.reactorFuel + this.reactor.convertedFuel > 0) {
                text.add(Utills.round((double)(((double)this.reactor.convertedFuel + this.reactor.conversionUnit) / ((double)this.reactor.convertedFuel + (double)this.reactor.reactorFuel) * 100.0), (double)100.0) + "%");
            }
            text.add(this.reactor.convertedFuel + " / " + (this.reactor.convertedFuel + this.reactor.reactorFuel));
            this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
        } else if (GuiHelper.isInRect((int)53, (int)15, (int)140, (int)18, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
            text.addAll(this.field_146289_q.func_78271_c(StatCollector.func_74838_a((String)"gui.de.reacTempLoadFactor.txt"), 200));
            this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
        } else if (GuiHelper.isInRect((int)53, (int)40, (int)140, (int)18, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
            text.addAll(this.field_146289_q.func_78271_c(StatCollector.func_74838_a((String)"gui.de.reacCoreMass.txt"), 200));
            this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
        } else if (GuiHelper.isInRect((int)53, (int)65, (int)140, (int)18, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
            text.addAll(this.field_146289_q.func_78271_c(StatCollector.func_74838_a((String)"gui.de.reacGenRate.txt"), 200));
            this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
        } else if (GuiHelper.isInRect((int)53, (int)88, (int)140, (int)18, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
            text.addAll(this.field_146289_q.func_78271_c(StatCollector.func_74838_a((String)"gui.de.reacInputRate.txt"), 200));
            this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
        } else if (GuiHelper.isInRect((int)53, (int)113, (int)140, (int)18, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r))) {
            text.addAll(this.field_146289_q.func_78271_c(StatCollector.func_74838_a((String)"gui.de.reacConversionRate.txt"), 200));
            this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
        }
    }

    private void drawStats() {
        double inputRate = (double)this.reactor.fieldDrain / (1.0 - this.reactor.fieldCharge / this.reactor.maxFieldCharge);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.tempLoad.name"), 55, 16, 255);
        this.field_146289_q.func_78276_b(Utills.round((double)(this.reactor.tempDrainFactor * 100.0), (double)1.0) + "%", 60, 26, 0);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.mass.name"), 55, 40, 255);
        this.field_146289_q.func_78276_b(Utills.round((double)((double)(this.reactor.reactorFuel + this.reactor.convertedFuel) / 1296.0), (double)100.0) + "m^3", 60, 50, 0);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.genRate.name"), 55, 64, 255);
        this.field_146289_q.func_78276_b(Utills.addCommas((int)((int)this.reactor.generationRate)) + "RF/t", 60, 74, 0);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.fieldInputRate.name"), 55, 88, 255);
        this.field_146289_q.func_78276_b(Utills.addCommas((int)((int)Math.min(inputRate, 2.147483647E9))) + "RF/t", 60, 98, 0);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.de.fuelConversion.name"), 55, 112, 255);
        this.field_146289_q.func_78276_b(Utills.addCommas((int)((int)Math.round(this.reactor.fuelUseRate * 1000000.0))) + "nb/t", 60, 122, 0);
    }

    public void func_73876_c() {
        if (this.reactor.reactorState == 4 || this.reactor.reactorState == 0 || this.reactor.reactorState == 3) {
            this.collection.getComponent("DEACTIVATE").setEnabled(false);
        } else {
            this.collection.getComponent("DEACTIVATE").setEnabled(true);
        }
        if ((this.reactor.reactorState == 0 || this.reactor.reactorState == 3 && !this.reactor.canStart()) && this.reactor.canCharge()) {
            this.collection.getComponent("CHARGE").setEnabled(true);
        } else {
            this.collection.getComponent("CHARGE").setEnabled(false);
        }
        if ((this.reactor.reactorState == 1 || this.reactor.reactorState == 3) && this.reactor.canStart()) {
            this.collection.getComponent("ACTIVATE").setEnabled(true);
        } else {
            this.collection.getComponent("ACTIVATE").setEnabled(false);
        }
        super.func_73876_c();
    }

    public void buttonClicked(int id, int button) {
        super.buttonClicked(id, button);
        if (id < 3) {
            this.container.sendObjectToServer(null, 20, id);
        } else if (id == 3) {
            showStats = !showStats;
            ((ComponentButton)this.collection.getComponent((String)"STATS")).hoverText = showStats ? StatCollector.func_74838_a((String)"button.de.statsHide.txt") : StatCollector.func_74838_a((String)"button.de.statsShow.txt");
        }
    }
}

