/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.oc.asm.peripheral;

import java.util.Map;
import java.util.Set;
import li.cil.oc.api.network.Node;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.composed.IndexedMethodMap;
import openperipheral.api.architecture.IAttachable;
import openperipheral.api.architecture.oc.IOpenComputersAttachable;
import openperipheral.interfaces.oc.asm.CommonMethodsBuilder;
import openperipheral.interfaces.oc.asm.ICodeGenerator;
import openperipheral.interfaces.oc.asm.Utils;
import openperipheral.interfaces.oc.asm.peripheral.PeripheralEnvironmentBase;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class PeripheralCodeGenerator
implements ICodeGenerator {
    private static final Type BASE_TYPE = Type.getType(PeripheralEnvironmentBase.class);
    private static final Type ATTACHABLE_TYPE = Type.getType(IAttachable.class);
    private static final Type NODE_TYPE = Type.getType(Node.class);
    private static final Type OC_ATTACHABLE_TYPE = Type.getType(IOpenComputersAttachable.class);
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final Type SUPER_CTOR_TYPE = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[]{OBJECT_TYPE});
    private static final Type ATTACHABLE_WRAP_TYPE = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[]{ATTACHABLE_TYPE, NODE_TYPE});
    private static final Type OC_ATTACHABLE_WRAP_TYPE = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[]{OC_ATTACHABLE_TYPE, NODE_TYPE});
    private static final Type CONNECTIVITY_METHOD_TYPE = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[]{NODE_TYPE});

    @Override
    public byte[] generate(String clsName, Class<?> targetClass, Set<Class<?>> exposedInterfaces, IndexedMethodMap methods, int methodsId) {
        ClassWriter writer = new ClassWriter(3);
        writer.visit(50, 4145, clsName, null, BASE_TYPE.getInternalName(), Utils.getInterfaces(exposedInterfaces));
        Type targetType = Type.getType(targetClass);
        CommonMethodsBuilder builder = new CommonMethodsBuilder(writer, clsName, targetType);
        builder.addTargetField();
        builder.addMethodsField();
        builder.addClassInit(methodsId);
        PeripheralCodeGenerator.createConstructor(writer, clsName, targetType);
        Map<Method, Type> exposedMethods = Utils.getExposedMethods(exposedInterfaces);
        for (Map.Entry<Method, Type> e : exposedMethods.entrySet()) {
            builder.addExposedMethodBypass(e.getKey(), e.getValue());
        }
        for (int i = 0; i < methods.size(); ++i) {
            String name = methods.getMethodName(i);
            IMethodExecutor executor = methods.getMethod(i);
            builder.createScriptMethodWrapper(name, i, executor);
        }
        boolean isAttachable = IAttachable.class.isAssignableFrom(targetClass);
        boolean isOcAttachable = IOpenComputersAttachable.class.isAssignableFrom(targetClass);
        if (isAttachable || isOcAttachable) {
            this.visitConnectivityMethod("onConnect", clsName, writer, targetType, isAttachable, isOcAttachable);
            this.visitConnectivityMethod("onDisconnect", clsName, writer, targetType, isAttachable, isOcAttachable);
        }
        writer.visitEnd();
        return writer.toByteArray();
    }

    private static void createConstructor(ClassWriter writer, String clsName, Type targetType) {
        Type ctorType = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[]{targetType});
        MethodVisitor init = writer.visitMethod(4097, "<init>", ctorType.getDescriptor(), null, null);
        init.visitCode();
        init.visitVarInsn(25, 0);
        init.visitVarInsn(25, 1);
        init.visitInsn(92);
        init.visitMethodInsn(183, BASE_TYPE.getInternalName(), "<init>", SUPER_CTOR_TYPE.getDescriptor());
        init.visitFieldInsn(181, clsName, "target", targetType.getDescriptor());
        init.visitInsn(177);
        init.visitMaxs(0, 0);
        init.visitEnd();
    }

    protected void visitConnectivityMethod(String methodName, String clsName, ClassWriter writer, Type targetType, boolean isAttachable, boolean isOcAttachable) {
        MethodVisitor onConnect = writer.visitMethod(4097, methodName, CONNECTIVITY_METHOD_TYPE.getDescriptor(), null, null);
        onConnect.visitCode();
        if (isAttachable) {
            onConnect.visitVarInsn(25, 0);
            onConnect.visitInsn(89);
            onConnect.visitFieldInsn(180, clsName, "target", targetType.getDescriptor());
            onConnect.visitVarInsn(25, 1);
            onConnect.visitMethodInsn(182, clsName, methodName, ATTACHABLE_WRAP_TYPE.getDescriptor());
        }
        if (isOcAttachable) {
            onConnect.visitVarInsn(25, 0);
            onConnect.visitFieldInsn(180, clsName, "target", targetType.getDescriptor());
            onConnect.visitVarInsn(25, 1);
            onConnect.visitMethodInsn(184, clsName, methodName, OC_ATTACHABLE_WRAP_TYPE.getDescriptor());
        }
        onConnect.visitInsn(177);
        onConnect.visitMaxs(0, 0);
        onConnect.visitEnd();
    }
}

