/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.cc.wrappers;

import com.google.common.base.Preconditions;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Arrays;
import openmods.Log;
import openmods.utils.CachedFactory;
import openperipheral.adapter.AdapterLogicException;
import openperipheral.adapter.IMethodCall;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.PeripheralTypeProvider;
import openperipheral.adapter.composed.IndexedMethodMap;
import openperipheral.api.architecture.IArchitectureAccess;
import openperipheral.api.architecture.IAttachable;
import openperipheral.api.architecture.cc.IComputerCraftAttachable;
import openperipheral.api.peripheral.IOpenPeripheral;
import openperipheral.interfaces.cc.ModuleComputerCraft;
import openperipheral.interfaces.cc.StringMount;
import openperipheral.interfaces.cc.SynchronousExecutor;
import openperipheral.interfaces.cc.UtilsResourceMount;
import openperipheral.util.DocUtils;
import org.apache.logging.log4j.Level;

public class AdapterPeripheral
implements IPeripheral,
IOpenPeripheral {
    private static final String MOUNT_NAME = "openp";
    private static final IMount MOUNT = new UtilsResourceMount();
    protected final String type;
    protected final Object target;
    private final IMount docMount;
    private final IndexedMethodMap methods;
    private final CachedFactory<IComputerAccess, IArchitectureAccess> accessCache = new CachedFactory<IComputerAccess, IArchitectureAccess>(){

        protected IArchitectureAccess create(IComputerAccess computer) {
            return ModuleComputerCraft.ENV.createAccess(computer);
        }
    };

    public AdapterPeripheral(IndexedMethodMap methods, Object target) {
        this.methods = methods;
        this.type = PeripheralTypeProvider.INSTANCE.generateType(target);
        this.target = target;
        this.docMount = new StringMount(DocUtils.createPeripheralHelpText(target.getClass(), this.type, methods));
    }

    public String getType() {
        return this.type;
    }

    public String[] getMethodNames() {
        return this.methods.getMethodNames();
    }

    private Object[] call(int methodIndex, IMethodExecutor executor, IComputerAccess computer, ILuaContext context, Object[] arguments) throws LuaException, InterruptedException {
        try {
            IMethodCall call = executor.startCall(this.target);
            return ModuleComputerCraft.ENV.addPeripheralArgs(call, computer, context).call(arguments);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (LuaException e) {
            throw e;
        }
        catch (Throwable e) {
            String methodName = this.methods.getMethodName(methodIndex);
            Log.log((Level)Level.DEBUG, (Throwable)e, (String)"Error during method %s(%d) execution on peripheral %s, args: %s", (Object[])new Object[]{methodName, methodIndex, this.type, Arrays.toString(arguments)});
            throw new LuaException(AdapterLogicException.getMessageForThrowable(e));
        }
    }

    public Object[] callMethod(final IComputerAccess computer, final ILuaContext context, final int index, final Object[] arguments) throws LuaException, InterruptedException {
        computer.getAttachmentName();
        final IMethodExecutor method = this.methods.getMethod(index);
        Preconditions.checkNotNull((Object)method, (String)"Invalid method index: %d", (Object[])new Object[]{index});
        if (method.isAsynchronous()) {
            return this.call(index, method, computer, context, arguments);
        }
        Object[] results = SynchronousExecutor.executeInMainThread(context, new SynchronousExecutor.Task(){

            @Override
            public Object[] execute() throws LuaException, InterruptedException {
                return AdapterPeripheral.this.call(index, method, computer, context, arguments);
            }
        });
        return results;
    }

    public void attach(IComputerAccess computer) {
        computer.mount(MOUNT_NAME, MOUNT);
        computer.mount("rom/help/" + computer.getAttachmentName(), this.docMount);
        if (this.target instanceof IAttachable) {
            IArchitectureAccess access = (IArchitectureAccess)this.accessCache.getOrCreate((Object)computer);
            ((IAttachable)this.target).addComputer(access);
        }
        if (this.target instanceof IComputerCraftAttachable) {
            ((IComputerCraftAttachable)this.target).addComputer(computer);
        }
    }

    public void detach(IComputerAccess computer) {
        IArchitectureAccess access;
        if (this.target instanceof IAttachable && (access = (IArchitectureAccess)this.accessCache.remove((Object)computer)) != null) {
            ((IAttachable)this.target).removeComputer(access);
        }
        if (this.target instanceof IComputerCraftAttachable) {
            ((IComputerCraftAttachable)this.target).removeComputer(computer);
        }
    }

    public boolean equals(IPeripheral other) {
        if (other == this) {
            return true;
        }
        if (other instanceof AdapterPeripheral) {
            return ((AdapterPeripheral)other).target == this.target;
        }
        return false;
    }
}

