/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.converter.inbound;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import openperipheral.api.converter.IConverter;
import openperipheral.api.converter.IGenericInboundTypeConverter;
import openperipheral.converter.TypeConverter;

public class ConverterSetInbound
implements IGenericInboundTypeConverter {
    private static final TypeVariable<?> TYPE_PARAM = Set.class.getTypeParameters()[0];

    private static boolean isTruthish(Object v) {
        if (v == null) {
            return false;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof Number) {
            return ((Number)v).doubleValue() != 0.0;
        }
        if (v instanceof String) {
            return !Strings.isNullOrEmpty((String)((String)v));
        }
        if (v instanceof Map) {
            return !((Map)v).isEmpty();
        }
        if (v instanceof Collection) {
            return !((Collection)v).isEmpty();
        }
        return false;
    }

    @Override
    public Object toJava(IConverter registry, Object obj, Type expected) {
        TypeToken type;
        if (obj instanceof Map && (type = TypeToken.of((Type)expected)).getRawType() == Set.class) {
            Type valueType = type.resolveType(TYPE_PARAM).getType();
            HashSet result = Sets.newHashSet();
            for (Map.Entry e : ((Map)obj).entrySet()) {
                Object value = e.getKey();
                Object marker = e.getValue();
                if (!ConverterSetInbound.isTruthish(marker)) continue;
                Object converted = TypeConverter.nullableToJava(registry, value, valueType);
                result.add(converted);
            }
            return result;
        }
        return null;
    }
}

