/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.property;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import openperipheral.adapter.IMethodCall;
import openperipheral.adapter.IMethodDescription;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.property.IPropertyExecutor;
import openperipheral.api.converter.IConverter;

public class PropertyExecutor
implements IMethodExecutor {
    public static final Map<String, Class<?>> NEEDED_ENV = ImmutableMap.of((Object)"converter", IConverter.class);
    private final IMethodDescription description;
    private final IPropertyExecutor caller;

    public PropertyExecutor(IMethodDescription description, IPropertyExecutor caller) {
        this.description = description;
        this.caller = caller;
    }

    @Override
    public IMethodDescription description() {
        return this.description;
    }

    @Override
    public IMethodCall startCall(final Object target) {
        return new IMethodCall(){
            private IConverter converter;

            @Override
            public IMethodCall setEnv(String name, Object value) {
                if ("converter".equals(name)) {
                    this.converter = (IConverter)value;
                }
                return this;
            }

            @Override
            public Object[] call(Object ... args) {
                Preconditions.checkNotNull((Object)this.converter, (Object)"Converter not provided");
                return PropertyExecutor.this.caller.call(this.converter, target, args);
            }
        };
    }

    @Override
    public boolean isAsynchronous() {
        return true;
    }

    @Override
    public boolean canInclude(String architecture) {
        return true;
    }

    @Override
    public Map<String, Class<?>> requiredEnv() {
        return NEEDED_ENV;
    }
}

