/*
 * Decompiled with CFR 0.152.
 */
package openperipheral;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.discovery.ASMDataTable;
import openmods.Log;
import openmods.access.ApiFactory;
import openmods.access.ApiProviderBase;
import openmods.access.ApiProviderRegistry;
import openperipheral.adapter.AdapterRegistryWrapper;
import openperipheral.adapter.PeripheralTypeProvider;
import openperipheral.adapter.TileEntityBlacklist;
import openperipheral.adapter.types.classifier.TypeClassifier;
import openperipheral.api.ApiAccess;
import openperipheral.api.ApiHolder;
import openperipheral.api.IApiInterface;
import openperipheral.converter.TypeConvertersProvider;
import openperipheral.interfaces.cc.ModuleComputerCraft;
import openperipheral.interfaces.oc.ModuleOpenComputers;
import openperipheral.meta.EntityMetadataBuilder;
import openperipheral.meta.ItemStackMetadataBuilder;

public class ApiSetup {
    private final ApiProviderRegistry<IApiInterface> registry = new ApiProviderRegistry(IApiInterface.class);

    ApiSetup() {
    }

    public void setupApis() {
        this.registry.registerClass(AdapterRegistryWrapper.Peripherals.class);
        this.registry.registerClass(AdapterRegistryWrapper.Objects.class);
        this.registry.registerClass(EntityMetadataBuilder.class);
        this.registry.registerClass(ItemStackMetadataBuilder.class);
        this.registry.registerInstance((Object)TypeConvertersProvider.INSTANCE);
        this.registry.registerInstance((Object)TileEntityBlacklist.INSTANCE);
        this.registry.registerInstance((Object)PeripheralTypeProvider.INSTANCE);
        this.registry.registerInstance((Object)TypeClassifier.INSTANCE);
        if (Loader.isModLoaded((String)"ComputerCraft")) {
            ModuleComputerCraft.installAPI(this.registry);
        }
        if (Loader.isModLoaded((String)"OpenComputers")) {
            ModuleOpenComputers.installAPI(this.registry);
        }
        this.registry.freeze();
    }

    public void installHolderAccess(ASMDataTable table) {
        ApiFactory.instance.createApi(ApiHolder.class, IApiInterface.class, table, this.registry);
    }

    void installProviderAccess() {
        String apiSource;
        String presentApiVersion;
        try {
            presentApiVersion = "3.3.2";
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to get OpenPeripheralCore API version, class missing?", t);
        }
        try {
            apiSource = ApiAccess.class.getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (Throwable t) {
            apiSource = "<unknown, see logs>";
            Log.severe((Throwable)t, (String)"Failed to get OpenPeripheralCore API source", (Object[])new Object[0]);
        }
        Preconditions.checkState((boolean)"3.3.2".equals(presentApiVersion), (String)"OpenPeripheralCore version mismatch, should be %s, is %s (ApiAccess source: %s)", (Object[])new Object[]{"3.3.2", presentApiVersion, apiSource});
        try {
            ApiAccess.init(new LegacyApiAccess(this.registry));
        }
        catch (Throwable t) {
            throw new IllegalStateException(String.format("Failed to register OpenPeripheralCore API provider (ApiAccess source: %s)", apiSource), t);
        }
        Log.info((String)"OPC API v. %s provideded by OpenPeripheralCore, (ApiAccess source: %s)", (Object[])new Object[]{presentApiVersion, apiSource});
    }

    private static class LegacyApiAccess
    extends ApiProviderBase<IApiInterface>
    implements ApiAccess.ApiProvider {
        public LegacyApiAccess(ApiProviderRegistry<IApiInterface> apiRegistry) {
            super(apiRegistry);
        }
    }
}

