/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.statuseffecthud;

import bspkrs.client.util.HUDUtils;
import bspkrs.statuseffecthud.ConfigElement;
import bspkrs.statuseffecthud.fml.Reference;
import bspkrs.util.CommonUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;
import org.lwjgl.opengl.GL11;

public class StatusEffectHUD {
    protected static float zLevel = -150.0f;
    private static ScaledResolution scaledResolution;
    private static final boolean enabledDefault = true;
    public static boolean enabled;
    private static final String alignModeDefault = "middleright";
    public static String alignMode;
    private static final boolean disableInventoryEffectListDefault = true;
    public static boolean disableInventoryEffectList;
    private static final boolean enableBackgroundDefault = false;
    public static boolean enableBackground;
    private static final boolean enableEffectNameDefault = true;
    public static boolean enableEffectName;
    private static final boolean enableIconBlinkDefault = true;
    public static boolean enableIconBlink;
    private static final int durationBlinkSecondsDefault = 10;
    public static int durationBlinkSeconds;
    private static final String effectNameColorDefault = "f";
    public static String effectNameColor;
    private static final String durationColorDefault = "f";
    public static String durationColor;
    private static final int xOffsetDefault = 2;
    public static int xOffset;
    private static final int yOffsetDefault = 2;
    public static int yOffset;
    private static final int yOffsetBottomCenterDefault = 41;
    public static int yOffsetBottomCenter;
    private static final boolean applyXOffsetToCenterDefault = false;
    public static boolean applyXOffsetToCenter;
    private static final boolean applyYOffsetToMiddleDefault = false;
    public static boolean applyYOffsetToMiddle;
    private static final boolean showInChatDefault = true;
    public static boolean showInChat;
    private static Map<PotionEffect, Integer> potionMaxDurationMap;

    public static void initConfig(File file) {
        if (!CommonUtils.isObfuscatedEnv()) {
            // empty if block
        }
        Reference.config = new Configuration(file);
        StatusEffectHUD.syncConfig();
    }

    public static void syncConfig() {
        String ctgyGen = "general";
        Reference.config.load();
        Reference.config.setCategoryComment(ctgyGen, "ATTENTION: Editing this file manually is no longer necessary. \nType the command '/statuseffect config' without the quotes in-game to modify these settings.");
        ArrayList<String> orderedKeys = new ArrayList<String>(ConfigElement.values().length);
        enabled = Reference.config.getBoolean(ConfigElement.ENABLED.key(), ctgyGen, true, ConfigElement.ENABLED.desc(), ConfigElement.ENABLED.languageKey());
        orderedKeys.add(ConfigElement.ENABLED.key());
        alignMode = Reference.config.getString(ConfigElement.ALIGN_MODE.key(), ctgyGen, alignModeDefault, ConfigElement.ALIGN_MODE.desc(), ConfigElement.ALIGN_MODE.validStrings(), ConfigElement.ALIGN_MODE.languageKey());
        orderedKeys.add(ConfigElement.ALIGN_MODE.key());
        disableInventoryEffectList = Reference.config.getBoolean(ConfigElement.DISABLE_INV_EFFECT_LIST.key(), ctgyGen, true, ConfigElement.DISABLE_INV_EFFECT_LIST.desc(), ConfigElement.DISABLE_INV_EFFECT_LIST.languageKey());
        orderedKeys.add(ConfigElement.DISABLE_INV_EFFECT_LIST.key());
        showInChat = Reference.config.getBoolean(ConfigElement.SHOW_IN_CHAT.key(), ctgyGen, true, ConfigElement.SHOW_IN_CHAT.desc(), ConfigElement.SHOW_IN_CHAT.languageKey());
        orderedKeys.add(ConfigElement.SHOW_IN_CHAT.key());
        enableBackground = Reference.config.getBoolean(ConfigElement.ENABLE_BACKGROUND.key(), ctgyGen, false, ConfigElement.ENABLE_BACKGROUND.desc(), ConfigElement.ENABLE_BACKGROUND.languageKey());
        orderedKeys.add(ConfigElement.ENABLE_BACKGROUND.key());
        enableEffectName = Reference.config.getBoolean(ConfigElement.ENABLE_EFFECT_NAME.key(), ctgyGen, true, ConfigElement.ENABLE_EFFECT_NAME.desc(), ConfigElement.ENABLE_EFFECT_NAME.languageKey());
        orderedKeys.add(ConfigElement.ENABLE_EFFECT_NAME.key());
        effectNameColor = Reference.config.getString(ConfigElement.EFFECT_NAME_COLOR.key(), ctgyGen, "f", ConfigElement.EFFECT_NAME_COLOR.desc(), ConfigElement.EFFECT_NAME_COLOR.validStrings(), ConfigElement.EFFECT_NAME_COLOR.languageKey());
        orderedKeys.add(ConfigElement.EFFECT_NAME_COLOR.key());
        durationColor = Reference.config.getString(ConfigElement.DURATION_COLOR.key(), ctgyGen, "f", ConfigElement.DURATION_COLOR.desc(), ConfigElement.DURATION_COLOR.validStrings(), ConfigElement.DURATION_COLOR.languageKey());
        orderedKeys.add(ConfigElement.DURATION_COLOR.key());
        enableIconBlink = Reference.config.getBoolean(ConfigElement.ENABLE_ICON_BLINK.key(), ctgyGen, true, ConfigElement.ENABLE_ICON_BLINK.desc(), ConfigElement.ENABLE_ICON_BLINK.languageKey());
        orderedKeys.add(ConfigElement.ENABLE_ICON_BLINK.key());
        durationBlinkSeconds = Reference.config.getInt(ConfigElement.DURATION_BLINK_SECONDS.key(), ctgyGen, 10, -1, 60, ConfigElement.DURATION_BLINK_SECONDS.desc(), ConfigElement.DURATION_BLINK_SECONDS.languageKey());
        orderedKeys.add(ConfigElement.DURATION_BLINK_SECONDS.key());
        xOffset = Reference.config.getInt(ConfigElement.X_OFFSET.key(), ctgyGen, 2, Integer.MIN_VALUE, Integer.MAX_VALUE, ConfigElement.X_OFFSET.desc(), ConfigElement.X_OFFSET.languageKey());
        orderedKeys.add(ConfigElement.X_OFFSET.key());
        applyXOffsetToCenter = Reference.config.getBoolean(ConfigElement.APPLY_X_OFFSET_TO_CENTER.key(), ctgyGen, false, ConfigElement.APPLY_X_OFFSET_TO_CENTER.desc(), ConfigElement.APPLY_X_OFFSET_TO_CENTER.languageKey());
        orderedKeys.add(ConfigElement.APPLY_X_OFFSET_TO_CENTER.key());
        yOffset = Reference.config.getInt(ConfigElement.Y_OFFSET.key(), ctgyGen, 2, Integer.MIN_VALUE, Integer.MAX_VALUE, ConfigElement.Y_OFFSET.desc(), ConfigElement.Y_OFFSET.languageKey());
        orderedKeys.add(ConfigElement.Y_OFFSET.key());
        applyYOffsetToMiddle = Reference.config.getBoolean(ConfigElement.APPLY_Y_OFFSET_TO_MIDDLE.key(), ctgyGen, false, ConfigElement.APPLY_Y_OFFSET_TO_MIDDLE.desc(), ConfigElement.APPLY_Y_OFFSET_TO_MIDDLE.languageKey());
        orderedKeys.add(ConfigElement.APPLY_Y_OFFSET_TO_MIDDLE.key());
        yOffsetBottomCenter = Reference.config.getInt(ConfigElement.Y_OFFSET_BOTTOM_CENTER.key(), ctgyGen, 41, Integer.MIN_VALUE, Integer.MAX_VALUE, ConfigElement.Y_OFFSET_BOTTOM_CENTER.desc(), ConfigElement.Y_OFFSET_BOTTOM_CENTER.languageKey());
        orderedKeys.add(ConfigElement.Y_OFFSET_BOTTOM_CENTER.key());
        Reference.config.setCategoryPropertyOrder(ctgyGen, orderedKeys);
        Reference.config.save();
    }

    public static boolean onTickInGame(Minecraft mc) {
        if (enabled && (mc.field_71415_G || mc.field_71462_r == null || mc.field_71462_r instanceof GuiChat && showInChat) && !mc.field_71474_y.field_74330_P) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            scaledResolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            StatusEffectHUD.displayStatusEffects(mc);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return true;
    }

    private static int getX(int width) {
        if (alignMode.equalsIgnoreCase("topcenter") || alignMode.equalsIgnoreCase("middlecenter") || alignMode.equalsIgnoreCase("bottomcenter")) {
            return scaledResolution.func_78326_a() / 2 - width / 2 + (applyXOffsetToCenter ? xOffset : 0);
        }
        if (alignMode.equalsIgnoreCase("topright") || alignMode.equalsIgnoreCase(alignModeDefault) || alignMode.equalsIgnoreCase("bottomright")) {
            return scaledResolution.func_78326_a() - width - xOffset;
        }
        return xOffset;
    }

    private static int getY(int rowCount, int height) {
        if (alignMode.equalsIgnoreCase("middleleft") || alignMode.equalsIgnoreCase("middlecenter") || alignMode.equalsIgnoreCase(alignModeDefault)) {
            return scaledResolution.func_78328_b() / 2 - rowCount * height / 2 + (applyYOffsetToMiddle ? yOffset : 0);
        }
        if (alignMode.equalsIgnoreCase("bottomleft") || alignMode.equalsIgnoreCase("bottomright")) {
            return scaledResolution.func_78328_b() - rowCount * height - yOffset;
        }
        if (alignMode.equalsIgnoreCase("bottomcenter")) {
            return scaledResolution.func_78328_b() - rowCount * height - yOffsetBottomCenter;
        }
        return yOffset;
    }

    private static boolean shouldRender(PotionEffect pe, int ticksLeft, int thresholdSeconds) {
        if (potionMaxDurationMap.get(pe) > 400 && ticksLeft / 20 <= thresholdSeconds) {
            return ticksLeft % 20 < 10;
        }
        return true;
    }

    private static void displayStatusEffects(Minecraft mc) {
        Collection activeEffects = mc.field_71439_g.func_70651_bq();
        if (!activeEffects.isEmpty()) {
            int yOffset;
            int n = enableBackground ? 33 : (yOffset = enableEffectName ? 20 : 18);
            if (activeEffects.size() > 5 && enableBackground) {
                yOffset = 132 / (activeEffects.size() - 1);
            }
            int yBase = StatusEffectHUD.getY(activeEffects.size(), yOffset);
            for (PotionEffect potionEffect : activeEffects) {
                int potionStatusIcon;
                if (!potionMaxDurationMap.containsKey(potionEffect) || potionMaxDurationMap.get(potionEffect) < potionEffect.func_76459_b()) {
                    potionMaxDurationMap.put(potionEffect, new Integer(potionEffect.func_76459_b()));
                }
                Potion potion = Potion.field_76425_a[potionEffect.func_76456_a()];
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/container/inventory.png"));
                int xBase = StatusEffectHUD.getX(enableBackground ? 120 : 22 + mc.field_71466_p.func_78256_a("0:00"));
                String potionName = "";
                if (enableEffectName) {
                    potionName = StatCollector.func_74838_a((String)potion.func_76393_a());
                    if (potionEffect.func_76458_c() == 1) {
                        potionName = potionName + " II";
                    } else if (potionEffect.func_76458_c() == 2) {
                        potionName = potionName + " III";
                    } else if (potionEffect.func_76458_c() == 3) {
                        potionName = potionName + " IV";
                    }
                    xBase = StatusEffectHUD.getX(enableBackground ? 120 : 22 + mc.field_71466_p.func_78256_a(potionName));
                }
                String effectDuration = Potion.func_76389_a((PotionEffect)potionEffect);
                if (enableBackground) {
                    HUDUtils.drawTexturedModalRect((int)xBase, (int)yBase, (int)0, (int)166, (int)140, (int)32, (float)zLevel);
                }
                if (alignMode.toLowerCase().contains("right")) {
                    xBase = StatusEffectHUD.getX(0);
                    if (potion.func_76400_d()) {
                        potionStatusIcon = potion.func_76392_e();
                        if (!enableIconBlink || enableIconBlink && StatusEffectHUD.shouldRender(potionEffect, potionEffect.func_76459_b(), durationBlinkSeconds)) {
                            HUDUtils.drawTexturedModalRect((int)(xBase + (enableBackground ? -24 : -18)), (int)(yBase + (enableBackground ? 7 : 0)), (int)(0 + potionStatusIcon % 8 * 18), (int)(198 + potionStatusIcon / 8 * 18), (int)18, (int)18, (float)zLevel);
                        }
                    }
                    int stringWidth = mc.field_71466_p.func_78256_a(potionName);
                    mc.field_71466_p.func_78261_a("\u00a7" + effectNameColor + potionName + "\u00a7r", xBase + (enableBackground ? -10 : -4) - 18 - stringWidth, yBase + (enableBackground ? 6 : 0), 0xFFFFFF);
                    stringWidth = mc.field_71466_p.func_78256_a(effectDuration);
                    if (StatusEffectHUD.shouldRender(potionEffect, potionEffect.func_76459_b(), durationBlinkSeconds)) {
                        mc.field_71466_p.func_78261_a("\u00a7" + durationColor + effectDuration + "\u00a7r", xBase + (enableBackground ? -10 : -4) - 18 - stringWidth, yBase + (enableBackground ? 6 : 0) + (enableEffectName ? 10 : 5), 0xFFFFFF);
                    }
                } else {
                    if (potion.func_76400_d()) {
                        potionStatusIcon = potion.func_76392_e();
                        HUDUtils.drawTexturedModalRect((int)(xBase + (enableBackground ? 6 : 0)), (int)(yBase + (enableBackground ? 7 : 0)), (int)(0 + potionStatusIcon % 8 * 18), (int)(198 + potionStatusIcon / 8 * 18), (int)18, (int)18, (float)zLevel);
                    }
                    mc.field_71466_p.func_78261_a("\u00a7" + effectNameColor + potionName + "\u00a7r", xBase + (enableBackground ? 10 : 4) + 18, yBase + (enableBackground ? 6 : 0), 0xFFFFFF);
                    if (StatusEffectHUD.shouldRender(potionEffect, potionEffect.func_76459_b(), durationBlinkSeconds)) {
                        mc.field_71466_p.func_78261_a("\u00a7" + durationColor + effectDuration + "\u00a7r", xBase + (enableBackground ? 10 : 4) + 18, yBase + (enableBackground ? 6 : 0) + (enableEffectName ? 10 : 5), 0xFFFFFF);
                    }
                }
                yBase += yOffset;
            }
            LinkedList<PotionEffect> toRemove = new LinkedList<PotionEffect>();
            for (PotionEffect pe : potionMaxDurationMap.keySet()) {
                if (activeEffects.contains(pe)) continue;
                toRemove.add(pe);
            }
            for (PotionEffect pe : toRemove) {
                potionMaxDurationMap.remove(pe);
            }
        }
    }

    static {
        enabled = true;
        alignMode = alignModeDefault;
        disableInventoryEffectList = true;
        enableBackground = false;
        enableEffectName = true;
        enableIconBlink = true;
        durationBlinkSeconds = 10;
        effectNameColor = "f";
        durationColor = "f";
        xOffset = 2;
        yOffset = 2;
        yOffsetBottomCenter = 41;
        applyXOffsetToCenter = false;
        applyYOffsetToMiddle = false;
        showInChat = true;
        potionMaxDurationMap = new HashMap<PotionEffect, Integer>();
    }
}

