/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.jsapi;

import com.sun.speech.engine.synthesis.BaseVoice;
import com.sun.speech.freetts.Age;
import com.sun.speech.freetts.Gender;
import com.sun.speech.freetts.ValidationException;
import com.sun.speech.freetts.Validator;
import com.sun.speech.freetts.Voice;

public class FreeTTSVoice
extends BaseVoice {
    private Voice freettsVoice;
    private Validator validator;

    public FreeTTSVoice(Voice freettsVoice, String validatorName) {
        super(freettsVoice.getName() + Math.random(), freettsVoice.getName(), FreeTTSVoice.genderToInt(freettsVoice.getGender()), FreeTTSVoice.ageToInt(freettsVoice.getAge()), freettsVoice.getStyle(), freettsVoice.getPitch(), freettsVoice.getPitchRange(), freettsVoice.getRate(), freettsVoice.getVolume());
        this.freettsVoice = freettsVoice;
        if (validatorName != null) {
            try {
                Class<?> clazz = Class.forName(validatorName);
                this.validator = (Validator)clazz.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            catch (InstantiationException ie) {
                ie.printStackTrace();
            }
        } else {
            this.validator = null;
        }
    }

    private static int genderToInt(Gender gender) {
        if (gender == Gender.MALE) {
            return 2;
        }
        if (gender == Gender.FEMALE) {
            return 1;
        }
        if (gender == Gender.NEUTRAL) {
            return 4;
        }
        if (gender == Gender.DONT_CARE) {
            return 65535;
        }
        throw new Error("jaspi does not have an equivalent to gender " + gender.toString());
    }

    private static int ageToInt(Age age) {
        if (age == Age.CHILD) {
            return 1;
        }
        if (age == Age.TEENAGER) {
            return 2;
        }
        if (age == Age.YOUNGER_ADULT) {
            return 4;
        }
        if (age == Age.MIDDLE_ADULT) {
            return 8;
        }
        if (age == Age.OLDER_ADULT) {
            return 16;
        }
        if (age == Age.NEUTRAL) {
            return 32;
        }
        if (age == Age.DONT_CARE) {
            return 65535;
        }
        throw new Error("jaspi does not have an equivalent to age " + age.toString());
    }

    public String getId() {
        return this.voiceId;
    }

    public String toString() {
        return this.getName();
    }

    public synchronized Voice getVoice() {
        return this.freettsVoice;
    }

    public void setId(String id) {
        this.voiceId = id;
    }

    public Object clone() {
        return super.clone();
    }

    public void validate() throws ValidationException {
        if (this.validator != null) {
            this.validator.validate();
        }
    }
}

