/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.utils;

import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.peripheralsplusplus.utils.FakeTurtlePlayer;
import cpw.mods.fml.common.registry.GameRegistry;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Facing;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.IShearable;

public class TurtleUtil {
    public static List<ItemStack> harvestBlock(ITurtleAccess turtle, FakeTurtlePlayer player, int dir, ItemStack itemToUse) {
        int x = turtle.getPosition().field_71574_a + Facing.field_71586_b[dir];
        int y = turtle.getPosition().field_71572_b + Facing.field_71587_c[dir];
        int z = turtle.getPosition().field_71573_c + Facing.field_71585_d[dir];
        if (!turtle.getWorld().func_147437_c(x, y, z)) {
            Block block = turtle.getWorld().func_147439_a(x, y, z);
            player.func_70062_b(0, itemToUse);
            if (block.func_149712_f(turtle.getWorld(), x, y, z) >= 0.0f && block.canHarvestBlock((EntityPlayer)player, block.func_149643_k(turtle.getWorld(), x, y, z))) {
                ArrayList items = block.getDrops(turtle.getWorld(), x, y, z, block.func_149643_k(turtle.getWorld(), x, y, z), 0);
                turtle.getWorld().func_147468_f(x, y, z);
                return items;
            }
        }
        return null;
    }

    public static List<Entity> getEntitiesNearTurtle(ITurtleAccess turtle, FakeTurtlePlayer player, int dir) {
        int x = turtle.getPosition().field_71574_a + Facing.field_71586_b[dir];
        int y = turtle.getPosition().field_71572_b + Facing.field_71587_c[dir];
        int z = turtle.getPosition().field_71573_c + Facing.field_71585_d[dir];
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + 1.0));
        return turtle.getWorld().func_72839_b((Entity)player, box);
    }

    public static Entity getClosestShearableEntity(List<Entity> list, Entity ent) {
        Vec3 from = Vec3.func_72443_a((double)ent.field_70165_t, (double)ent.field_70163_u, (double)ent.field_70161_v);
        Entity returnVal = null;
        double lastDistance = Double.MAX_VALUE;
        for (Entity entity : list) {
            Vec3 to;
            if (!(entity instanceof IShearable) || !((to = Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v)).func_72438_d(from) < lastDistance)) continue;
            returnVal = entity;
        }
        return returnVal;
    }

    public static Entity getClosestEntity(List<Entity> list, Entity ent) {
        Vec3 from = Vec3.func_72443_a((double)ent.field_70165_t, (double)ent.field_70163_u, (double)ent.field_70161_v);
        Entity returnVal = null;
        double lastDistance = Double.MAX_VALUE;
        for (Entity entity : list) {
            Vec3 to = Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
            if (!(to.func_72438_d(from) < lastDistance)) continue;
            returnVal = entity;
        }
        return returnVal;
    }

    public static void addItemListToInv(List<ItemStack> items, ITurtleAccess turtle) {
        for (ItemStack item : items) {
            TurtleUtil.addToInv(turtle, item);
        }
    }

    public static ArrayList<ItemStack> entityItemsToItemStack(ArrayList<EntityItem> entities) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (EntityItem e : entities) {
            stacks.add(e.func_92059_d());
        }
        return stacks;
    }

    public static void addToInv(ITurtleAccess turtle, ItemStack stack) {
        boolean drop = true;
        IInventory inv = turtle.getInventory();
        ChunkCoordinates coords = turtle.getPosition();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack currentStack = inv.func_70301_a(i);
            if (currentStack == null) {
                inv.func_70299_a(i, stack);
                drop = false;
                break;
            }
            if (!currentStack.func_77985_e() || !currentStack.func_77969_a(stack)) continue;
            int space = currentStack.func_77976_d() - currentStack.field_77994_a;
            if (stack.field_77994_a > space) {
                currentStack.field_77994_a = currentStack.func_77976_d();
                stack.field_77994_a -= space;
                drop = true;
                continue;
            }
            currentStack.field_77994_a += stack.field_77994_a;
            stack.field_77994_a = 0;
            drop = false;
            break;
        }
        if (drop) {
            int dir = turtle.getDirection();
            turtle.getWorld().func_72838_d((Entity)new EntityItem(turtle.getWorld(), (double)(coords.field_71574_a + Facing.field_71586_b[dir]), (double)(coords.field_71572_b + Facing.field_71587_c[dir] + 1), (double)(coords.field_71573_c + Facing.field_71585_d[dir]), stack.func_77946_l()));
        }
    }

    public static ItemStack getTurtle(boolean isAdvanced, ITurtleUpgrade upgradeLeft, ITurtleUpgrade upgradeRight) {
        if (upgradeLeft == null && upgradeRight == null) {
            return new ItemStack(GameRegistry.findBlock((String)"ComputerCraft", (String)(isAdvanced ? "CC-TurtleAdvanced" : "CC-Turtle")));
        }
        ItemStack turtle = new ItemStack(GameRegistry.findBlock((String)"ComputerCraft", (String)(isAdvanced ? "CC-TurtleAdvanced" : "CC-TurtleExpanded")));
        if (upgradeLeft != null) {
            NBTHelper.setShort((ItemStack)turtle, (String)"leftUpgrade", (short)((short)upgradeLeft.getUpgradeID()));
        }
        if (upgradeRight != null) {
            NBTHelper.setShort((ItemStack)turtle, (String)"rightUpgrade", (short)((short)upgradeRight.getUpgradeID()));
        }
        return turtle;
    }

    public static ItemStack getTurtle(boolean isAdvanced, ITurtleUpgrade upgrade) {
        return TurtleUtil.getTurtle(isAdvanced, upgrade, null);
    }

    public static ItemStack getTurtle(boolean isAdvanced) {
        return TurtleUtil.getTurtle(isAdvanced, null);
    }

    public static <T> T getPeripheral(ITurtleAccess turtle, Class<T> clazz) {
        for (TurtleSide side : EnumSet.allOf(TurtleSide.class)) {
            IPeripheral peripheral = turtle.getPeripheral(side);
            if (peripheral == null || !clazz.isAssignableFrom(peripheral.getClass())) continue;
            return (T)peripheral;
        }
        return null;
    }

    public static TurtleSide getPeripheralSide(ITurtleAccess turtle, Class clazz) {
        for (TurtleSide side : EnumSet.allOf(TurtleSide.class)) {
            IPeripheral peripheral = turtle.getPeripheral(side);
            if (peripheral == null || !clazz.isAssignableFrom(peripheral.getClass())) continue;
            return side;
        }
        return null;
    }
}

