/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles.peripherals;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.turtles.peripherals.MountedPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class PeripheralTank
extends MountedPeripheral {
    private ITurtleAccess turtle;
    private TurtleSide side;
    private FluidTank tank = new FluidTank(Config.maxNumberOfMillibuckets);
    private boolean changed = false;

    public PeripheralTank(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = turtle;
        this.side = side;
        NBTTagCompound tag = turtle.getUpgradeNBTData(side);
        if (tag != null) {
            this.tank = this.tank.readFromNBT(tag);
            this.changed = true;
        }
    }

    public String getType() {
        return "tank";
    }

    public String[] getMethodNames() {
        return new String[]{"drop", "dropUp", "dropDown", "suck", "suckUp", "suckDown", "getLiquid", "pack", "unpack"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableTankTurtle) {
            throw new LuaException("Thirsty Turtles have been disabled");
        }
        switch (method) {
            case 0: 
            case 1: 
            case 2: {
                var6_5 = this;
                synchronized (var6_5) {
                    if (arguments.length > 0 && !(arguments[0] instanceof Double)) {
                        throw new LuaException("Bad argument #1 (expected number)");
                    }
                    dir = method == 0 ? ForgeDirection.getOrientation((int)this.turtle.getDirection()) : (method == 1 ? ForgeDirection.UP : ForgeDirection.DOWN);
                    placed = 0;
                    v0 = maxPlaced = arguments.length > 0 ? (int)((Double)arguments[0]).doubleValue() : 0x7FFFFFFF;
                    if (this.tank.getFluidAmount() > 0) {
                        if (this.turtle.getWorld().func_147437_c(this.turtle.getPosition().field_71574_a + dir.offsetX, this.turtle.getPosition().field_71572_b + dir.offsetY, this.turtle.getPosition().field_71573_c + dir.offsetZ)) {
                            if (this.tank.getFluidAmount() >= 1000 && 1000 <= maxPlaced && this.tank.getFluid().getFluid().canBePlacedInWorld()) {
                                this.turtle.getWorld().func_147449_b(this.turtle.getPosition().field_71574_a + dir.offsetX, this.turtle.getPosition().field_71572_b + dir.offsetY, this.turtle.getPosition().field_71573_c + dir.offsetZ, this.reverseGetFluidBlock(this.tank.getFluid().getFluid().getBlock()));
                                placed = 1000;
                            }
                        } else {
                            block = this.turtle.getWorld().func_147439_a(this.turtle.getPosition().field_71574_a + dir.offsetX, this.turtle.getPosition().field_71572_b + dir.offsetY, this.turtle.getPosition().field_71573_c + dir.offsetZ);
                            if (block instanceof ITileEntityProvider && this.turtle.getWorld().func_147438_o(this.turtle.getPosition().field_71574_a + dir.offsetX, this.turtle.getPosition().field_71572_b + dir.offsetY, this.turtle.getPosition().field_71573_c + dir.offsetZ) instanceof IFluidHandler && (handler = (IFluidHandler)this.turtle.getWorld().func_147438_o(this.turtle.getPosition().field_71574_a + dir.offsetX, this.turtle.getPosition().field_71572_b + dir.offsetY, this.turtle.getPosition().field_71573_c + dir.offsetZ)).canFill(dir.getOpposite(), this.tank.getFluid().getFluid())) {
                                placed = handler.fill(dir.getOpposite(), this.tank.getFluid(), true);
                            }
                        }
                        placed = this.tank.drain((int)placed, (boolean)true).amount;
                    }
                    this.changed = true;
                    return new Object[]{placed};
                }
            }
            case 3: 
            case 4: 
            case 5: {
                var6_6 = this;
                synchronized (var6_6) {
                    dir = method == 3 ? ForgeDirection.getOrientation((int)this.turtle.getDirection()) : (method == 4 ? ForgeDirection.UP : ForgeDirection.DOWN);
                    if (arguments.length > 0 && !(arguments[0] instanceof Double)) {
                        throw new LuaException("Bad argument #1 (expected number)");
                    }
                    sucked = 0;
                    fluidSucked = null;
                    v1 = maxSucked = arguments.length > 0 ? (int)((Double)arguments[0]).doubleValue() : 0x7FFFFFFF;
                    if (!this.turtle.getWorld().func_72953_d(AxisAlignedBB.func_72330_a((double)(this.turtle.getPosition().field_71574_a + dir.offsetX), (double)(this.turtle.getPosition().field_71574_a + dir.offsetX), (double)(this.turtle.getPosition().field_71572_b + dir.offsetY), (double)(this.turtle.getPosition().field_71572_b + dir.offsetY), (double)(this.turtle.getPosition().field_71573_c + dir.offsetZ), (double)(this.turtle.getPosition().field_71573_c + dir.offsetZ)))) ** GOTO lbl45
                    if (this.tank.getCapacity() - this.tank.getFluidAmount() < 1000 || 1000 > maxSucked || !((block = this.turtle.getWorld().func_147439_a(this.turtle.getPosition().field_71574_a + dir.offsetX, this.turtle.getPosition().field_71572_b + dir.offsetY, this.turtle.getPosition().field_71573_c + dir.offsetZ)) instanceof IFluidBlock) && FluidRegistry.lookupFluidForBlock((Block)this.getFluidBlock(block)) == null || this.tank.getFluidAmount() >= 1 && !this.tank.getFluid().isFluidEqual(new FluidStack(FluidRegistry.lookupFluidForBlock((Block)this.getFluidBlock(block)), 1000))) ** GOTO lbl54
                    fluidSucked = FluidRegistry.lookupFluidForBlock((Block)this.getFluidBlock(block));
                    sucked = 1000;
                    this.turtle.getWorld().func_147468_f(this.turtle.getPosition().field_71574_a + dir.offsetX, this.turtle.getPosition().field_71572_b + dir.offsetY, this.turtle.getPosition().field_71573_c + dir.offsetZ);
                    ** GOTO lbl54
lbl45:
                    // 1 sources

                    block = this.turtle.getWorld().func_147439_a(this.turtle.getPosition().field_71574_a + dir.offsetX, this.turtle.getPosition().field_71572_b + dir.offsetY, this.turtle.getPosition().field_71573_c + dir.offsetZ);
                    if (block instanceof ITileEntityProvider && this.turtle.getWorld().func_147438_o(this.turtle.getPosition().field_71574_a + dir.offsetX, this.turtle.getPosition().field_71572_b + dir.offsetY, this.turtle.getPosition().field_71573_c + dir.offsetZ) instanceof IFluidHandler && this.tank.getFluidAmount() < this.tank.getCapacity()) {
                        handler = (IFluidHandler)this.turtle.getWorld().func_147438_o(this.turtle.getPosition().field_71574_a + dir.offsetX, this.turtle.getPosition().field_71572_b + dir.offsetY, this.turtle.getPosition().field_71573_c + dir.offsetZ);
                        for (FluidTankInfo info : infos = handler.getTankInfo(dir.getOpposite())) {
                            if (this.tank.getFluidAmount() >= 1 && !this.tank.getFluid().isFluidEqual(info.fluid) || !handler.canFill(dir.getOpposite(), info.fluid.getFluid())) continue;
                            stack = handler.drain(dir.getOpposite(), new FluidStack(info.fluid, maxSucked), true);
                            fluidSucked = stack.getFluid();
                            sucked = stack.amount;
                            break;
                        }
                    }
lbl54:
                    // 6 sources

                    sucked = fluidSucked == null ? 0 : this.tank.fill(new FluidStack(fluidSucked, sucked), true);
                    this.changed = true;
                    return new Object[]{sucked};
                }
            }
            case 6: {
                if (this.tank.getFluidAmount() > 0) {
                    map = new HashMap<String, Object>();
                    map.put("amount", this.tank.getFluidAmount());
                    map.put("name", this.tank.getFluid().getLocalizedName());
                    map.put("id", this.tank.getFluid().getFluidID());
                    return new Object[]{map};
                }
                return new Object[0];
            }
            case 7: {
                if (arguments.length > 0 && !(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                v2 = slotToPack = arguments.length > 0 ? (int)((Double)arguments[0]).doubleValue() - 1 : this.findContainerSlot();
                if (slotToPack == -1) {
                    throw new LuaException("No suitable item found");
                }
                toPack = this.turtle.getInventory().func_70301_a(slotToPack);
                if (toPack.func_77973_b() instanceof IFluidContainerItem) {
                    return new Object[]{((IFluidContainerItem)toPack.func_77973_b()).fill(toPack, this.tank.getFluid(), true)};
                }
                if (toPack.func_77973_b() instanceof ItemBucket && this.tank.getFluid() != null) {
                    fluid = this.tank.getFluid().getFluid().getBlock();
                    item = (ItemBucket)Items.field_151133_ar;
                    item.field_77876_a = this.reverseGetFluidBlock(fluid);
                    stack = new ItemStack((Item)item);
                    this.turtle.getInventory().func_70299_a(slotToPack - 1, stack);
                    return new Object[]{1000};
                }
                this.changed = true;
                return new Object[]{0};
            }
            case 8: {
                if (arguments.length > 0 && !(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                v3 = slotToUnpack = arguments.length > 0 ? (int)((Double)arguments[0]).doubleValue() - 1 : this.findContainerSlot();
                if (slotToUnpack == -1) {
                    throw new LuaException("No suitable item found");
                }
                toUnpack = this.turtle.getInventory().func_70301_a(slotToUnpack);
                if (toUnpack.func_77973_b() instanceof IFluidContainerItem) {
                    unpacked = ((IFluidContainerItem)toUnpack.func_77973_b()).drain(toUnpack, this.tank.getCapacity() - this.tank.getFluidAmount(), false);
                    if (this.tank.getFluid() == null || unpacked.isFluidEqual(this.tank.getFluid())) {
                        return new Object[]{this.tank.fill(((IFluidContainerItem)toUnpack.func_77973_b()).drain(toUnpack, this.tank.getCapacity() - this.tank.getFluidAmount(), true), true)};
                    }
                } else if (toUnpack.func_77973_b() instanceof ItemBucket && ((ItemBucket)toUnpack.func_77973_b()).field_77876_a != Blocks.field_150350_a) {
                    this.turtle.getInventory().func_70299_a(slotToUnpack, new ItemStack(Items.field_151133_ar));
                    return new Object[]{this.tank.fill(new FluidStack(FluidRegistry.lookupFluidForBlock((Block)this.getFluidBlock(((ItemBucket)toUnpack.func_77973_b()).field_77876_a)), 1000), true)};
                }
                this.changed = true;
                return new Object[]{0};
            }
        }
        return new Object[0];
    }

    private int findContainerSlot() {
        for (int i = 0; i < this.turtle.getInventory().func_70302_i_(); ++i) {
            if (this.turtle.getInventory().func_70301_a(i) == null || !(this.turtle.getInventory().func_70301_a(i).func_77973_b() instanceof IFluidContainerItem) && !(this.turtle.getInventory().func_70301_a(i).func_77973_b() instanceof ItemBucket)) continue;
            return i;
        }
        return -1;
    }

    private Block getFluidBlock(Block b) {
        if (b == Blocks.field_150356_k) {
            return Blocks.field_150353_l;
        }
        if (b == Blocks.field_150358_i) {
            return Blocks.field_150355_j;
        }
        return b;
    }

    private Block reverseGetFluidBlock(Block b) {
        if (b == Blocks.field_150353_l) {
            return Blocks.field_150356_k;
        }
        if (b == Blocks.field_150355_j) {
            return Blocks.field_150358_i;
        }
        return b;
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public void update() {
        if (this.changed && this.tank.getFluid() != null) {
            NBTTagCompound tag = this.turtle.getUpgradeNBTData(this.side);
            this.tank.writeToNBT(tag);
            this.turtle.updateUpgradeNBTData(this.side);
            this.changed = false;
        }
    }
}

