/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles.peripherals;

import com.austinv11.peripheralsplusplus.blocks.BlockResupplyStation;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.TileEntityResupplyStation;
import com.austinv11.peripheralsplusplus.turtles.peripherals.MountedPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PeripheralResupply
extends MountedPeripheral {
    private ITurtleAccess turtle;
    private ChunkCoordinates linkedStation;

    public PeripheralResupply(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "resupply";
    }

    public String[] getMethodNames() {
        return new String[]{"link", "resupply"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableResupplyStation) {
            throw new LuaException("The resupply station has been disabled");
        }
        switch (method) {
            case 0: {
                if (arguments.length < 1 || arguments.length > 1 && arguments.length < 3) {
                    throw new LuaException("Too few arguments");
                }
                if (!(arguments[0] instanceof String) && !(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected string or number)");
                }
                if (arguments.length > 1) {
                    if (!(arguments[0] instanceof Double)) {
                        throw new LuaException("Bad argument #1 (expected number)");
                    }
                    if (!(arguments[1] instanceof Double)) {
                        throw new LuaException("Bad argument #2 (expected number)");
                    }
                    if (!(arguments[2] instanceof Double)) {
                        throw new LuaException("Bad argument #3 (expected number)");
                    }
                    this.linkedStation = new ChunkCoordinates(((Double)arguments[0]).intValue(), ((Double)arguments[1]).intValue(), ((Double)arguments[2]).intValue());
                    return new Object[]{true};
                }
                ForgeDirection dir = arguments[0] instanceof String ? ForgeDirection.valueOf((String)((String)arguments[0]).toUpperCase()) : ForgeDirection.getOrientation((int)((int)((Double)arguments[0]).doubleValue()));
                ChunkCoordinates newLink = new ChunkCoordinates(this.turtle.getPosition().field_71574_a + dir.offsetX, this.turtle.getPosition().field_71572_b + dir.offsetY, this.turtle.getPosition().field_71573_c + dir.offsetZ);
                World turtleWorld = this.turtle.getWorld();
                if (!turtleWorld.func_72899_e(newLink.field_71574_a, newLink.field_71572_b, newLink.field_71573_c) || turtleWorld.func_147437_c(newLink.field_71574_a, newLink.field_71572_b, newLink.field_71573_c) || !(turtleWorld.func_147439_a(newLink.field_71574_a, newLink.field_71572_b, newLink.field_71573_c) instanceof BlockResupplyStation)) {
                    return new Object[]{false};
                }
                this.linkedStation = newLink;
                return new Object[]{true};
            }
            case 1: {
                if (this.linkedStation == null) {
                    throw new LuaException("A station has not been linked!");
                }
                World world = this.turtle.getWorld();
                if (!world.func_72899_e(this.linkedStation.field_71574_a, this.linkedStation.field_71572_b, this.linkedStation.field_71573_c) || world.func_147437_c(this.linkedStation.field_71574_a, this.linkedStation.field_71572_b, this.linkedStation.field_71573_c) || !(world.func_147439_a(this.linkedStation.field_71574_a, this.linkedStation.field_71572_b, this.linkedStation.field_71573_c) instanceof BlockResupplyStation)) {
                    throw new LuaException("The linked station is nonexistant!");
                }
                if (arguments.length > 0 && !(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                if (arguments.length > 1 && !(arguments[1] instanceof String) && !(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected string or number)");
                }
                if (arguments.length > 2 && !(arguments[2] instanceof Double)) {
                    throw new LuaException("Bad argument #3 (expected number)");
                }
                int slot = this.turtle.getSelectedSlot();
                if (arguments.length > 0) {
                    slot = ((Double)arguments[0]).intValue() - 1;
                }
                String id = null;
                if (arguments.length > 1 && arguments[1] instanceof String) {
                    id = (String)arguments[1];
                } else {
                    if (this.turtle.getInventory().func_70301_a(slot) == null) {
                        return new Object[]{false};
                    }
                    if (this.turtle.getInventory().func_70301_a(slot).func_77973_b() instanceof ItemBlock) {
                        Block itemBlock = Block.func_149634_a((Item)this.turtle.getInventory().func_70301_a(slot).func_77973_b());
                        id = Block.field_149771_c.func_148750_c((Object)itemBlock);
                    } else {
                        Item item = this.turtle.getInventory().func_70301_a(slot).func_77973_b();
                        id = Item.field_150901_e.func_148750_c((Object)item);
                    }
                }
                int meta = arguments.length > 2 ? ((Double)arguments[2]).intValue() : (this.turtle.getInventory().func_70301_a(slot) == null ? 0 : this.turtle.getInventory().func_70301_a(slot).func_77960_j());
                PeripheralResupply peripheralResupply = this;
                synchronized (peripheralResupply) {
                    TileEntityResupplyStation station = (TileEntityResupplyStation)world.func_147438_o(this.linkedStation.field_71574_a, this.linkedStation.field_71572_b, this.linkedStation.field_71573_c);
                    return new Object[]{station.resupply(this.turtle, slot, id, meta)};
                }
            }
        }
        return new Object[0];
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }
}

