/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles.peripherals;

import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.turtles.peripherals.MountedPeripheral;
import com.austinv11.peripheralsplusplus.utils.ReflectionHelper;
import com.austinv11.peripheralsplusplus.utils.TurtleUtil;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class PeripheralChunkLoader
extends MountedPeripheral {
    private ITurtleAccess turtle;
    private boolean ticketCreated = false;
    private ForgeChunkManager.Ticket ticket;
    private IComputerAccess computer;
    private ChunkCoordinates oldPos;
    private int oldChunkX;
    private int oldChunkZ;

    public PeripheralChunkLoader(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "chunkLoader";
    }

    public String[] getMethodNames() {
        return new String[0];
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        return new Object[0];
    }

    @Override
    public void attach(IComputerAccess computer) {
        this.computer = computer;
    }

    @Override
    public void detach(IComputerAccess computer) {
        if (this.ticket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        }
    }

    public boolean equals(IPeripheral other) {
        return false;
    }

    public void update() {
        if (Config.enableChunkyTurtle) {
            if (this.turtle.getWorld().field_72995_K) {
                return;
            }
            ChunkCoordinates pos = this.turtle.getPosition();
            if (!this.ticketCreated) {
                this.ticketCreated = true;
                this.ticket = ForgeChunkManager.requestTicket((Object)PeripheralsPlusPlus.instance, (World)this.turtle.getWorld(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                if (this.ticket == null) {
                    PeripheralsPlusPlus.LOGGER.warn((Object)("Chunk loading limit exceeded, not chunkloading turtle " + (this.computer == null ? "[unknown]" : Integer.valueOf(this.computer.getID())) + " at (" + pos.field_71574_a + "," + pos.field_71572_b + "," + pos.field_71573_c + ")!"));
                    return;
                }
                int width = Config.chunkLoadingRadius * 2 + 1 + (Config.aggressiveChunkLoading && Config.chunkLoadingRadius == 0 ? 2 : 0);
                this.ticket.setChunkListDepth(width * width);
            } else if (pos.field_71574_a != this.oldPos.field_71574_a || pos.field_71572_b != this.oldPos.field_71572_b || pos.field_71573_c != this.oldPos.field_71573_c) {
                this.updatePos();
                this.turtle.consumeFuel(Config.chunkyMovementPenalty);
                if (this.ticket == null) {
                    PeripheralsPlusPlus.LOGGER.warn((Object)("Null ticket when moving chunkloaded turtle " + (this.computer == null ? "[unknown]" : Integer.valueOf(this.computer.getID())) + " at (" + pos.field_71574_a + "," + pos.field_71572_b + "," + pos.field_71573_c + ")!"));
                } else {
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
                    this.ticketCreated = false;
                }
            }
            this.oldPos = pos;
        }
    }

    private void updatePos() {
        ChunkCoordinates pos = this.turtle.getPosition();
        if (this.ticket != null) {
            NBTTagCompound modData = this.ticket.getModData();
            modData.func_74768_a("turtleX", pos.field_71574_a);
            modData.func_74768_a("turtleY", pos.field_71572_b);
            modData.func_74768_a("turtleZ", pos.field_71573_c);
            int chunkX = pos.field_71574_a >> 4;
            int chunkZ = pos.field_71573_c >> 4;
            if (this.oldChunkX != chunkX || this.oldChunkZ != chunkZ) {
                int radius = Config.chunkLoadingRadius;
                for (int cx = chunkX - radius; cx <= chunkX + radius; ++cx) {
                    for (int cz = chunkZ - radius; cz <= chunkZ + radius; ++cz) {
                        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(cx, cz));
                    }
                }
                this.oldChunkX = chunkX;
                this.oldChunkZ = chunkZ;
            }
            if (Config.aggressiveChunkLoading && Config.chunkLoadingRadius == 0) {
                if (chunkX != pos.field_71574_a + 1 >> 4) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(pos.field_71574_a + 1 >> 4, chunkZ));
                } else if (chunkX != pos.field_71574_a - 1 >> 4) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(pos.field_71574_a - 1 >> 4, chunkZ));
                }
                if (chunkZ != pos.field_71573_c + 1 >> 4) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(chunkX, pos.field_71573_c + 1 >> 4));
                } else if (chunkZ != pos.field_71573_c - 1 >> 4) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(chunkX, pos.field_71573_c - 1 >> 4));
                }
            }
        }
    }

    public static class TurtleChunkLoadingCallback
    implements ForgeChunkManager.OrderedLoadingCallback {
        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                int x = ticket.getModData().func_74762_e("turtleX");
                int y = ticket.getModData().func_74762_e("turtleY");
                int z = ticket.getModData().func_74762_e("turtleZ");
                TileEntity te = world.func_147438_o(x, y, z);
                ITurtleAccess turtle = null;
                try {
                    if (te != null) {
                        turtle = ReflectionHelper.getTurtle(te);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (turtle == null) continue;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(x >> 4, z >> 4));
                PeripheralChunkLoader loader = TurtleUtil.getPeripheral((ITurtleAccess)te, PeripheralChunkLoader.class);
                if (loader == null) continue;
                loader.ticketCreated = true;
            }
        }

        public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
            LinkedList<ForgeChunkManager.Ticket> ret = new LinkedList<ForgeChunkManager.Ticket>();
            LinkedList<ChunkCoordinates> known = new LinkedList<ChunkCoordinates>();
            for (ForgeChunkManager.Ticket ticket : tickets) {
                int z;
                int y;
                int x = ticket.getModData().func_74762_e("turtleX");
                ChunkCoordinates coords = new ChunkCoordinates(x, y = ticket.getModData().func_74762_e("turtleY"), z = ticket.getModData().func_74762_e("turtleZ"));
                if (known.contains(coords)) continue;
                known.add(coords);
                TileEntity te = world.func_147438_o(x, y, z);
                ITurtleAccess turtle = null;
                try {
                    if (te != null) {
                        turtle = ReflectionHelper.getTurtle(te);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (turtle == null || TurtleUtil.getPeripheral((ITurtleAccess)te, PeripheralChunkLoader.class) == null) continue;
                ret.add(ticket);
            }
            int removed = tickets.size() - known.size();
            if (removed > 0) {
                PeripheralsPlusPlus.LOGGER.info((Object)("Removed " + removed + " bugged duplicate chunk loading tickets from world " + world.field_73011_w.field_76574_g));
            }
            return ret;
        }
    }
}

