/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles.peripherals;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.turtles.peripherals.MountedPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class PeripheralBarrel
extends MountedPeripheral {
    private int MAX_SIZE = 4096;
    private int STACK_SIZE = 64;
    private Item ITEM_TYPE_STORED;
    private int ITEM_META_STORED = 0;
    private int CURRENT_USAGE = 0;
    private ITurtleAccess turtle;
    private TurtleSide side;
    public boolean changed = false;

    public PeripheralBarrel(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = turtle;
        this.side = side;
        NBTTagCompound tag = turtle.getUpgradeNBTData(side);
        if (tag.func_74762_e("maxSize") > 0) {
            this.MAX_SIZE = tag.func_74762_e("maxSize");
        }
        if (tag.func_74762_e("stackSize") > 0) {
            this.STACK_SIZE = tag.func_74762_e("stackSize");
        }
        this.CURRENT_USAGE = tag.func_74762_e("currentUsage");
        if (tag.func_74767_n("isKnown")) {
            this.ITEM_TYPE_STORED = Item.func_150899_d((int)tag.func_74762_e("itemID"));
            this.ITEM_META_STORED = tag.func_74762_e("stackMeta");
        }
        this.checkUsageStats();
    }

    private void checkUsageStats() {
        if (this.CURRENT_USAGE <= 0 || this.ITEM_TYPE_STORED == null) {
            this.CURRENT_USAGE = 0;
            this.STACK_SIZE = 64;
            this.MAX_SIZE = 64 * this.STACK_SIZE;
            this.ITEM_TYPE_STORED = null;
            this.ITEM_META_STORED = 0;
        }
    }

    private String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    public String getType() {
        return "barrel";
    }

    public String[] getMethodNames() {
        return new String[]{"get", "put", "getUnlocalizedName", "getLocalizedName", "getItemID", "getAmount", "getOreDictEntries"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableBarrelTurtle) {
            throw new LuaException("Barrel Turtles have been disabled");
        }
        if (method == 0) {
            int amount = this.STACK_SIZE;
            if (arguments.length > 0) {
                if (!(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                amount = (int)((Double)arguments[0]).doubleValue();
            }
            if (this.CURRENT_USAGE < amount) {
                amount = this.CURRENT_USAGE;
            }
            if (this.ITEM_TYPE_STORED == null) {
                return new Object[]{0};
            }
            ItemStack slot = this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot());
            Item itemStored = this.ITEM_TYPE_STORED;
            int stackCount = amount;
            if (slot != null) {
                if (!slot.func_77969_a(new ItemStack(itemStored, stackCount, this.ITEM_META_STORED))) {
                    throw new LuaException("Item mismatch");
                }
                if (amount + slot.field_77994_a > this.STACK_SIZE) {
                    amount = this.STACK_SIZE - slot.field_77994_a;
                }
                stackCount = amount + slot.field_77994_a;
            }
            ItemStack stack = new ItemStack(itemStored, stackCount, this.ITEM_META_STORED);
            this.CURRENT_USAGE -= amount;
            this.checkUsageStats();
            this.turtle.getInventory().func_70299_a(this.turtle.getSelectedSlot(), stack.func_77946_l());
            this.changed = true;
            return new Object[]{amount};
        }
        if (method == 1) {
            int amount = 64;
            if (arguments.length > 0) {
                if (!(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                amount = (int)((Double)arguments[0]).doubleValue();
            }
            if (this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot()) == null) {
                return new Object[]{0};
            }
            ItemStack items = this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot()).func_77946_l();
            if (amount > items.field_77994_a) {
                amount = items.field_77994_a;
            }
            if (amount > this.MAX_SIZE - this.CURRENT_USAGE) {
                amount = this.MAX_SIZE - this.CURRENT_USAGE;
            }
            if (this.ITEM_TYPE_STORED != null) {
                ItemStack temp = new ItemStack(this.ITEM_TYPE_STORED);
                if (!temp.func_77969_a(items)) {
                    return new Object[]{0};
                }
            } else {
                Item type;
                this.ITEM_TYPE_STORED = type = items.func_77973_b();
                this.ITEM_META_STORED = items.func_77960_j();
                this.STACK_SIZE = type.getItemStackLimit(items);
                this.MAX_SIZE = 64 * this.STACK_SIZE;
            }
            this.CURRENT_USAGE += amount;
            ItemStack newStack = new ItemStack(items.func_77973_b());
            newStack.func_77964_b(this.ITEM_META_STORED);
            if (items.field_77994_a - amount <= 0) {
                newStack = null;
            } else {
                newStack.field_77994_a = items.field_77994_a - amount;
            }
            this.turtle.getInventory().func_70299_a(this.turtle.getSelectedSlot(), newStack);
            this.changed = true;
            return new Object[]{amount};
        }
        if (method == 2) {
            if (this.ITEM_TYPE_STORED != null) {
                return new Object[]{Item.field_150901_e.func_148750_c((Object)this.ITEM_TYPE_STORED)};
            }
        } else if (method == 3) {
            if (this.ITEM_TYPE_STORED != null) {
                return new Object[]{new ItemStack(this.ITEM_TYPE_STORED).func_82833_r()};
            }
        } else if (method == 4) {
            if (this.ITEM_TYPE_STORED != null) {
                return new Object[]{Item.func_150891_b((Item)this.ITEM_TYPE_STORED)};
            }
        } else {
            if (method == 5) {
                int amount = 0;
                if (this.ITEM_TYPE_STORED != null) {
                    amount = this.CURRENT_USAGE;
                }
                return new Object[]{amount};
            }
            if (method == 6) {
                int[] ids = OreDictionary.getOreIDs((ItemStack)new ItemStack(this.ITEM_TYPE_STORED));
                HashMap<Integer, String> entries = new HashMap<Integer, String>();
                for (int i = 0; i < ids.length; ++i) {
                    entries.put(i, OreDictionary.getOreName((int)ids[i]));
                }
                return new Object[]{entries};
            }
        }
        return new Object[0];
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public void update() {
        NBTTagCompound tag = this.turtle.getUpgradeNBTData(this.side);
        tag.func_74768_a("maxSize", this.MAX_SIZE);
        tag.func_74768_a("stackSize", this.STACK_SIZE);
        tag.func_74768_a("currentUsage", this.CURRENT_USAGE);
        if (this.ITEM_TYPE_STORED == null) {
            tag.func_74757_a("isKnown", false);
        } else {
            tag.func_74757_a("isKnown", true);
            tag.func_74768_a("itemID", Item.func_150891_b((Item)this.ITEM_TYPE_STORED));
            tag.func_74768_a("stackMeta", this.ITEM_META_STORED);
        }
        this.turtle.updateUpgradeNBTData(this.side);
        this.changed = false;
    }
}

