/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles;

import com.austinv11.peripheralsplusplus.entities.EntityRidableTurtle;
import com.austinv11.peripheralsplusplus.init.ModBlocks;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.turtles.peripherals.PeripheralRidable;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class TurtleRidable
implements ITurtleUpgrade {
    public int getUpgradeID() {
        return 130;
    }

    public String getUnlocalisedAdjective() {
        return "PeripheralsPlusPlus".toLowerCase() + ".turtleUpgrade.ridable";
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    public ItemStack getCraftingItem() {
        if (Config.enableRidableTurtle) {
            return new ItemStack(Items.field_151141_av);
        }
        return null;
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new PeripheralRidable(turtle);
    }

    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int direction) {
        return null;
    }

    public IIcon getIcon(ITurtleAccess turtle, TurtleSide side) {
        return ModBlocks.dummyBlock.func_149691_a(0, 4);
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
        if (!Config.enableRidableTurtle) {
            return;
        }
        World world = turtle.getWorld();
        if (!world.field_72995_K) {
            try {
                TurtleRidable.getEntity(turtle);
            }
            catch (Exception e) {
                EntityRidableTurtle ridableTurtle = new EntityRidableTurtle(world);
                ridableTurtle.func_70107_b((double)turtle.getPosition().field_71574_a + 0.5, turtle.getPosition().field_71572_b, (double)turtle.getPosition().field_71573_c + 0.5);
                ridableTurtle.setTurtle(turtle);
                world.func_72838_d((Entity)ridableTurtle);
            }
        }
    }

    public static EntityRidableTurtle getEntity(ITurtleAccess turtle) throws Exception {
        List entities = TurtleRidable.getNearbyEntities(turtle, 0, 1, EntityRidableTurtle.class);
        if (entities.size() < 1) {
            throw new Exception("No entity bound to turtle.");
        }
        return (EntityRidableTurtle)((Object)entities.get(0));
    }

    public static List getNearbyEntities(ITurtleAccess turtle, int radiusStart, int radiusEnd, Class entityType) {
        World world = turtle.getWorld();
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(turtle.getPosition().field_71574_a - radiusStart), (double)(turtle.getPosition().field_71572_b - radiusStart), (double)(turtle.getPosition().field_71573_c - radiusStart), (double)(turtle.getPosition().field_71574_a + radiusEnd), (double)(turtle.getPosition().field_71572_b + radiusEnd), (double)(turtle.getPosition().field_71573_c + radiusEnd));
        return world.func_72872_a(entityType, bb);
    }
}

