/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import com.austinv11.collectiveframework.minecraft.tiles.NetworkedTileEntity;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.ReflectionHelper;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRFCharger
extends NetworkedTileEntity
implements IEnergyReceiver {
    private EnergyStorage storage = new EnergyStorage(80000);
    public static String publicName = "rfCharger";
    private String name = "tileEntityrfCharger";

    public String getName() {
        return this.name;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.storage.readFromNBT(nbttagcompound);
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.storage.writeToNBT(nbttagcompound);
    }

    public void func_145845_h() {
        if (!this.func_145831_w().field_72995_K) {
            ArrayList<ITurtleAccess> turtles = new ArrayList<ITurtleAccess>(6);
            ForgeDirection[] dirs = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.UP, ForgeDirection.WEST};
            for (int i = 0; i < 6; ++i) {
                TileEntity te;
                int x = this.field_145851_c + dirs[i].offsetX;
                int y = this.field_145848_d + dirs[i].offsetY;
                int z = this.field_145849_e + dirs[i].offsetZ;
                if (!this.func_145831_w().func_72899_e(x, y, z) || (te = this.func_145831_w().func_147438_o(x, y, z)) == null) continue;
                try {
                    ITurtleAccess turtle = ReflectionHelper.getTurtle(te);
                    if (turtle == null) continue;
                    turtles.add(turtle);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            int rate = (int)Math.floor(6.0f / (float)turtles.size());
            for (ITurtleAccess turtle : turtles) {
                if (this.storage.getEnergyStored() < rate) continue;
                this.storage.extractEnergy(this.addFuel(turtle, rate) * Config.fuelRF, false);
            }
        }
    }

    private int addFuel(ITurtleAccess turtle, int rate) {
        if (turtle.getFuelLimit() > turtle.getFuelLevel()) {
            turtle.setFuelLevel(rate + turtle.getFuelLevel());
            return rate;
        }
        return 0;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }
}

