/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.core.WorldSettings;
import com.austinv11.peripheralsplusplus.init.ModBlocks;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.MountedTileEntity;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(modid="appliedenergistics2", iface="appeng.api.networking.security.IActionHost", striprefs=true), @Optional.Interface(modid="appliedenergistics2", iface="appeng.api.networking.IGridBlock", striprefs=true)})
public class TileEntityMEBridge
extends MountedTileEntity
implements IActionHost,
IGridBlock {
    public static String publicName = "meBridge";
    private String name = "tileEntityMEBridge";
    private HashMap<IComputerAccess, Boolean> computers = new HashMap();
    private IGridNode node;
    private boolean initialized = false;
    public EntityPlayer placed;

    public String getName() {
        return this.name;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (this.node != null) {
            this.node.destroy();
        }
        this.node = AEApi.instance().createGridNode((IGridBlock)this);
        this.node.loadFromNBT("node", nbttagcompound);
        this.initialized = false;
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.node != null) {
            this.node.saveToNBT("node", nbttagcompound);
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && !this.initialized) {
            if (this.placed != null) {
                this.getNode().setPlayerID(WorldSettings.getInstance().getPlayerID(this.placed.func_146103_bH()));
            }
            this.getNode().updateState();
            this.initialized = true;
        }
    }

    public String getType() {
        return publicName;
    }

    public String[] getMethodNames() {
        return new String[]{"listAll", "listItems", "listCraft", "retrieve", "craft"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableMEBridge) {
            throw new LuaException("ME Bridges have been disabled");
        }
        IMEMonitor monitor = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getItemInventory();
        switch (method) {
            case 0: {
                return new Object[]{this.iteratorToMap(monitor.getStorageList().iterator(), 0)};
            }
            case 1: {
                return new Object[]{this.iteratorToMap(monitor.getStorageList().iterator(), 1)};
            }
            case 2: {
                return new Object[]{this.iteratorToMap(monitor.getStorageList().iterator(), 2)};
            }
            case 3: {
                if (arguments.length < 3) {
                    throw new LuaException("Too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new LuaException("Bad argument #1 (expected string)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number");
                }
                if (!(arguments[2] instanceof String) && !(arguments[2] instanceof Double)) {
                    throw new LuaException("Bad argument #3 (expected string or number)");
                }
                Item item = GameRegistry.findItem((String)((String)arguments[0]).split(":")[0], (String)((String)arguments[0]).split(":")[1].split(" ")[0]);
                long amount = (int)((Double)arguments[1]).doubleValue();
                ForgeDirection dir = arguments[2] instanceof String ? ForgeDirection.valueOf((String)((String)arguments[2]).toUpperCase()) : ForgeDirection.getOrientation((int)((int)((Double)arguments[2]).doubleValue()));
                if (!this.isInventoryOnSide(dir)) {
                    throw new LuaException("Block is not a valid inventory");
                }
                IInventory inventory = this.getInventoryForSide(dir);
                long extracted = 0L;
                int meta = ((String)arguments[0]).contains(" ") ? Integer.valueOf(((String)arguments[0]).split(" ")[1]) : 0;
                IAEItemStack stack = this.findAEStackFromItemStack((IMEMonitor<IAEItemStack>)monitor, new ItemStack(item, 1, meta));
                if (stack != null) {
                    if (amount > stack.getStackSize()) {
                        amount = stack.getStackSize();
                    }
                    if (amount > (long)this.getRemainingSlots(item, inventory)) {
                        amount = this.getRemainingSlots(item, inventory);
                    }
                    IAEItemStack stackToGet = stack.copy();
                    stackToGet.setStackSize(amount);
                    IAEItemStack resultant = (IAEItemStack)monitor.extractItems((IAEStack)stackToGet, Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                    if (resultant != null) {
                        extracted = resultant.getStackSize();
                        int[] slots = inventory instanceof ISidedInventory ? ((ISidedInventory)inventory).func_94128_d(dir.getOpposite().flag) : this.getDefaultSlots(inventory);
                        for (int currentSlot = 0; resultant.getStackSize() >= 1L && currentSlot < slots.length; ++currentSlot) {
                            if (!inventory.func_94041_b(slots[currentSlot], new ItemStack(resultant.getItem()))) continue;
                            if (inventory.func_70301_a(slots[currentSlot]) == null) {
                                int stackSize;
                                ItemStack toAdd = resultant.getItemStack();
                                toAdd.field_77994_a = stackSize = (int)(resultant.getStackSize() <= (long)inventory.func_70297_j_() ? resultant.getStackSize() : (long)inventory.func_70297_j_());
                                inventory.func_70299_a(slots[currentSlot], toAdd);
                                resultant.setStackSize(resultant.getStackSize() - (long)stackSize);
                            } else {
                                ItemStack toAdd;
                                ItemStack current = inventory.func_70301_a(slots[currentSlot]);
                                if (current.func_77969_a(toAdd = resultant.getItemStack())) {
                                    int stackSize = (int)(resultant.getStackSize() + (long)current.field_77994_a <= (long)inventory.func_70297_j_() ? resultant.getStackSize() + (long)current.field_77994_a : (long)inventory.func_70297_j_());
                                    int change = stackSize - current.field_77994_a;
                                    current.field_77994_a = stackSize;
                                    inventory.func_70299_a(slots[currentSlot], current);
                                    resultant.setStackSize(resultant.getStackSize() - (long)change);
                                }
                            }
                            inventory.func_70296_d();
                        }
                    }
                }
                return new Object[]{extracted};
            }
            case 4: {
                int meta_;
                if (arguments.length < 2) {
                    throw new LuaException("Too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new LuaException("Bad argument #1 (expected string)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number");
                }
                final ICraftingGrid craftingGrid = (ICraftingGrid)this.node.getGrid().getCache(ICraftingGrid.class);
                Item toCraft = GameRegistry.findItem((String)((String)arguments[0]).split(":")[0], (String)((String)arguments[0]).split(":")[1].split(" ")[0]);
                IAEItemStack aeToCraft_ = this.findAEStackFromItemStack((IMEMonitor<IAEItemStack>)monitor, new ItemStack(toCraft, 1, meta_ = ((String)arguments[0]).contains(" ") ? Integer.valueOf(((String)arguments[0]).split(" ")[1]) : 0));
                if (aeToCraft_ != null && aeToCraft_.isCraftable()) {
                    IAEItemStack aeToCraft = aeToCraft_.copy();
                    aeToCraft.setStackSize((long)((int)((Double)arguments[1]).doubleValue()));
                    TileEntityMEBridge tileEntityMEBridge = this;
                    synchronized (tileEntityMEBridge) {
                        craftingGrid.beginCraftingJob(this.field_145850_b, this.node.getGrid(), (BaseActionSource)new MachineSource((IActionHost)this), aeToCraft, new ICraftingCallback(){

                            public void calculationComplete(ICraftingJob job) {
                                craftingGrid.submitJob(job, null, null, false, (BaseActionSource)new MachineSource((IActionHost)TileEntityMEBridge.this.getMachine()));
                                for (IComputerAccess comp : TileEntityMEBridge.this.computers.keySet()) {
                                    comp.queueEvent("craftingComplete", new Object[]{Item.field_150901_e.func_148750_c((Object)job.getOutput().getItem()), job.getOutput().getStackSize(), job.getByteTotal()});
                                }
                            }
                        });
                    }
                }
                return new Object[0];
            }
        }
        return new Object[0];
    }

    private int[] getDefaultSlots(IInventory inventory) {
        int[] array = new int[inventory.func_70302_i_()];
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            array[i] = i;
        }
        return array;
    }

    private boolean isInventoryOnSide(ForgeDirection dir) {
        if (!this.field_145850_b.func_147437_c(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ)) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (block instanceof BlockContainer || block instanceof IInventory) {
                return true;
            }
            if (block.hasTileEntity(this.field_145850_b.func_72805_g(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ))) {
                return this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) instanceof IInventory;
            }
        }
        return false;
    }

    private IInventory getInventoryForSide(ForgeDirection dir) {
        if (!this.field_145850_b.func_147437_c(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ)) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (block instanceof IInventory) {
                return (IInventory)block;
            }
            if (block instanceof BlockContainer && block.hasTileEntity(this.field_145850_b.func_72805_g(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ))) {
                return (IInventory)this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            }
        }
        return null;
    }

    private int getRemainingSlots(Item item, IInventory inventory) {
        int slots = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_94041_b(i, new ItemStack(item)) && inventory.func_70301_a(i) == null) {
                slots += inventory.func_70297_j_();
                continue;
            }
            if (!inventory.func_94041_b(i, new ItemStack(item)) || inventory.func_70301_a(i).func_77973_b() != item || inventory.func_70297_j_() < inventory.func_70301_a((int)i).field_77994_a) continue;
            slots += inventory.func_70297_j_() - inventory.func_70301_a((int)i).field_77994_a;
        }
        return slots;
    }

    @Override
    public void attach(IComputerAccess computer) {
        this.computers.put(computer, true);
        super.attach(computer);
    }

    @Override
    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
        super.detach(computer);
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.destroy();
            this.node = null;
            this.initialized = false;
        }
    }

    private IAEItemStack findAEStackFromItemStack(IMEMonitor<IAEItemStack> monitor, ItemStack item) {
        IAEItemStack stack = null;
        for (IAEItemStack temp : monitor.getStorageList()) {
            if (!temp.isSameType(item)) continue;
            stack = temp;
            break;
        }
        return stack;
    }

    private HashMap<Integer, Object> iteratorToMap(Iterator<IAEItemStack> iterator, int flag) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        int i = 1;
        while (iterator.hasNext()) {
            Object o = this.getObjectFromStack(iterator.next(), flag);
            if (o == null) continue;
            map.put(i, o);
            ++i;
        }
        return map;
    }

    private Object getObjectFromStack(IAEItemStack stack, int flag) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String itemName = Item.field_150901_e.func_148750_c((Object)stack.getItem());
        int meta = stack.getItemDamage();
        long amount = stack.getStackSize();
        String displayName = stack.getItemStack().func_82833_r();
        map.put("name", itemName);
        map.put("meta", meta);
        map.put("amount", amount);
        map.put("displayName", displayName);
        if (flag == 0) {
            return map;
        }
        if (flag == 1 ? stack.getCountRequestable() > 0L : flag == 2 && stack.isCraftable()) {
            return map;
        }
        return null;
    }

    private IGridNode getNode() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return null;
        }
        this.node = AEApi.instance().createGridNode((IGridBlock)this);
        return this.node;
    }

    public double getIdlePowerUsage() {
        return 1.0;
    }

    public EnumSet<GridFlags> getFlags() {
        return EnumSet.of(GridFlags.REQUIRE_CHANNEL);
    }

    public boolean isWorldAccessible() {
        return true;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public AEColor getGridColor() {
        return AEColor.Transparent;
    }

    public void onGridNotification(GridNotification notification) {
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("gridNotification", new Object[]{notification.toString()});
        }
    }

    public void setNetworkStatus(IGrid grid, int channelsInUse) {
    }

    public EnumSet<ForgeDirection> getConnectableSides() {
        return EnumSet.allOf(ForgeDirection.class);
    }

    public IGridHost getMachine() {
        return this;
    }

    public void gridChanged() {
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("gridChanged", new Object[0]);
        }
    }

    public ItemStack getMachineRepresentation() {
        return new ItemStack((Block)ModBlocks.meBridge);
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        return this.node;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    public void securityBreak() {
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("securityBreak", new Object[0]);
        }
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public IGridNode getActionableNode() {
        return this.node;
    }
}

