/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.MountedTileEntity;
import com.austinv11.peripheralsplusplus.utils.ChatUtil;
import com.austinv11.peripheralsplusplus.utils.Util;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Vec3;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class TileEntityChatBox
extends MountedTileEntity {
    public static String publicName = "chatBox";
    private String name = "tileEntityChatBox";
    private HashMap<IComputerAccess, Boolean> computers = new HashMap();
    private static final int TICKER_INTERVAL = 20;
    private int ticker = 0;
    private int subticker = 0;
    private ITurtleAccess turtle;

    public TileEntityChatBox() {
    }

    public TileEntityChatBox(ITurtleAccess turtle) {
        this.field_145851_c = turtle.getPosition().field_71574_a;
        this.field_145848_d = turtle.getPosition().field_71572_b;
        this.field_145849_e = turtle.getPosition().field_71573_c;
        this.func_145834_a(turtle.getWorld());
        this.turtle = turtle;
    }

    public String getName() {
        return this.name;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
    }

    public void func_145845_h() {
        if (this.subticker > 0) {
            --this.subticker;
        }
        if (this.subticker == 0 && this.ticker != 0) {
            this.ticker = 0;
        }
    }

    public void updateEntity(boolean turtle) {
        if (turtle) {
            this.field_145851_c = this.turtle.getPosition().field_71574_a;
            this.field_145848_d = this.turtle.getPosition().field_71572_b;
            this.field_145849_e = this.turtle.getPosition().field_71573_c;
        }
        this.func_145845_h();
    }

    public void onChat(EntityPlayer player, String message) {
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("chat", new Object[]{player.getDisplayName(), message});
        }
    }

    public void onDeath(EntityPlayer player, DamageSource source) {
        Entity ent;
        String killer = null;
        if (source instanceof EntityDamageSource && (ent = ((EntityDamageSource)source).func_76346_g()) != null) {
            killer = ent.func_70005_c_();
        }
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("death", new Object[]{player.getDisplayName(), killer, source.field_76373_n});
        }
    }

    public void onCommand(EntityPlayerMP player, String message) {
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("command", new Object[]{player.getDisplayName(), Util.arrayToMap(message.split(" "))});
        }
    }

    public String getType() {
        return publicName;
    }

    public String[] getMethodNames() {
        return new String[]{"say", "tell"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (Config.enableChatBox) {
            if (method == 0) {
                if (arguments.length < 1) {
                    throw new LuaException("Too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new LuaException("Bad argument #1 (expected string)");
                }
                if (arguments.length > 1 && !(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                if (arguments.length > 2 && !(arguments[2] instanceof Boolean)) {
                    throw new LuaException("Bad argument #3 (expected boolean)");
                }
                if (arguments.length > 3) {
                    if (Config.logCoords) {
                        throw new LuaException("Coordinate logging is enabled, disable this to enable naming");
                    }
                    if (!(arguments[3] instanceof String)) {
                        throw new LuaException("Bad argument #4 (expected string)");
                    }
                }
                if (this.ticker == Config.sayRate) {
                    throw new LuaException("Please try again later, you are sending messages too often");
                }
                String message = Config.logCoords ? ChatUtil.getCoordsPrefix(this) + (String)arguments[0] : (!Config.logCoords && arguments.length > 3 ? "[" + (String)arguments[3] + "] " + (String)arguments[0] : "[@] " + (String)arguments[0]);
                double range = Config.sayRange < 0.0 ? Double.MAX_VALUE : Config.sayRange;
                if (arguments.length > 1) {
                    range = (Double)arguments[1];
                }
                TileEntityChatBox tileEntityChatBox = this;
                synchronized (tileEntityChatBox) {
                    ChatUtil.sendMessage(this, message, range, arguments.length > 2 && (Boolean)arguments[2] != false && Config.allowUnlimitedVertical);
                    this.subticker = 20;
                    ++this.ticker;
                }
                return new Object[]{true};
            }
            if (method == 1) {
                if (arguments.length < 2) {
                    throw new LuaException("Too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new LuaException("Bad argument #1 (expected string)");
                }
                if (!(arguments[1] instanceof String)) {
                    throw new LuaException("Bad argument #2 (expected string)");
                }
                if (arguments.length > 2 && !(arguments[2] instanceof Double)) {
                    throw new LuaException("Bad argument #3 (expected number)");
                }
                if (arguments.length > 3 && !(arguments[3] instanceof Boolean)) {
                    throw new LuaException("Bad argument #4 (expected boolean)");
                }
                if (arguments.length > 4) {
                    if (Config.logCoords) {
                        throw new LuaException("Coordinate logging is enabled, disable this to enable naming");
                    }
                    if (!(arguments[4] instanceof String)) {
                        throw new LuaException("Bad argument #5 (expected string)");
                    }
                }
                if (this.ticker == Config.sayRate) {
                    throw new LuaException("Please try again later, you are sending messages too often");
                }
                String message = Config.logCoords ? ChatUtil.getCoordsPrefix(this) + (String)arguments[1] : (!Config.logCoords && arguments.length > 4 ? "[" + (String)arguments[4] + "] " + (String)arguments[1] : "[@] " + (String)arguments[1]);
                double range = Config.sayRange < 0.0 ? Double.MAX_VALUE : Config.sayRange;
                if (arguments.length > 2) {
                    range = (Double)arguments[2];
                }
                this.subticker = 20;
                ++this.ticker;
                return new Object[]{ChatUtil.sendMessage((String)arguments[0], this, message, range, arguments.length > 3 && (Boolean)arguments[3] != false && Config.allowUnlimitedVertical)};
            }
        } else {
            throw new LuaException("Chat boxes have been disabled");
        }
        return new Object[0];
    }

    @Override
    public void attach(IComputerAccess computer) {
        if (this.computers.size() == 0) {
            ChatListener.chatBoxMap.put(this, true);
        }
        this.computers.put(computer, true);
        super.attach(computer);
    }

    @Override
    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
        if (this.computers.size() == 0) {
            ChatListener.chatBoxMap.remove(this);
        }
        super.detach(computer);
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }

    public static class ChatListener {
        private static HashMap<TileEntityChatBox, Boolean> chatBoxMap = new HashMap();

        @SubscribeEvent
        public void onChat(ServerChatEvent event) {
            block4: {
                if (!Config.enableChatBox) break block4;
                String commandPrefix = Config.chatboxCommandPrefix.trim();
                if (!commandPrefix.equals("") && !commandPrefix.equals(" ") && event.message.startsWith(commandPrefix)) {
                    event.setCanceled(true);
                    for (TileEntityChatBox box : chatBoxMap.keySet()) {
                        if (!(Config.readRange < 0.0) && !(Vec3.func_72443_a((double)box.field_145851_c, (double)box.field_145848_d, (double)box.field_145849_e).func_72438_d(event.player.func_70666_h(1.0f)) <= Config.readRange)) continue;
                        box.onCommand(event.player, event.message);
                    }
                } else {
                    for (TileEntityChatBox box : chatBoxMap.keySet()) {
                        if (!(Config.readRange < 0.0) && !(Vec3.func_72443_a((double)box.field_145851_c, (double)box.field_145848_d, (double)box.field_145849_e).func_72438_d(event.player.func_70666_h(1.0f)) <= Config.readRange)) continue;
                        box.onChat((EntityPlayer)event.player, event.message);
                    }
                }
            }
        }

        @SubscribeEvent
        public void onDeath(LivingDeathEvent event) {
            if (Config.enableChatBox && event.entity instanceof EntityPlayer) {
                for (TileEntityChatBox box : chatBoxMap.keySet()) {
                    if (!(Config.readRange < 0.0) && !(Vec3.func_72443_a((double)box.field_145851_c, (double)box.field_145848_d, (double)box.field_145849_e).func_72438_d(((EntityPlayer)event.entity).func_70666_h(1.0f)) <= Config.readRange)) continue;
                    box.onDeath((EntityPlayer)event.entity, event.source);
                }
            }
        }
    }
}

