/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.MountedTileEntityInventory;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityAnalyzer
extends MountedTileEntityInventory {
    private String name = "tileEntityAnalyzer";

    public TileEntityAnalyzer() {
        this.invName = "Analyzer";
    }

    public int getSize() {
        return 1;
    }

    public String getName() {
        return this.name;
    }

    public abstract String getPublicName();

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
    }

    public String getType() {
        return this.getPublicName();
    }

    public String[] getMethodNames() {
        return new String[]{"analyze", "isMember"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableAnalyzers) {
            throw new LuaException("Analyzers have been disabled");
        }
        switch (method) {
            case 0: {
                ISpeciesRoot root = this.getRoot();
                ItemStack stack = this.func_70301_a(0);
                if (stack == null || !root.isMember(stack)) {
                    return new Object[]{false};
                }
                IIndividual individual = root.getMember(stack);
                if (!individual.isAnalyzed()) {
                    return new Object[]{null};
                }
                HashMap<String, Object> ret = new HashMap<String, Object>();
                this.addGenome(stack, individual.getGenome(), ret);
                return new Object[]{ret};
            }
            case 1: {
                ItemStack specimen = this.func_70301_a(0);
                if (specimen == null || !this.getRoot().isMember(specimen)) {
                    return new Object[]{false};
                }
                return new Object[]{true};
            }
        }
        return new Object[0];
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    protected ISpeciesRoot getRoot() {
        return AlleleManager.alleleRegistry.getSpeciesRoot(this.getRootType());
    }

    protected abstract String getRootType();

    protected abstract void addGenome(ItemStack var1, IGenome var2, HashMap<String, Object> var3);

    protected abstract IPeripheral getInstance();
}

