/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.network;

import com.austinv11.peripheralsplusplus.client.gui.GuiHelmet;
import com.austinv11.peripheralsplusplus.client.gui.GuiSmartHelmetOverlay;
import com.austinv11.peripheralsplusplus.smarthelmet.HelmetCommand;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayDeque;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CommandPacket
implements IMessage {
    public HelmetCommand[] commands;
    public UUID uuid;
    public boolean doAdd = false;
    public boolean isGui = false;

    public CommandPacket() {
    }

    public CommandPacket(HelmetCommand[] commands, UUID uuid) {
        this.commands = commands;
        this.uuid = uuid;
    }

    public CommandPacket(HelmetCommand[] commands, UUID uuid, boolean doAdd) {
        this(commands, uuid);
        this.doAdd = doAdd;
    }

    public CommandPacket(HelmetCommand[] commands, UUID uuid, boolean doAdd, boolean isGui) {
        this(commands, uuid, doAdd);
        this.isGui = isGui;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tagCompound = ByteBufUtils.readTag((ByteBuf)buf);
        this.uuid = UUID.fromString(tagCompound.func_74779_i("uuid"));
        int num = tagCompound.func_74762_e("num");
        this.commands = new HelmetCommand[num];
        for (int i = 0; i < num; ++i) {
            NBTTagCompound tag = tagCompound.func_74775_l(i + "");
            HelmetCommand command = null;
            try {
                command = HelmetCommand.getCommandFromName(tag.func_74779_i("type"));
                command.readFromNBT(tag.func_74775_l("command"));
                this.commands[i] = command;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.doAdd = tagCompound.func_74767_n("doAdd");
        this.isGui = tagCompound.func_74767_n("isGui");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("uuid", this.uuid.toString());
        tagCompound.func_74768_a("num", this.commands.length);
        for (int i = 0; i < this.commands.length; ++i) {
            if (this.commands[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("type", this.commands[i].getCommandName());
            NBTTagCompound command = new NBTTagCompound();
            this.commands[i].writeToNBT(command);
            tag.func_74782_a("command", (NBTBase)command);
            tagCompound.func_74782_a(i + "", (NBTBase)tag);
        }
        tagCompound.func_74757_a("doAdd", this.doAdd);
        tagCompound.func_74757_a("isGui", this.isGui);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tagCompound);
    }

    public static class CommandPacketHandler
    implements IMessageHandler<CommandPacket, IMessage> {
        public IMessage onMessage(CommandPacket message, MessageContext ctx) {
            ArrayDeque<Object> commands = new ArrayDeque();
            if (message.doAdd) {
                if (!message.isGui) {
                    if (GuiSmartHelmetOverlay.renderStack.containsKey(message.uuid)) {
                        commands = GuiSmartHelmetOverlay.renderStack.get(message.uuid);
                    }
                } else if (GuiHelmet.renderStack.containsKey(message.uuid)) {
                    commands = GuiHelmet.renderStack.get(message.uuid);
                }
            }
            for (HelmetCommand command : message.commands) {
                if (command == null) continue;
                commands.offer(command);
            }
            if (message.isGui) {
                GuiHelmet.renderStack.put(message.uuid, commands);
            } else {
                GuiSmartHelmetOverlay.renderStack.put(message.uuid, commands);
            }
            return null;
        }
    }
}

