/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.items;

import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.entities.EntityNanoBotSwarm;
import com.austinv11.peripheralsplusplus.entities.NanoProperties;
import com.austinv11.peripheralsplusplus.items.ItemPPP;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.TileEntityAntenna;
import java.util.UUID;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ItemNanoSwarm
extends ItemPPP {
    public ItemNanoSwarm() {
        this.func_77625_d(16);
        this.func_77655_b("nanoSwarm");
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (NBTHelper.hasTag((ItemStack)stack, (String)"identifier")) {
            if (!world.field_72995_K) {
                EntityNanoBotSwarm swarm = new EntityNanoBotSwarm(world, (EntityLivingBase)player);
                swarm.antennaIdentifier = UUID.fromString(NBTHelper.getString((ItemStack)stack, (String)"identifier"));
                if (NBTHelper.hasTag((ItemStack)stack, (String)"label")) {
                    swarm.label = NBTHelper.getString((ItemStack)stack, (String)"label");
                }
                world.func_72838_d((Entity)swarm);
            }
            --stack.field_77994_a;
        }
        return stack;
    }

    public static void addSwarmForEntity(EntityNanoBotSwarm swarm, Entity hit) {
        if (TileEntityAntenna.antenna_registry.containsKey(swarm.antennaIdentifier)) {
            TileEntityAntenna antenna = TileEntityAntenna.antenna_registry.get(swarm.antennaIdentifier);
            if (!antenna.associatedEntities.contains(hit)) {
                PeripheralsPlusPlus.LOGGER.info((Object)"Entity added by hit");
                antenna.associatedEntities.add(hit);
            }
            NanoProperties properties = (NanoProperties)hit.getExtendedProperties(NanoProperties.IDENTIFIER);
            properties.numOfBots += Config.numberOfInstructions;
            properties.antennaID = swarm.antennaIdentifier;
            PeripheralsPlusPlus.LOGGER.info((Object)("Properties: " + properties.antennaID));
        }
    }

    public static boolean doInstruction(UUID identifier, Entity performer) {
        if (!performer.field_70128_L && TileEntityAntenna.antenna_registry.containsKey(identifier)) {
            TileEntityAntenna antenna = TileEntityAntenna.antenna_registry.get(identifier);
            if (antenna.associatedEntities.contains(performer)) {
                NanoProperties properties = (NanoProperties)performer.getExtendedProperties(NanoProperties.IDENTIFIER);
                --properties.numOfBots;
                if (properties.numOfBots == 0) {
                    antenna.associatedEntities.remove(performer);
                }
                return true;
            }
        }
        return false;
    }

    public static class BehaviorNanoSwarm
    extends BehaviorDefaultDispenseItem {
        public ItemStack func_82487_b(IBlockSource blockSource, ItemStack stack) {
            EntityNanoBotSwarm iprojectile;
            EnumFacing enumfacing;
            World world;
            if (NBTHelper.hasTag((ItemStack)stack, (String)"identifier")) {
                world = blockSource.func_82618_k();
                IPosition iposition = BlockDispenser.func_149939_a((IBlockSource)blockSource);
                enumfacing = BlockDispenser.func_149937_b((int)blockSource.func_82620_h());
                iprojectile = new EntityNanoBotSwarm(world, iposition.func_82615_a(), iposition.func_82617_b(), iposition.func_82616_c());
                iprojectile.antennaIdentifier = UUID.fromString(NBTHelper.getString((ItemStack)stack, (String)"identifier"));
                if (NBTHelper.hasTag((ItemStack)stack, (String)"label")) {
                    iprojectile.label = NBTHelper.getString((ItemStack)stack, (String)"label");
                }
            } else {
                return super.func_82487_b(blockSource, stack);
            }
            iprojectile.func_70186_c(enumfacing.func_82601_c(), (float)enumfacing.func_96559_d() + 0.1f, enumfacing.func_82599_e(), this.func_82500_b(), this.func_82498_a());
            world.func_72838_d((Entity)iprojectile);
            stack.func_77979_a(1);
            return stack;
        }

        protected void func_82485_a(IBlockSource blockSource) {
            blockSource.func_82618_k().func_72926_e(1002, blockSource.func_82623_d(), blockSource.func_82622_e(), blockSource.func_82621_f(), 0);
        }

        protected float func_82498_a() {
            return 6.0f;
        }

        protected float func_82500_b() {
            return 1.1f;
        }
    }
}

