/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.lookingglass.proxyworld;

import com.xcompwiz.lookingglass.log.LoggerUtils;
import com.xcompwiz.lookingglass.network.ServerPacketDispatcher;
import com.xcompwiz.lookingglass.network.packet.PacketChunkInfo;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public class ChunkFinder {
    private final IChunkProvider chunkProvider;
    private final int rootX;
    private final int rootZ;
    private final int range;
    private final int dimension;
    private final EntityPlayer player;
    private ChunkData[][] map;
    private List<ChunkCoordinates> cc;
    private final int d;
    private int step;
    private int stepRange;
    private long startTime;

    public ChunkFinder(ChunkCoordinates root, int dimension, IChunkProvider chunkProvider, EntityPlayer player, int range) {
        this.chunkProvider = chunkProvider;
        this.range = range;
        this.dimension = dimension;
        this.player = player;
        this.d = (range << 1) + 1;
        this.map = new ChunkData[this.d][this.d];
        this.rootX = root.field_71574_a - range;
        this.rootZ = root.field_71573_c - range;
        this.stepRange = 16 - root.field_71572_b;
        if (root.field_71572_b > this.stepRange) {
            this.stepRange = root.field_71572_b;
        }
        this.startTime = System.nanoTime();
        LoggerUtils.debug("ChunkFinder scan started at nano: " + this.startTime, new Object[0]);
        for (int i = 0; i < this.d; ++i) {
            for (int j = 0; j < this.d; ++j) {
                this.map[i][j] = new ChunkData(i + this.rootX, j + this.rootZ);
                int x1 = i - range;
                int z1 = j - range;
                this.map[i][j].distance = x1 * x1 + z1 * z1;
            }
        }
        this.cc = new LinkedList<ChunkCoordinates>();
        this.cc.add(new ChunkCoordinates(range, root.field_71572_b, range));
        this.step = 0;
        LinkedList<ChunkCoordinates> cc2 = new LinkedList<ChunkCoordinates>();
        while (this.step - 1 < this.stepRange && !this.cc.isEmpty()) {
            while (!this.cc.isEmpty()) {
                cc2.addAll(ChunkFinder.scan(chunkProvider, this.map, this.cc.get(0), range));
                this.cc.remove(0);
            }
            ++this.step;
            this.cc.addAll(cc2);
            cc2.clear();
            if (this.step < this.stepRange) continue;
            int range2 = this.step - this.stepRange + 1;
            range2 *= range2;
            int range3 = this.step - this.stepRange;
            if (range3 < 0) {
                range3 = 0;
            }
            range3 *= range3;
            int minStep = range - (this.step - this.stepRange);
            int maxStep = range + (this.step - this.stepRange) + 1;
            if (minStep < 0) {
                minStep = 0;
            }
            if (maxStep > this.d) {
                maxStep = this.d;
            }
            for (int i = minStep; i < maxStep; ++i) {
                for (int j = minStep; j < maxStep; ++j) {
                    int dist = this.map[i][j].distance;
                    if (!this.map[i][j].doAdd() || dist >= range2 || dist < range3) continue;
                    ChunkData data = this.map[i][j];
                    Chunk c2 = chunkProvider.func_73154_d(data.x, data.z);
                    if (!c2.field_76636_d) {
                        c2 = chunkProvider.func_73158_c(data.x, data.z);
                    }
                    ServerPacketDispatcher.getInstance().addPacket(player, PacketChunkInfo.createPacket(c2, true, data.levels(), dimension));
                }
            }
        }
    }

    public boolean findChunks() {
        if (!this.cc.isEmpty()) {
            LinkedList<ChunkCoordinates> cc2 = new LinkedList<ChunkCoordinates>();
            for (int tick = 0; !this.cc.isEmpty() && tick < 15; ++tick) {
                ChunkCoordinates ch = this.cc.get(0);
                cc2.addAll(ChunkFinder.scan(this.chunkProvider, this.map, ch, this.range));
                this.cc.remove(0);
            }
            if (!this.cc.isEmpty()) {
                return false;
            }
            ++this.step;
            this.cc.addAll(cc2);
            cc2.clear();
            if (this.step >= this.stepRange) {
                int range2 = this.step - this.stepRange + 1;
                range2 *= range2;
                int range3 = this.step - this.stepRange;
                if (range3 < 0) {
                    range3 = 0;
                }
                range3 *= range3;
                int minStep = this.range - (this.step - this.stepRange);
                int maxStep = this.range + (this.step - this.stepRange) + 1;
                if (minStep < 0) {
                    minStep = 0;
                }
                if (maxStep > this.d) {
                    maxStep = this.d;
                }
                for (int i = minStep; i < maxStep; ++i) {
                    for (int j = minStep; j < maxStep; ++j) {
                        int dist = this.map[i][j].distance;
                        if (!this.map[i][j].doAdd() || dist >= range2 || dist < range3) continue;
                        ChunkData data = this.map[i][j];
                        Chunk c2 = this.chunkProvider.func_73154_d(data.x, data.z);
                        if (!c2.field_76636_d) {
                            c2 = this.chunkProvider.func_73158_c(data.x, data.z);
                        }
                        ServerPacketDispatcher.getInstance().addPacket(this.player, PacketChunkInfo.createPacket(c2, true, data.levels(), this.dimension));
                    }
                }
            }
            return false;
        }
        if (this.step >= this.stepRange) {
            int range2 = this.step - this.stepRange;
            range2 *= range2;
            for (int i = 0; i < this.d; ++i) {
                for (int j = 0; j < this.d; ++j) {
                    int dist = this.map[i][j].distance;
                    if (!this.map[i][j].doAdd() || dist < range2) continue;
                    ChunkData data = this.map[i][j];
                    Chunk c2 = this.chunkProvider.func_73154_d(data.x, data.z);
                    if (!c2.field_76636_d) {
                        c2 = this.chunkProvider.func_73158_c(data.x, data.z);
                    }
                    ServerPacketDispatcher.getInstance().addPacket(this.player, PacketChunkInfo.createPacket(c2, true, data.levels(), this.dimension));
                }
            }
        }
        LoggerUtils.debug("Scan finished. nanoseconds: " + (System.nanoTime() - this.startTime), new Object[0]);
        return true;
    }

    private static List<ChunkCoordinates> scan(IChunkProvider chunkProvider, ChunkData[][] map, ChunkCoordinates coord, int range) {
        int rangeSqr = range * range;
        LinkedList<ChunkCoordinates> cc3 = new LinkedList<ChunkCoordinates>();
        int x = coord.field_71574_a;
        int z = coord.field_71573_c;
        ChunkData data = map[x][z];
        int y = coord.field_71572_b;
        if (data.isAdded(y) || data.distance > rangeSqr) {
            return cc3;
        }
        data.add(y);
        Chunk c = chunkProvider.func_73154_d(data.x, data.z);
        if (!c.field_76636_d) {
            c = chunkProvider.func_73158_c(data.x, data.z);
        }
        if (c.func_76606_c(y << 4, (y << 4) + 15)) {
            data.empty(y);
            if (x < range << 1 && !map[x + 1][z].isAdded(y) && map[x + 1][z].distance <= rangeSqr && map[x + 1][z].distance >= map[x][z].distance) {
                cc3.add(new ChunkCoordinates(x + 1, y, z));
            }
            if (x > 0 && !map[x - 1][z].isAdded(y) && map[x - 1][z].distance <= rangeSqr && map[x - 1][z].distance >= map[x][z].distance) {
                cc3.add(new ChunkCoordinates(x - 1, y, z));
            }
            if (y < 15 && !map[x][z].isAdded(y + 1) && map[x][z].distance <= rangeSqr) {
                cc3.add(new ChunkCoordinates(x, y + 1, z));
            }
            if (y > 0 && !map[x][z].isAdded(y - 1) && map[x][z].distance <= rangeSqr) {
                cc3.add(new ChunkCoordinates(x, y - 1, z));
            }
            if (z < range << 1 && !map[x][z + 1].isAdded(y) && map[x][z + 1].distance <= rangeSqr && map[x][z + 1].distance >= map[x][z].distance) {
                cc3.add(new ChunkCoordinates(x, y, z + 1));
            }
            if (z > 0 && !map[x][z - 1].isAdded(y) && map[x][z - 1].distance <= rangeSqr && map[x][z - 1].distance >= map[x][z].distance) {
                cc3.add(new ChunkCoordinates(x, y, z - 1));
            }
        } else {
            int l;
            int i;
            boolean ok = false;
            if (z > 0 && !map[x][z - 1].isAdded(y) && map[x][z - 1].distance <= rangeSqr && map[x][z - 1].distance >= map[x][z].distance) {
                for (i = 0; i < 16 && !ok; ++i) {
                    for (l = 0; l < 16 && !ok; ++l) {
                        if (ChunkFinder.isBlockNormalCubeDefault(c, l, (y << 4) + i, 0, false)) continue;
                        ok = true;
                    }
                }
                if (ok) {
                    cc3.add(new ChunkCoordinates(x, y, z - 1));
                }
                ok = false;
            }
            if (z < range << 1 && !map[x][z + 1].isAdded(y) && map[x][z + 1].distance <= rangeSqr && map[x][z + 1].distance >= map[x][z].distance) {
                for (i = 0; i < 16 && !ok; ++i) {
                    for (l = 0; l < 16 && !ok; ++l) {
                        if (ChunkFinder.isBlockNormalCubeDefault(c, l, (y << 4) + i, 15, false)) continue;
                        ok = true;
                    }
                }
                if (ok) {
                    cc3.add(new ChunkCoordinates(x, y, z + 1));
                }
                ok = false;
            }
            if (y > 0 && !map[x][z].isAdded(y - 1) && map[x][z].distance <= rangeSqr) {
                for (i = 0; i < 16 && !ok; ++i) {
                    for (l = 0; l < 16 && !ok; ++l) {
                        if (ChunkFinder.isBlockNormalCubeDefault(c, l, y << 4, i, false)) continue;
                        ok = true;
                    }
                }
                if (ok) {
                    cc3.add(new ChunkCoordinates(x, y - 1, z));
                }
                ok = false;
            }
            if (y < 15 && !map[x][z].isAdded(y + 1) && map[x][z].distance <= rangeSqr) {
                for (i = 0; i < 16 && !ok; ++i) {
                    for (l = 0; l < 16 && !ok; ++l) {
                        if (ChunkFinder.isBlockNormalCubeDefault(c, l, (y << 4) + 15, i, false)) continue;
                        ok = true;
                    }
                }
                if (ok) {
                    cc3.add(new ChunkCoordinates(x, y + 1, z));
                }
                ok = false;
            }
            if (x > 0 && !map[x - 1][z].isAdded(y) && map[x - 1][z].distance <= rangeSqr && map[x - 1][z].distance >= map[x][z].distance) {
                for (i = 0; i < 16 && !ok; ++i) {
                    for (l = 0; l < 16 && !ok; ++l) {
                        if (ChunkFinder.isBlockNormalCubeDefault(c, 0, (y << 4) + l, i, false)) continue;
                        ok = true;
                    }
                }
                if (ok) {
                    cc3.add(new ChunkCoordinates(x - 1, y, z));
                }
                ok = false;
            }
            if (x < range << 1 && !map[x + 1][z].isAdded(y) && map[x + 1][z].distance <= rangeSqr && map[x + 1][z].distance >= map[x][z].distance) {
                for (i = 0; i < 16 && !ok; ++i) {
                    for (l = 0; l < 16 && !ok; ++l) {
                        if (ChunkFinder.isBlockNormalCubeDefault(c, 15, (y << 4) + l, i, false)) continue;
                        ok = true;
                    }
                }
                if (ok) {
                    cc3.add(new ChunkCoordinates(x + 1, y, z));
                }
            }
        }
        return cc3;
    }

    public static boolean isBlockNormalCubeDefault(Chunk chunk, int par1, int par2, int par3, boolean par4) {
        if (par1 >= -30000000 && par3 >= -30000000 && par1 < 30000000 && par3 < 30000000 && chunk != null && !chunk.func_76621_g()) {
            Block block = chunk.func_150810_a(par1 & 0xF, par2, par3 & 0xF);
            return block.func_149721_r();
        }
        return par4;
    }

    public class ChunkData
    implements Comparable<ChunkData> {
        public int x;
        public int z;
        public int added;
        public int empty;
        public int distance;

        public ChunkData(int x, int z) {
            this.x = x;
            this.z = z;
            this.added = 0;
        }

        public boolean isAdded(int level) {
            return (this.added & 1 << level) != 0;
        }

        public boolean doAdd() {
            return (this.added ^ this.empty) != 0;
        }

        public boolean doAdd(int level) {
            return this.isAdded(level) && !this.isEmpty(level);
        }

        public void add(int level) {
            this.added |= 1 << level;
        }

        public boolean isEmpty(int level) {
            return (this.empty & 1 << level) == 0;
        }

        public void empty(int level) {
            this.empty |= 1 << level;
        }

        public int levels() {
            return this.added ^ this.empty;
        }

        @Override
        public int compareTo(ChunkData arg0) {
            return this.distance - arg0.distance;
        }
    }
}

