/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.lookingglass.client.proxyworld;

import com.xcompwiz.lookingglass.api.animator.ICameraAnimator;
import com.xcompwiz.lookingglass.api.view.IViewCamera;
import com.xcompwiz.lookingglass.api.view.IWorldView;
import com.xcompwiz.lookingglass.client.proxyworld.ViewCameraImpl;
import com.xcompwiz.lookingglass.client.render.FrameBufferContainer;
import com.xcompwiz.lookingglass.entity.EntityCamera;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class WorldView
implements IWorldView {
    public WorldClient worldObj;
    public final ChunkCoordinates coords;
    public final EntityCamera camera;
    public final IViewCamera camerawrapper;
    public final int width;
    public final int height;
    private boolean update;
    private boolean ready;
    private boolean hasChunks;
    private long last_render_time = -1L;
    private RenderGlobal renderGlobal;
    private EffectRenderer effectRenderer;
    private FrameBufferContainer fbo;

    public WorldView(WorldClient worldObj, ChunkCoordinates coords, int width, int height) {
        this.width = width;
        this.height = height;
        this.worldObj = worldObj;
        this.coords = coords;
        this.camera = new EntityCamera((World)worldObj, coords);
        this.camerawrapper = new ViewCameraImpl(this.camera);
        this.renderGlobal = new RenderGlobal(Minecraft.func_71410_x());
        this.effectRenderer = new EffectRenderer((World)worldObj, Minecraft.func_71410_x().func_110434_K());
        this.fbo = FrameBufferContainer.createNewFramebuffer(this, width, height);
    }

    public void cleanup() {
        this.fbo = null;
    }

    @Override
    public boolean isReady() {
        return this.fbo == null ? false : this.ready;
    }

    public boolean hasChunks() {
        return this.fbo == null ? false : this.hasChunks;
    }

    @Override
    public void markDirty() {
        this.update = true;
    }

    public boolean markClean() {
        if (this.fbo == null) {
            return false;
        }
        this.ready = true;
        boolean temp = this.update;
        this.update = false;
        return temp;
    }

    public int getFramebuffer() {
        return this.fbo == null ? 0 : this.fbo.getFramebuffer();
    }

    public RenderGlobal getRenderGlobal() {
        return this.renderGlobal;
    }

    public EffectRenderer getEffectRenderer() {
        return this.effectRenderer;
    }

    @Override
    public int getTexture() {
        return this.fbo == null ? 0 : this.fbo.getTexture();
    }

    @Override
    public void grab() {
    }

    @Override
    public boolean release() {
        return false;
    }

    public void onChunkReceived(int cx, int cz) {
        this.hasChunks = true;
        int cam_cx = MathHelper.func_76128_c((double)this.camera.field_70165_t) >> 4;
        int cam_cz = MathHelper.func_76128_c((double)this.camera.field_70161_v) >> 4;
        if (cam_cx >= cx - 1 && cam_cx <= cx + 1 && cam_cz > cz - 1 && cam_cz < cz + 1) {
            this.camera.refreshAnimator();
        }
    }

    public void updateWorldSpawn(ChunkCoordinates cc) {
        this.camera.updateWorldSpawn(cc);
    }

    public void startRender(long renderT) {
        if (this.last_render_time > 0L) {
            this.camera.tick(0.1f * (float)(renderT - this.last_render_time));
        }
        this.last_render_time = renderT;
    }

    @Override
    public void setAnimator(ICameraAnimator animator) {
        this.camera.setAnimator(animator);
    }

    @Override
    public IViewCamera getCamera() {
        return this.camerawrapper;
    }

    public void replaceWorldObject(WorldClient world) {
        this.worldObj = world;
        this.camera.field_70170_p = world;
        this.effectRenderer.func_78870_a((World)world);
        this.renderGlobal.func_72732_a(world);
    }
}

