/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.lookingglass.api.impl;

import com.xcompwiz.lookingglass.api.APIInstanceProvider;
import com.xcompwiz.lookingglass.api.APIUndefined;
import com.xcompwiz.lookingglass.api.APIVersionRemoved;
import com.xcompwiz.lookingglass.api.APIVersionUndefined;
import com.xcompwiz.lookingglass.api.impl.LookingGlassAPI2Wrapper;
import com.xcompwiz.lookingglass.api.impl.LookingGlassAPIWrapper;
import com.xcompwiz.lookingglass.api.impl.WrapperBuilder;
import com.xcompwiz.lookingglass.log.LoggerUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class APIProviderImpl
implements APIInstanceProvider {
    private String modname;
    private HashMap<String, Object> instances = new HashMap();
    private static Map<String, Map<Integer, WrapperBuilder>> apiCtors;
    private static Map<String, Set<Integer>> apiVersions;
    private static Map<String, Set<Integer>> apiVersions_immutable_sets;
    private static Map<String, Set<Integer>> apiVersions_immutable;

    public APIProviderImpl(String modname) {
        this.modname = modname;
    }

    public String getOwnerMod() {
        return this.modname;
    }

    @Override
    public Object getAPIInstance(String api) throws APIUndefined, APIVersionUndefined, APIVersionRemoved {
        Object ret = this.instances.get(api);
        if (ret != null) {
            return ret;
        }
        String[] splitName = api.split("-");
        if (splitName.length != 2) {
            throw new APIUndefined(api);
        }
        String apiname = splitName[0];
        int version = Integer.parseInt(splitName[1]);
        ret = APIProviderImpl.constructAPIWrapper(this.modname, apiname, version);
        this.instances.put(api, ret);
        return ret;
    }

    public static void init() {
        if (apiCtors != null) {
            return;
        }
        apiCtors = new HashMap<String, Map<Integer, WrapperBuilder>>();
        apiVersions = new HashMap<String, Set<Integer>>();
        apiVersions_immutable_sets = new HashMap<String, Set<Integer>>();
        apiVersions_immutable = Collections.unmodifiableMap(apiVersions_immutable_sets);
        APIProviderImpl.registerAPI("view", 1, new WrapperBuilder(LookingGlassAPIWrapper.class));
        APIProviderImpl.registerAPI("view", 2, new WrapperBuilder(LookingGlassAPI2Wrapper.class));
    }

    private static void registerAPI(String apiname, int version, WrapperBuilder builder) {
        APIProviderImpl.getVersions(apiname).add(version);
        APIProviderImpl.getCtors(apiname).put(version, builder);
    }

    private static Map<Integer, WrapperBuilder> getCtors(String apiname) {
        Map<Integer, WrapperBuilder> ctors = apiCtors.get(apiname);
        if (ctors == null) {
            ctors = new HashMap<Integer, WrapperBuilder>();
            apiCtors.put(apiname, ctors);
        }
        return ctors;
    }

    private static Set<Integer> getVersions(String apiname) {
        Set<Integer> versions = apiVersions.get(apiname);
        if (versions == null) {
            versions = new HashSet<Integer>();
            apiVersions.put(apiname, versions);
            apiVersions_immutable_sets.put(apiname, Collections.unmodifiableSet(versions));
        }
        return versions;
    }

    private static Object constructAPIWrapper(String owner, String apiname, int version) throws APIUndefined, APIVersionUndefined, APIVersionRemoved {
        if (apiCtors == null) {
            throw new RuntimeException("Something is broken. The LookingGlass API Provider hasn't constructed properly.");
        }
        Map<Integer, WrapperBuilder> ctors = apiCtors.get(apiname);
        if (ctors == null) {
            throw new APIUndefined(apiname);
        }
        if (!ctors.containsKey(version)) {
            throw new APIVersionUndefined(apiname + "-" + version);
        }
        WrapperBuilder ctor = ctors.get(version);
        if (ctor == null) {
            throw new APIVersionRemoved(apiname + "-" + version);
        }
        try {
            return ctor.newInstance(owner);
        }
        catch (Exception e) {
            LoggerUtils.error("Caught an exception while building an API wrapper. Go kick XCompWiz.", new Object[0]);
            throw new RuntimeException("Caught an exception while building an API wrapper. Go kick XCompWiz.", e);
        }
    }

    @Override
    public Map<String, Set<Integer>> getAvailableAPIs() {
        return apiVersions_immutable;
    }
}

