/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.tileentity;

import appeng.api.movable.IMovableTile;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.util.AECableType;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import li.cil.oc.api.Network;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.api.ProjectRedAPI;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.dave.CompactMachines.CompactMachines;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.handler.SharedStorageHandler;
import org.dave.CompactMachines.init.ModBlocks;
import org.dave.CompactMachines.integration.AbstractHoppingStorage;
import org.dave.CompactMachines.integration.AbstractSharedStorage;
import org.dave.CompactMachines.integration.appeng.AESharedStorage;
import org.dave.CompactMachines.integration.appeng.CMGridBlock;
import org.dave.CompactMachines.integration.botania.BotaniaSharedStorage;
import org.dave.CompactMachines.integration.bundledredstone.BRSharedStorage;
import org.dave.CompactMachines.integration.fluid.FluidSharedStorage;
import org.dave.CompactMachines.integration.gas.GasSharedStorage;
import org.dave.CompactMachines.integration.item.ItemSharedStorage;
import org.dave.CompactMachines.integration.opencomputers.OpenComputersSharedStorage;
import org.dave.CompactMachines.integration.pneumaticcraft.PneumaticCraftSharedStorage;
import org.dave.CompactMachines.integration.redstoneflux.FluxSharedStorage;
import org.dave.CompactMachines.integration.thaumcraft.ThaumcraftSharedStorage;
import org.dave.CompactMachines.machines.tools.ChunkLoadingTools;
import org.dave.CompactMachines.machines.tools.CubeTools;
import org.dave.CompactMachines.reference.Reference;
import org.dave.CompactMachines.tileentity.TileEntityCM;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.api.tileentity.IManoMeasurable;
import pneumaticCraft.api.tileentity.ISidedPneumaticMachine;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaTransport;
import vazkii.botania.api.mana.IManaPool;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.movable.IMovableTile", modid="appliedenergistics2"), @Optional.Interface(iface="mrtjp.projectred.api.IBundledTile", modid="ProjRed|Transmission"), @Optional.Interface(iface="li.cil.oc.api.network.SidedEnvironment", modid="OpenComputers"), @Optional.Interface(iface="mekanism.api.gas.IGasHandler", modid="Mekanism"), @Optional.Interface(iface="mekanism.api.gas.ITubeConnection", modid="Mekanism"), @Optional.Interface(iface="vazkii.botania.api.mana.IManaPool", modid="Botania"), @Optional.Interface(iface="thaumcraft.api.aspects.IEssentiaTransport", modid="Thaumcraft"), @Optional.Interface(iface="pneumaticCraft.api.tileentity.ISidedPneumaticMachine", modid="PneumaticCraft"), @Optional.Interface(iface="pneumaticCraft.api.tileentity.IManoMeasurable", modid="PneumaticCraft")})
public class TileEntityMachine
extends TileEntityCM
implements ISidedInventory,
IFluidHandler,
IGasHandler,
ITubeConnection,
IEnergyHandler,
IGridHost,
IMovableTile,
IBundledTile,
SidedEnvironment,
IManaPool,
IEssentiaTransport,
ISidedPneumaticMachine,
IManoMeasurable {
    public int coords = -1;
    public int[] _fluidid = new int[6];
    public int[] _fluidamount = new int[6];
    public int[] _gasid = new int[]{-1, -1, -1, -1, -1, -1};
    public int[] _gasamount = new int[6];
    public int[] _energy = new int[6];
    public int[] _aspectid = new int[]{-1, -1, -1, -1, -1, -1};
    public int[] _aspectamount = new int[6];
    public int _mana = 0;
    public int meta = 0;
    public int entangledInstance;
    public boolean isUpgraded = false;
    public HashMap<Integer, CMGridBlock> gridBlocks = new HashMap();
    public HashMap<Integer, IGridNode> gridNodes = new HashMap();
    private boolean init;
    private Object[] airHandlers = new Object[6];
    public static final int INVENTORY_SIZE = 6;

    public int[] func_94128_d(int side) {
        return new int[]{side};
    }

    public ItemSharedStorage getStorage(int side) {
        return (ItemSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, side, "item");
    }

    public FluidSharedStorage getStorageFluid(int side) {
        return (FluidSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, side, "liquid");
    }

    public GasSharedStorage getStorageGas(int side) {
        return (GasSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, side, "gas");
    }

    public FluxSharedStorage getStorageFlux(int side) {
        return (FluxSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, side, "flux");
    }

    public AESharedStorage getStorageAE(int side) {
        return (AESharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, side, this.entangledInstance, "appeng");
    }

    public BRSharedStorage getStorageBR(int side) {
        return (BRSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, side, "bundledRedstone");
    }

    public OpenComputersSharedStorage getStorageOC(int side) {
        return (OpenComputersSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, side, "OpenComputers");
    }

    public BotaniaSharedStorage getStorageBotania(int side) {
        return (BotaniaSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, 0, "botania");
    }

    public ThaumcraftSharedStorage getStorageThaumcraft(int side) {
        return (ThaumcraftSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, side, "thaumcraft");
    }

    public PneumaticCraftSharedStorage getStoragePneumaticCraft(int side) {
        return (PneumaticCraftSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, side, "PneumaticCraft");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.coords = nbtTagCompound.func_74762_e("coords");
        this.meta = nbtTagCompound.func_74762_e("meta");
        this.isUpgraded = nbtTagCompound.func_74767_n("upgraded");
        this.entangledInstance = nbtTagCompound.func_74762_e("entangle-id");
        if (this.isUpgraded && this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    protected void readSyncNBT(NBTTagCompound tag) {
        if (Reference.PNEUMATICCRAFT_AVAILABLE && tag.func_74764_b("AirHandlers")) {
            NBTTagList handlers = tag.func_150295_c("AirHandlers", 9);
            for (int i = 0; i < handlers.func_74745_c(); ++i) {
                NBTTagCompound sideTag = handlers.func_150305_b(i);
                int side = sideTag.func_74762_e("dir");
                ((IAirHandler)this.airHandlers[side]).readFromNBTI(sideTag);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        if (!nbtTagCompound.func_74764_b("meta")) {
            nbtTagCompound.func_74768_a("meta", this.meta);
        }
        nbtTagCompound.func_74768_a("coords", this.coords);
        nbtTagCompound.func_74757_a("upgraded", this.isUpgraded);
        nbtTagCompound.func_74768_a("entangle-id", this.entangledInstance);
    }

    @Override
    protected void writeSyncNBT(NBTTagCompound tag) {
        if (Reference.PNEUMATICCRAFT_AVAILABLE) {
            NBTTagList tagList = new NBTTagList();
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (this.airHandlers[dir.ordinal()] == null) continue;
                NBTTagCompound sideTag = new NBTTagCompound();
                ((IAirHandler)this.airHandlers[dir.ordinal()]).writeToNBTI(sideTag);
                sideTag.func_74768_a("dir", dir.ordinal());
                tagList.func_74742_a((NBTBase)sideTag);
            }
            if (tagList.func_74745_c() > 0) {
                tag.func_74782_a("AirHandlers", (NBTBase)tagList);
            }
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (Reference.PNEUMATICCRAFT_AVAILABLE) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (this.getStoragePneumaticCraft(dir.ordinal()) == null) continue;
                this.airHandlers[dir.ordinal()] = this.getStoragePneumaticCraft(dir.ordinal()).createDummyAirHandler(this);
            }
        }
    }

    @SideOnly(value=Side.SERVER)
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (ConfigurationHandler.chunkLoadingMode == 2) {
            ChunkLoadingTools.disableMachine(this);
        }
        this.deinitialize();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.deinitialize();
    }

    public void deinitialize() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            PneumaticCraftSharedStorage storagePC;
            AESharedStorage storageAE;
            Node node;
            OpenComputersSharedStorage storageOC = this.getStorageOC(dir.ordinal());
            if (storageOC != null && (node = storageOC.getNode()) != null) {
                node.remove();
            }
            if ((storageAE = this.getStorageAE(dir.ordinal())) != null) {
                storageAE.destroyMachineNode(this.entangledInstance);
                CompactMachines.instance.entangleRegistry.removeMachineTile(this);
            }
            if ((storagePC = this.getStoragePneumaticCraft(dir.ordinal())) == null) continue;
            this.airHandlers = new Object[6];
            storagePC.removeAirHandler(this.entangledInstance);
        }
    }

    public void initialize() {
        if (Reference.PNEUMATICCRAFT_AVAILABLE) {
            this.onNeighborChange((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.entangledInstance = CompactMachines.instance.entangleRegistry.registerMachineTile(this);
        this.func_70296_d();
        if (ConfigurationHandler.chunkLoadingMode != 0 && !ChunkLoadingTools.isCoordChunkLoaded(this)) {
            ChunkLoadingTools.forceChunkLoad(this.coords);
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            AESharedStorage storageAE;
            Node node;
            OpenComputersSharedStorage storageOC = this.getStorageOC(dir.ordinal());
            if (storageOC != null && (node = storageOC.getNode()) != null && node.network() == null) {
                Network.joinOrCreateNetwork((TileEntity)this);
            }
            if ((storageAE = this.getStorageAE(dir.ordinal())) == null) continue;
            this.getGridNode(dir);
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.init && !this.func_145837_r() && this.coords != -1) {
            this.initialize();
            this.init = true;
        }
        if (Reference.PR_AVAILABLE) {
            this.updateIncomingSignals();
        }
        if (Reference.PNEUMATICCRAFT_AVAILABLE) {
            this.updateDummyAirHandlers();
        }
        if (!this.field_145850_b.field_72995_K) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity outside = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                for (AbstractSharedStorage storage : SharedStorageHandler.instance(false).getAllStorages(this.coords, dir.ordinal())) {
                    if (!(storage instanceof AbstractHoppingStorage)) continue;
                    this.hopStorage(storage, outside);
                }
            }
        }
    }

    public ChunkCoordinates getChunkCoordinates() {
        int x = this.coords * ConfigurationHandler.cubeDistance;
        int y = 39;
        int z = 0;
        int size = Reference.getBoxSize(this.meta) / 2;
        return new ChunkCoordinates(x + size, y + size, z + size);
    }

    private void hopStorage(AbstractSharedStorage storage, TileEntity outside) {
        if (storage == null || !(storage instanceof AbstractHoppingStorage)) {
            return;
        }
        AbstractHoppingStorage hoppingStorage = (AbstractHoppingStorage)storage;
        if (hoppingStorage.getHoppingMode() == 4 || hoppingStorage.getHoppingMode() == 2 || hoppingStorage.getHoppingMode() == 3 && !hoppingStorage.isAutoHoppingToInside()) {
            hoppingStorage.hoppingTick(outside, true);
        }
    }

    private void updateDummyAirHandlers() {
        if (Reference.PNEUMATICCRAFT_AVAILABLE) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (this.airHandlers[dir.ordinal()] == null) continue;
                ((IAirHandler)this.airHandlers[dir.ordinal()]).updateEntityI();
            }
        }
    }

    public int func_70302_i_() {
        return 6;
    }

    public ItemStack func_70301_a(int slotIndex) {
        if (this.coords == -1) {
            return null;
        }
        return this.getStorage(slotIndex).func_70301_a(0);
    }

    public ItemStack func_70298_a(int slotIndex, int decreaseAmount) {
        if (this.coords == -1) {
            return null;
        }
        return this.getStorage(slotIndex).func_70298_a(0, decreaseAmount);
    }

    public ItemStack func_70304_b(int slotIndex) {
        if (this.coords == -1) {
            return null;
        }
        return this.getStorage(slotIndex).func_70304_b(0);
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        if (this.coords == -1) {
            return;
        }
        ItemSharedStorage storage = this.getStorage(slotIndex);
        storage.setAutoHoppingToInside(true);
        storage.setDirty();
        storage.func_70299_a(0, itemStack);
    }

    public String func_145825_b() {
        return this.hasCustomName() ? this.getCustomName() : "container.cm:machine";
    }

    public boolean func_145818_k_() {
        return this.hasCustomName();
    }

    public int func_70297_j_() {
        if (this.coords == -1) {
            return 0;
        }
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return this.coords != -1;
    }

    public boolean func_102007_a(int slotIndex, ItemStack itemStack, int side) {
        return this.coords != -1;
    }

    public boolean func_102008_b(int slotIndex, ItemStack itemStack, int side) {
        return this.coords != -1;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.coords == -1) {
            return 0;
        }
        FluidSharedStorage fss = this.getStorageFluid(from.ordinal());
        if (doFill && resource.amount > 0) {
            fss.setAutoHoppingToInside(true);
            fss.setDirty();
        }
        return fss.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.getStorageFluid(from.ordinal()).drain(from, maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.getStorageFluid(from.ordinal()).drain(from, resource, doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (this.coords == -1) {
            return false;
        }
        return this.getStorageFluid(from.ordinal()).canDrain(from, fluid);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.coords == -1) {
            return false;
        }
        return this.getStorageFluid(from.ordinal()).canFill(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.getStorageFluid(from.ordinal()).getTankInfo(from);
    }

    public FluidStack getFluid(int side) {
        return this.getStorageFluid(side).getFluid();
    }

    public FluidStack getFluid(ForgeDirection from) {
        return this.getStorageFluid(from.ordinal()).getFluid();
    }

    @Optional.Method(modid="Mekanism")
    public int receiveGas(ForgeDirection from, GasStack stack) {
        if (this.coords == -1) {
            return 0;
        }
        if (!ConfigurationHandler.enableIntegrationMekanism) {
            return 0;
        }
        GasSharedStorage gss = this.getStorageGas(from.ordinal());
        gss.setAutoHoppingToInside(true);
        gss.setDirty();
        return gss.receiveGas(from, stack);
    }

    @Optional.Method(modid="Mekanism")
    public GasStack drawGas(ForgeDirection from, int amount) {
        return this.getStorageGas(from.ordinal()).drawGas(from, amount);
    }

    @Optional.Method(modid="Mekanism")
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        return this.receiveGas(side, stack);
    }

    @Optional.Method(modid="Mekanism")
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        return this.drawGas(side, amount);
    }

    @Optional.Method(modid="Mekanism")
    public boolean canReceiveGas(ForgeDirection from, Gas type) {
        return this.getStorageGas(from.ordinal()).canReceiveGas(from, type);
    }

    @Optional.Method(modid="Mekanism")
    public boolean canDrawGas(ForgeDirection from, Gas type) {
        return this.getStorageGas(from.ordinal()).canDrawGas(from, type);
    }

    @Optional.Method(modid="Mekanism")
    public boolean canTubeConnect(ForgeDirection side) {
        return ConfigurationHandler.enableIntegrationMekanism;
    }

    @Optional.Method(modid="Mekanism")
    public GasStack getGasContents(ForgeDirection from) {
        return this.getStorageGas(from.ordinal()).getGasContents();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.coords == -1) {
            return 0;
        }
        FluxSharedStorage fss = this.getStorageFlux(from.ordinal());
        if (!simulate && maxReceive > 0) {
            fss.setAutoHoppingToInside(true);
            fss.setDirty();
        }
        return fss.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.coords == -1) {
            return 0;
        }
        return this.getStorageFlux(from.ordinal()).extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.coords == -1) {
            return 0;
        }
        return this.getStorageFlux(from.ordinal()).getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.coords == -1) {
            return 0;
        }
        return this.getStorageFlux(from.ordinal()).getMaxEnergyStored();
    }

    public CMGridBlock getGridBlock(ForgeDirection dir) {
        CMGridBlock gridBlock = this.gridBlocks.get(dir.ordinal());
        if (gridBlock == null) {
            gridBlock = new CMGridBlock(this);
            this.gridBlocks.put(dir.ordinal(), gridBlock);
        }
        return gridBlock;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(ForgeDirection dir) {
        if (this.coords == -1) {
            return null;
        }
        if (this.field_145850_b.field_72995_K) {
            return null;
        }
        if (!ConfigurationHandler.enableIntegrationAE2) {
            return null;
        }
        IGridNode gridNode = this.gridNodes.get(dir.ordinal());
        if (gridNode == null) {
            gridNode = this.getStorageAE(dir.ordinal()).getMachineNode(this.getGridBlock(dir), this.entangledInstance);
            this.gridNodes.put(dir.ordinal(), gridNode);
        }
        return gridNode;
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.DENSE;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
    }

    public ItemStack getItemDrop() {
        ItemStack stack = new ItemStack((Block)ModBlocks.machine, 1, this.meta);
        if (this.isUpgraded) {
            if (stack.field_77990_d == null) {
                stack.field_77990_d = new NBTTagCompound();
            }
            stack.field_77990_d.func_74768_a("coords", this.coords);
        }
        if (this.hasCustomName()) {
            stack.func_151001_c(this.getCustomName());
        }
        return stack;
    }

    public void dropAsItem() {
        ItemStack stack = this.getItemDrop();
        EntityItem entityitem = new EntityItem(this.func_145831_w(), (double)this.field_145851_c, (double)((float)this.field_145848_d + 0.5f), (double)this.field_145849_e, stack);
        entityitem.lifespan = 1200;
        entityitem.field_145804_b = 10;
        float f3 = 0.05f;
        entityitem.field_70159_w = (float)this.field_145850_b.field_73012_v.nextGaussian() * f3;
        entityitem.field_70181_x = (float)this.field_145850_b.field_73012_v.nextGaussian() * f3 + 0.2f;
        entityitem.field_70179_y = (float)this.field_145850_b.field_73012_v.nextGaussian() * f3;
        this.func_145831_w().func_72838_d((Entity)entityitem);
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean prepareToMove() {
        return this.isUpgraded;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void doneMoving() {
    }

    @Optional.Method(modid="ProjRed|Transmission")
    private void updateIncomingSignals() {
        if (!ConfigurationHandler.enableIntegrationProjectRed) {
            return;
        }
        boolean needsNotify = false;
        boolean haveChanges = false;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            BRSharedStorage br = this.getStorageBR(dir.ordinal());
            if (br.machineNeedsNotify) {
                needsNotify = true;
                br.machineNeedsNotify = false;
            }
            byte[] previous = br.machineBundledSignal;
            byte[] current = ProjectRedAPI.transmissionAPI.getBundledInput(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, dir.ordinal());
            if (current != null) {
                for (int i = 0; i < current.length; ++i) {
                    if (previous[i] == current[i]) continue;
                    haveChanges = true;
                    previous[i] = current[i];
                }
            }
            br.setDirty();
        }
        if (haveChanges) {
            WorldServer machineWorld = MinecraftServer.func_71276_C().func_71218_a(ConfigurationHandler.dimensionId);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Vec3 pos = CubeTools.getInterfacePosition(this.coords, this.meta, dir);
                machineWorld.func_147444_c((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c, (Block)ModBlocks.interfaceblock);
            }
        }
        if (needsNotify || haveChanges) {
            this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
        }
    }

    @Optional.Method(modid="ProjRed|Transmission")
    public byte[] getBundledSignal(int dir) {
        if (!ConfigurationHandler.enableIntegrationProjectRed) {
            return null;
        }
        BRSharedStorage storage = this.getStorageBR(dir);
        byte[] current = storage.interfaceBundledSignal;
        if (current == null) {
            return null;
        }
        byte[] result = new byte[current.length];
        for (int i = 0; i < current.length; ++i) {
            int a = current[i] & 0xFF;
            int b = storage.interfaceOutputtedSignal[i] & 0xFF;
            int c = a;
            if (b > 0) continue;
            result[i] = (byte)c;
        }
        storage.machineOutputtedSignal = result;
        storage.setDirty();
        return result;
    }

    @Optional.Method(modid="ProjRed|Transmission")
    public boolean canConnectBundled(int side) {
        return ConfigurationHandler.enableIntegrationProjectRed;
    }

    @Optional.Method(modid="OpenComputers")
    public Node sidedNode(ForgeDirection side) {
        if (this.field_145850_b.field_72995_K) {
            return null;
        }
        if (!ConfigurationHandler.enableIntegrationOpenComputers) {
            return null;
        }
        return this.getStorageOC(side.ordinal()).getNode();
    }

    @Optional.Method(modid="OpenComputers")
    public boolean canConnect(ForgeDirection side) {
        return ConfigurationHandler.enableIntegrationOpenComputers;
    }

    @Optional.Method(modid="Botania")
    public boolean isFull() {
        if (this.coords == -1) {
            return true;
        }
        return this.getStorageBotania(0).isFull();
    }

    @Optional.Method(modid="Botania")
    public void recieveMana(int mana) {
        if (this.coords == -1) {
            return;
        }
        this.getStorageBotania(0).recieveMana(mana);
    }

    @Optional.Method(modid="Botania")
    public boolean canRecieveManaFromBursts() {
        if (this.coords == -1) {
            return false;
        }
        return this.getStorageBotania(0).canRecieveManaFromBursts();
    }

    @Optional.Method(modid="Botania")
    public int getCurrentMana() {
        if (this.coords == -1) {
            return 0;
        }
        return this.getStorageBotania(0).getCurrentMana();
    }

    @Optional.Method(modid="Botania")
    public boolean isOutputtingPower() {
        if (this.coords == -1) {
            return false;
        }
        return this.getStorageBotania(0).isOutputtingPower();
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean isConnectable(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft || this.coords == -1) {
            return false;
        }
        return this.getStorageThaumcraft(face.ordinal()).isConnectable(face);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean canInputFrom(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft || this.coords == -1) {
            return false;
        }
        return this.getStorageThaumcraft(face.ordinal()).canInputFrom(face);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean canOutputTo(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft || this.coords == -1) {
            return false;
        }
        return this.getStorageThaumcraft(face.ordinal()).canOutputTo(face);
    }

    @Optional.Method(modid="Thaumcraft")
    public void setSuction(Aspect aspect, int amount) {
    }

    @Optional.Method(modid="Thaumcraft")
    public Aspect getSuctionType(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft || this.coords == -1) {
            return null;
        }
        return this.getStorageThaumcraft(face.ordinal()).getSuctionType(face);
    }

    @Optional.Method(modid="Thaumcraft")
    public int getSuctionAmount(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft || this.coords == -1) {
            return 0;
        }
        return this.getStorageThaumcraft(face.ordinal()).getSuctionAmount(face);
    }

    @Optional.Method(modid="Thaumcraft")
    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft || this.coords == -1) {
            return 0;
        }
        return this.getStorageThaumcraft(face.ordinal()).takeEssentia(aspect, amount, face);
    }

    @Optional.Method(modid="Thaumcraft")
    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft || this.coords == -1) {
            return 0;
        }
        return this.getStorageThaumcraft(face.ordinal()).addEssentia(aspect, amount, face);
    }

    @Optional.Method(modid="Thaumcraft")
    public Aspect getEssentiaType(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft || this.coords == -1) {
            return null;
        }
        return this.getStorageThaumcraft(face.ordinal()).getEssentiaType(face);
    }

    @Optional.Method(modid="Thaumcraft")
    public int getEssentiaAmount(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft || this.coords == -1) {
            return 0;
        }
        return this.getStorageThaumcraft(face.ordinal()).getEssentiaAmount(face);
    }

    @Optional.Method(modid="Thaumcraft")
    public int getMinimumSuction() {
        if (!ConfigurationHandler.enableIntegrationThaumcraft || this.coords == -1) {
            return Integer.MAX_VALUE;
        }
        return this.getStorageThaumcraft(0).getMinimumSuction();
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean renderExtendedTube() {
        if (!ConfigurationHandler.enableIntegrationThaumcraft || this.coords == -1) {
            return false;
        }
        return this.getStorageThaumcraft(0).renderExtendedTube();
    }

    @Optional.Method(modid="PneumaticCraft")
    public IAirHandler getAirHandler(ForgeDirection side) {
        if (!ConfigurationHandler.enableIntegrationPneumaticCraft) {
            return null;
        }
        return (IAirHandler)this.airHandlers[side.ordinal()];
    }

    @Optional.Method(modid="PneumaticCraft")
    public void printManometerMessage(EntityPlayer player, List<String> curInfo) {
        if (!ConfigurationHandler.enableIntegrationPneumaticCraft) {
            return;
        }
        if (Reference.PNEUMATICCRAFT_AVAILABLE && this.coords != -1) {
            curInfo.add(EnumChatFormatting.GREEN + "Pressures:");
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (this.getStoragePneumaticCraft(dir.ordinal()) == null) continue;
                curInfo.add(EnumChatFormatting.GREEN + "Current pressure (" + dir.name() + "): " + TileEntityMachine.roundNumberTo(this.getStoragePneumaticCraft(dir.ordinal()).getInterfaceAirHandler().getPressure(ForgeDirection.UNKNOWN), 1) + " bar.");
            }
        }
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        if (!ConfigurationHandler.enableIntegrationPneumaticCraft) {
            return;
        }
        if (Reference.PNEUMATICCRAFT_AVAILABLE) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (this.airHandlers[dir.ordinal()] != null) {
                    ((IAirHandler)this.airHandlers[dir.ordinal()]).onNeighborChange();
                }
                if (this.getStoragePneumaticCraft(dir.ordinal()) == null) continue;
                int targetX = this.field_145851_c + ForgeDirection.getOrientation((int)dir.ordinal()).offsetX;
                int targetY = this.field_145848_d + ForgeDirection.getOrientation((int)dir.ordinal()).offsetY;
                int targetZ = this.field_145849_e + ForgeDirection.getOrientation((int)dir.ordinal()).offsetZ;
                this.getStoragePneumaticCraft(dir.ordinal()).connectAirHandler(this.entangledInstance, this.field_145850_b.func_147438_o(targetX, targetY, targetZ));
            }
        }
    }

    private static String roundNumberTo(double value, int decimals) {
        double ret = TileEntityMachine.roundNumberToDouble(value, decimals);
        if (decimals == 0) {
            return "" + (int)ret;
        }
        return "" + ret;
    }

    private static double roundNumberToDouble(double value, int decimals) {
        return (double)Math.round(value * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals);
    }
}

