/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.machines;

import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.machines.tools.ChunkLoadingTools;
import org.dave.CompactMachines.machines.tools.CubeTools;
import org.dave.CompactMachines.reference.Reference;
import org.dave.CompactMachines.tileentity.TileEntityMachine;
import org.dave.CompactMachines.utility.PlayerUtils;

public class MachineSaveData
extends WorldSavedData {
    int nextCoord = 0;
    private World worldObj;
    HashMap<Integer, double[]> spawnPoints = new HashMap();
    HashMap<Integer, Integer> roomSizes = new HashMap();

    public MachineSaveData(String s) {
        super(s);
    }

    public MachineSaveData(World worldObj) {
        this("MachineHandler");
        this.worldObj = worldObj;
    }

    public void setCoordSpawnpoint(EntityPlayerMP player) {
        int roomSize;
        AxisAlignedBB bb;
        int lastCoord = PlayerUtils.getPlayerCoords((EntityPlayer)player);
        if (lastCoord > -1 && this.roomSizes.containsKey(lastCoord) && (bb = CubeTools.getBoundingBoxForCube(lastCoord, roomSize = Reference.getBoxSize(this.roomSizes.get(lastCoord)))).func_72318_a(Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v))) {
            this.spawnPoints.put(lastCoord, new double[]{player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A});
        }
        this.func_76185_a();
    }

    public double[] getSpawnLocation(int coord) {
        boolean usingPresetSpawnpoint = false;
        double[] destination = new double[]{(double)(coord * ConfigurationHandler.cubeDistance) + 1.5, 42.0, 1.5};
        if (this.spawnPoints.containsKey(coord)) {
            destination = this.spawnPoints.get(coord);
            usingPresetSpawnpoint = true;
        } else if (this.roomSizes.containsKey(coord)) {
            int size = Reference.getBoxSize(this.roomSizes.get(coord));
            destination = new double[]{(double)(coord * ConfigurationHandler.cubeDistance) + 0.5 + (double)(size / 2), 42.0, 0.5 + (double)(size / 2)};
        }
        return destination;
    }

    public int createOrGetChunk(TileEntityMachine machine) {
        if (machine.coords != -1) {
            return machine.coords;
        }
        machine.coords = this.nextCoord++;
        machine.func_70296_d();
        CubeTools.generateCube(machine);
        ChunkLoadingTools.forceChunkLoad(machine.coords);
        this.roomSizes.put(machine.coords, machine.meta);
        this.func_76185_a();
        return machine.coords;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int coords;
        NBTTagCompound tag;
        int i;
        NBTTagList tagList;
        this.nextCoord = nbt.func_74762_e("nextMachineCoord");
        if (nbt.func_74764_b("spawnpoints")) {
            this.spawnPoints.clear();
            tagList = nbt.func_150295_c("spawnpoints", 10);
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                tag = tagList.func_150305_b(i);
                coords = tag.func_74762_e("coords");
                double[] positions = new double[]{tag.func_74769_h("x"), tag.func_74769_h("y"), tag.func_74769_h("z"), tag.func_74769_h("yaw"), tag.func_74769_h("pitch")};
                this.spawnPoints.put(coords, positions);
            }
        }
        if (nbt.func_74764_b("roomsizes")) {
            this.roomSizes.clear();
            tagList = nbt.func_150295_c("roomsizes", 10);
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                tag = tagList.func_150305_b(i);
                coords = tag.func_74762_e("coords");
                int size = tag.func_74762_e("size");
                this.roomSizes.put(coords, size);
            }
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        nbt.func_74768_a("nextMachineCoord", this.nextCoord);
        NBTTagList sizeList = new NBTTagList();
        for (int coords : this.roomSizes.keySet()) {
            int size = this.roomSizes.get(coords);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("coords", coords);
            tag.func_74768_a("size", size);
            sizeList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("roomsizes", (NBTBase)sizeList);
        NBTTagList tagList = new NBTTagList();
        for (int coords : this.spawnPoints.keySet()) {
            double[] positions = this.spawnPoints.get(coords);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("coords", coords);
            tag.func_74780_a("x", positions[0]);
            tag.func_74780_a("y", positions[1]);
            tag.func_74780_a("z", positions[2]);
            if (positions.length == 5) {
                tag.func_74780_a("yaw", positions[3]);
                tag.func_74780_a("pitch", positions[4]);
            }
            tagList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("spawnpoints", (NBTBase)tagList);
    }

    public World getWorld() {
        return this.worldObj;
    }

    public void setWorld(World world) {
        this.worldObj = world;
    }

    public int getRoomSize(int coord) {
        return this.roomSizes.get(coord);
    }

    public boolean hasRoomSize(int coord) {
        return this.roomSizes.containsKey(coord);
    }
}

