/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.machines;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.World;
import org.dave.CompactMachines.tileentity.TileEntityMachine;
import org.dave.CompactMachines.utility.LogHelper;
import org.dave.CompactMachines.utility.WorldCoords;

public class EntangleRegistry {
    private HashMap<Integer, HashMap<Integer, WorldCoords>> reg = new HashMap();

    public EntangleRegistry() {
        LogHelper.info("Creating new Entangle Registry");
    }

    public void clear() {
        LogHelper.info("Clearing Entangle Registry");
        this.reg.clear();
    }

    public HashMap<Integer, WorldCoords> getMachinesForCoord(int coord) {
        return this.reg.get(coord);
    }

    public boolean hasRemainingMachines(int coord) {
        if (!this.reg.containsKey(coord)) {
            return false;
        }
        HashMap<Integer, WorldCoords> list = this.reg.get(coord);
        return list.size() > 0;
    }

    public void removeMachineTile(TileEntityMachine tileEntityMachine) {
        this.removeMachineTile(tileEntityMachine.coords, tileEntityMachine.func_145831_w(), tileEntityMachine.field_145851_c, tileEntityMachine.field_145848_d, tileEntityMachine.field_145849_e);
    }

    public void removeMachineTile(int coord, World world, int x, int y, int z) {
        if (!this.reg.containsKey(coord)) {
            return;
        }
        HashMap<Integer, WorldCoords> list = this.reg.get(coord);
        WorldCoords pos = new WorldCoords(world, x, y, z);
        boolean iHighest = false;
        for (Map.Entry<Integer, WorldCoords> pair : list.entrySet()) {
            if (!pos.equals(pair.getValue())) continue;
            list.remove(pair.getKey());
            return;
        }
    }

    public int registerMachineTile(int coord, World world, int x, int y, int z) {
        HashMap<Object, Object> list = !this.reg.containsKey(coord) ? new HashMap() : this.reg.get(coord);
        WorldCoords pos = new WorldCoords(world, x, y, z);
        int iHighest = -1;
        for (Map.Entry<Object, Object> pair : list.entrySet()) {
            if (pos.equals(pair.getValue())) {
                return (Integer)pair.getKey();
            }
            int pairKey = (Integer)pair.getKey();
            if (pairKey <= iHighest) continue;
            iHighest = (Integer)pair.getKey();
        }
        list.put(iHighest + 1, pos);
        this.reg.put(coord, list);
        return iHighest + 1;
    }

    public int registerMachineTile(TileEntityMachine tileEntityMachine) {
        return this.registerMachineTile(tileEntityMachine.coords, tileEntityMachine.func_145831_w(), tileEntityMachine.field_145851_c, tileEntityMachine.field_145848_d, tileEntityMachine.field_145849_e);
    }
}

