/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.integration.botania;

import cpw.mods.fml.common.Optional;
import net.minecraft.nbt.NBTTagCompound;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.handler.SharedStorageHandler;
import org.dave.CompactMachines.integration.AbstractBufferedStorage;
import vazkii.botania.api.mana.IManaPool;

@Optional.Interface(iface="vazkii.botania.api.mana.IManaPool", modid="Botania")
public class BotaniaSharedStorage
extends AbstractBufferedStorage
implements IManaPool {
    protected int mana = 0;

    public BotaniaSharedStorage(SharedStorageHandler storageHandler, int coord, int side) {
        super(storageHandler, coord, side);
        this.side = side;
        this.coord = coord;
    }

    @Override
    public NBTTagCompound saveToTag() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("mana", this.mana);
        return compound;
    }

    @Override
    public void loadFromTag(NBTTagCompound tag) {
        this.mana = tag.func_74762_e("mana");
    }

    @Override
    public String type() {
        return "botania";
    }

    public boolean isFull() {
        if (!ConfigurationHandler.enableIntegrationBotania) {
            return true;
        }
        return ConfigurationHandler.capacityMana <= this.mana;
    }

    public void recieveMana(int mana) {
        if (!ConfigurationHandler.enableIntegrationBotania) {
            return;
        }
        if (mana < 0 || this.mana < ConfigurationHandler.capacityMana) {
            this.mana += mana;
            this.setDirty();
        }
    }

    public boolean canRecieveManaFromBursts() {
        return ConfigurationHandler.enableIntegrationBotania;
    }

    public int getCurrentMana() {
        if (!ConfigurationHandler.enableIntegrationBotania) {
            return 0;
        }
        return this.mana;
    }

    public boolean isOutputtingPower() {
        if (!ConfigurationHandler.enableIntegrationBotania) {
            return false;
        }
        return false;
    }
}

