/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.handler;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import org.dave.CompactMachines.integration.AbstractBufferedStorage;
import org.dave.CompactMachines.integration.AbstractHoppingStorage;
import org.dave.CompactMachines.integration.AbstractSharedStorage;
import org.dave.CompactMachines.integration.appeng.AESharedStorage;
import org.dave.CompactMachines.integration.botania.BotaniaSharedStorage;
import org.dave.CompactMachines.integration.bundledredstone.BRSharedStorage;
import org.dave.CompactMachines.integration.fluid.FluidSharedStorage;
import org.dave.CompactMachines.integration.gas.GasSharedStorage;
import org.dave.CompactMachines.integration.item.ItemSharedStorage;
import org.dave.CompactMachines.integration.opencomputers.OpenComputersSharedStorage;
import org.dave.CompactMachines.integration.pneumaticcraft.PneumaticCraftSharedStorage;
import org.dave.CompactMachines.integration.redstoneflux.FluxSharedStorage;
import org.dave.CompactMachines.integration.thaumcraft.ThaumcraftSharedStorage;
import org.dave.CompactMachines.reference.Reference;
import org.dave.CompactMachines.utility.LogHelper;

public class SharedStorageHandler {
    private static SharedStorageHandler serverStorageHandler;
    private static SharedStorageHandler clientStorageHandler;
    private Map<String, AbstractSharedStorage> storageMap;
    private Map<String, List<AbstractSharedStorage>> storageList;
    private Map<String, Class> classMap;
    public final boolean client;
    private File saveDir;
    private File[] saveFiles;
    private int saveTo;
    private List<AbstractSharedStorage> dirtyStorage;
    private NBTTagCompound saveTag;

    public static SharedStorageHandler instance(boolean client) {
        return client ? clientStorageHandler : serverStorageHandler;
    }

    public SharedStorageHandler(boolean client) {
        this.client = client;
        this.storageMap = Collections.synchronizedMap(new HashMap());
        this.storageList = Collections.synchronizedMap(new HashMap());
        this.dirtyStorage = Collections.synchronizedList(new LinkedList());
        this.classMap = Collections.synchronizedMap(new HashMap());
        this.registerModInteraction("item", ItemSharedStorage.class);
        this.registerModInteraction("liquid", FluidSharedStorage.class);
        this.registerModInteraction("flux", FluxSharedStorage.class);
        if (Reference.MEK_AVAILABLE) {
            this.registerModInteraction("gas", GasSharedStorage.class);
        }
        if (Reference.AE_AVAILABLE) {
            this.registerModInteraction("appeng", AESharedStorage.class);
        }
        if (Reference.PR_AVAILABLE) {
            this.registerModInteraction("bundledRedstone", BRSharedStorage.class);
        }
        if (Reference.OC_AVAILABLE) {
            this.registerModInteraction("OpenComputers", OpenComputersSharedStorage.class);
        }
        if (Reference.BOTANIA_AVAILABLE) {
            this.registerModInteraction("botania", BotaniaSharedStorage.class);
        }
        if (Reference.THAUMCRAFT_AVAILABLE) {
            this.registerModInteraction("thaumcraft", ThaumcraftSharedStorage.class);
        }
        if (Reference.PNEUMATICCRAFT_AVAILABLE) {
            this.registerModInteraction("PneumaticCraft", PneumaticCraftSharedStorage.class);
        }
        if (!client) {
            this.load();
        }
    }

    public void registerModInteraction(String key, Class integrationClass) {
        if (this.storageList.containsKey(key)) {
            LogHelper.error("Double registration of abstract storage: " + integrationClass);
            return;
        }
        this.storageList.put(key, new ArrayList());
        this.classMap.put(key, integrationClass);
    }

    public void requestSave(AbstractSharedStorage storage) {
        this.dirtyStorage.add(storage);
    }

    public static void reloadStorageHandler(boolean client) {
        SharedStorageHandler newHandler = new SharedStorageHandler(client);
        if (client) {
            clientStorageHandler = newHandler;
        } else {
            serverStorageHandler = newHandler;
        }
    }

    public void setHoppingMode(int coord, int side, String type, int hoppingMode) {
        AbstractSharedStorage storage = this.getStorage(coord, side, type);
        if (storage instanceof AbstractHoppingStorage) {
            ((AbstractHoppingStorage)storage).setHoppingMode(hoppingMode);
            ((AbstractHoppingStorage)storage).setDirty();
        }
    }

    public void setHoppingModeForAll(int coord, int side, int hoppingMode) {
        for (String key : this.storageList.keySet()) {
            this.setHoppingMode(coord, side, key, hoppingMode);
        }
    }

    public boolean storageExists(int coord, int side, int entangledInstance, String type) {
        String key = coord + "|" + side + "|" + type;
        return this.storageMap.containsKey(key);
    }

    public List<AbstractSharedStorage> getAllStorages(int coord, int side) {
        ArrayList result = Lists.newArrayList();
        for (String key : this.storageList.keySet()) {
            result.add(this.getStorage(coord, side, key));
        }
        return result;
    }

    public AbstractSharedStorage getStorage(int coord, int side, String type) {
        return this.getStorage(coord, side, 0, type);
    }

    public AbstractSharedStorage getStorage(int coord, int side, int entangledInstance, String type) {
        String key = coord + "|" + side + "|" + type;
        AbstractSharedStorage storage = this.storageMap.get(key);
        if (storage == null) {
            Class storageClass = this.classMap.get(type);
            if (storageClass == null) {
                return null;
            }
            try {
                Constructor constructor = storageClass.getConstructor(SharedStorageHandler.class, Integer.TYPE, Integer.TYPE);
                storage = (AbstractSharedStorage)constructor.newInstance(this, coord, side);
            }
            catch (Exception e) {
                LogHelper.error("Could not create instance of class: " + storageClass);
                e.printStackTrace();
                return null;
            }
            if (!this.client && this.saveTag.func_74764_b(key) && storage instanceof AbstractBufferedStorage) {
                ((AbstractBufferedStorage)storage).loadFromTag(this.saveTag.func_74775_l(key));
            }
            this.storageMap.put(key, storage);
            this.storageList.get(type).add(storage);
        }
        return storage;
    }

    private void load() {
        this.saveDir = new File(DimensionManager.getCurrentSaveRootDirectory(), "CompactMachines");
        try {
            if (!this.saveDir.exists()) {
                this.saveDir.mkdirs();
            }
            this.saveFiles = new File[]{new File(this.saveDir, "data1.dat"), new File(this.saveDir, "data2.dat"), new File(this.saveDir, "lock.dat")};
            if (this.saveFiles[2].exists() && this.saveFiles[2].length() > 0L) {
                FileInputStream fin = new FileInputStream(this.saveFiles[2]);
                this.saveTo = fin.read() ^ 1;
                fin.close();
                if (this.saveFiles[this.saveTo ^ 1].exists()) {
                    DataInputStream din = new DataInputStream(new FileInputStream(this.saveFiles[this.saveTo ^ 1]));
                    this.saveTag = CompressedStreamTools.func_74796_a((InputStream)din);
                    din.close();
                } else {
                    this.saveTag = new NBTTagCompound();
                }
            } else {
                this.saveTag = new NBTTagCompound();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void save(boolean force) {
        if (!this.dirtyStorage.isEmpty() || force) {
            for (AbstractSharedStorage inv : this.dirtyStorage) {
                String key = inv.coord + "|" + inv.side + "|" + inv.type();
                this.saveTag.func_74782_a(key, (NBTBase)((AbstractBufferedStorage)inv).saveToTag());
                ((AbstractBufferedStorage)inv).setClean();
            }
            this.dirtyStorage.clear();
            try {
                File saveFile = this.saveFiles[this.saveTo];
                if (!saveFile.exists()) {
                    saveFile.createNewFile();
                }
                DataOutputStream dout = new DataOutputStream(new FileOutputStream(saveFile));
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.saveTag, (OutputStream)dout);
                dout.close();
                FileOutputStream fout = new FileOutputStream(this.saveFiles[2]);
                fout.write(this.saveTo);
                fout.close();
                this.saveTo ^= 1;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class SharedStorageSaveHandler {
        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            if (event.world.field_72995_K) {
                SharedStorageHandler.reloadStorageHandler(true);
            }
        }

        @SubscribeEvent
        public void onWorldSave(WorldEvent.Save event) {
            if (!event.world.field_72995_K && SharedStorageHandler.instance(false) != null) {
                SharedStorageHandler.instance(false).save(false);
            }
        }
    }
}

