/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import org.dave.CompactMachines.CompactMachines;
import org.dave.CompactMachines.block.BlockCM;
import org.dave.CompactMachines.creativetab.CreativeTabCM;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.init.ModItems;
import org.dave.CompactMachines.item.ItemPersonalShrinkingDevice;
import org.dave.CompactMachines.machines.tools.ChunkLoadingTools;
import org.dave.CompactMachines.machines.tools.CubeTools;
import org.dave.CompactMachines.machines.tools.TeleportTools;
import org.dave.CompactMachines.reference.GuiId;
import org.dave.CompactMachines.reference.Reference;
import org.dave.CompactMachines.tileentity.TileEntityMachine;
import org.dave.CompactMachines.utility.FluidUtils;
import org.dave.CompactMachines.utility.WorldUtils;

public class BlockMachine
extends BlockCM
implements ITileEntityProvider {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private IIcon[] iconsUpg;

    public BlockMachine() {
        this.func_149663_c("machine");
        this.func_149658_d("machine");
        this.func_149711_c(4.0f);
        this.func_149752_b(6000000.0f);
        this.func_149647_a(CreativeTabCM.CM_TAB);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[6];
        this.iconsUpg = new IIcon[6];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("compactmachines:machine_" + i);
            this.iconsUpg[i] = iconRegister.func_94245_a("compactmachines:machine_" + i + "_upg");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.icons[metadata];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityMachine tileEntityMachine = (TileEntityMachine)blockAccess.func_147438_o(x, y, z);
        if (tileEntityMachine == null) {
            return this.icons[0];
        }
        if (tileEntityMachine.isUpgraded) {
            return this.iconsUpg[tileEntityMachine.meta];
        }
        return this.icons[tileEntityMachine.meta];
    }

    public TileEntity func_149915_a(World world, int metaData) {
        TileEntityMachine tileEntityMachine = new TileEntityMachine();
        tileEntityMachine.meta = metaData;
        return tileEntityMachine;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        super.func_149689_a(world, x, y, z, player, stack);
        if (stack.field_77990_d == null) {
            return;
        }
        if (!(world.func_147438_o(x, y, z) instanceof TileEntityMachine)) {
            return;
        }
        TileEntityMachine tileEntityMachine = (TileEntityMachine)world.func_147438_o(x, y, z);
        if (tileEntityMachine.coords != -1) {
            return;
        }
        if (stack.field_77990_d.func_74764_b("coords")) {
            int coords = stack.field_77990_d.func_74762_e("coords");
            if (coords != -1) {
                tileEntityMachine.coords = coords;
                tileEntityMachine.isUpgraded = true;
            }
            if (!world.field_72995_K && ConfigurationHandler.adaptBiomes) {
                CubeTools.setCubeBiome(coords, CubeTools.getMachineBiome(tileEntityMachine));
            }
        }
        if (stack.func_82837_s()) {
            tileEntityMachine.setCustomName(stack.func_82833_r());
        }
        tileEntityMachine.func_70296_d();
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item unknown, CreativeTabs tab, List subItems) {
        for (int i = 0; i < 6; ++i) {
            subItems.add(new ItemStack((Block)this, 1, i));
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest && world.func_147438_o(x, y, z) instanceof TileEntityMachine) {
            TileEntityMachine tileEntityMachine = (TileEntityMachine)world.func_147438_o(x, y, z);
            boolean result = super.removedByPlayer(world, player, x, y, z, willHarvest);
            if (result) {
                if (!tileEntityMachine.isUpgraded) {
                    CubeTools.harvestMachine(tileEntityMachine, player);
                }
                tileEntityMachine.dropAsItem();
            }
            return result;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityMachine) {
            TileEntityMachine tileEntityMachine = (TileEntityMachine)world.func_147438_o(x, y, z);
            if (!CompactMachines.instance.entangleRegistry.hasRemainingMachines(tileEntityMachine.coords)) {
                ChunkLoadingTools.disableMachine(tileEntityMachine);
            }
            world.func_147475_p(x, y, z);
        }
        WorldUtils.updateNeighborAEGrids(world, x, y, z);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int faceHit, float par7, float par8, float par9) {
        if (player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K && player instanceof EntityPlayerMP) {
            if (!(world.func_147438_o(x, y, z) instanceof TileEntityMachine)) {
                return false;
            }
            TileEntityMachine tileEntityMachine = (TileEntityMachine)world.func_147438_o(x, y, z);
            ItemStack playerStack = player.func_71045_bC();
            NBTTagCompound stackNBT = null;
            NBTTagCompound cmNBT = null;
            if (playerStack != null) {
                if (playerStack.func_77942_o() && (stackNBT = playerStack.func_77978_p()).func_74764_b("CompactMachines")) {
                    cmNBT = stackNBT.func_74775_l("CompactMachines");
                }
                if (playerStack.func_77973_b() instanceof ItemPersonalShrinkingDevice || cmNBT != null && cmNBT.func_74764_b("canShrink") && cmNBT.func_74767_n("canShrink")) {
                    if (!ConfigurationHandler.allowEnterWithoutPSD) {
                        player.getEntityData().func_74757_a("isUsingPSD", true);
                    }
                    TeleportTools.teleportPlayerToMachineWorld((EntityPlayerMP)player, tileEntityMachine);
                } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)playerStack)) {
                    FluidUtils.emptyTankIntoContainer(tileEntityMachine, player, tileEntityMachine.getFluid(faceHit), ForgeDirection.getOrientation((int)faceHit));
                } else if (FluidContainerRegistry.isFilledContainer((ItemStack)playerStack)) {
                    FluidUtils.fillTankWithContainer(tileEntityMachine, player, ForgeDirection.getOrientation((int)faceHit));
                } else if (!tileEntityMachine.isUpgraded && playerStack.func_77973_b() == Reference.upgradeItem) {
                    tileEntityMachine.isUpgraded = true;
                    tileEntityMachine.func_70296_d();
                    world.func_147471_g(x, y, z);
                    --playerStack.field_77994_a;
                } else if (playerStack.func_77973_b() == ModItems.quantumentangler) {
                    if (!ConfigurationHandler.allowEntanglement) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.message_quantum_entanglement_disabled.txt", new Object[0]));
                        return true;
                    }
                    if (stackNBT != null && stackNBT.func_74764_b("coords") && stackNBT.func_74764_b("size")) {
                        if (tileEntityMachine.coords != -1) {
                            player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.message_machine_already_in_use.txt", new Object[0]));
                        } else if (!tileEntityMachine.isUpgraded) {
                            player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.message_machine_not_upgraded.txt", new Object[0]));
                        } else {
                            int size = stackNBT.func_74762_e("size");
                            if (size != tileEntityMachine.meta) {
                                player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.message_machine_invalid_size.txt", new Object[0]));
                            } else {
                                int coords;
                                tileEntityMachine.coords = coords = stackNBT.func_74762_e("coords");
                                if (stackNBT.func_74764_b("roomname")) {
                                    tileEntityMachine.setCustomName(stackNBT.func_74779_i("roomname"));
                                }
                                tileEntityMachine.initialize();
                                tileEntityMachine.func_70296_d();
                                WorldUtils.updateNeighborAEGrids(world, x, y, z);
                                --playerStack.field_77994_a;
                            }
                        }
                    } else if (tileEntityMachine.isUpgraded && tileEntityMachine.coords != -1) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        nbt.func_74768_a("coords", tileEntityMachine.coords);
                        nbt.func_74768_a("size", tileEntityMachine.meta);
                        nbt.func_74778_a("roomname", tileEntityMachine.getCustomName());
                        playerStack.func_77982_d(nbt);
                    } else if (tileEntityMachine.coords == -1) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.message_machine_not_in_use.txt", new Object[0]));
                    } else if (!tileEntityMachine.isUpgraded) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.message_machine_not_upgraded.txt", new Object[0]));
                    }
                } else {
                    player.openGui((Object)CompactMachines.instance, GuiId.MACHINE.ordinal(), world, x, y, z);
                }
            } else {
                player.openGui((Object)CompactMachines.instance, GuiId.MACHINE.ordinal(), world, x, y, z);
            }
        }
        return true;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        super.onNeighborChange(world, x, y, z, tileX, tileY, tileZ);
        if (!(world.func_147438_o(x, y, z) instanceof TileEntityMachine)) {
            return;
        }
        ((TileEntityMachine)world.func_147438_o(x, y, z)).onNeighborChange(world, x, y, z, tileX, tileY, tileZ);
    }
}

