/*
 * Decompiled with CFR 0.152.
 */
package sync.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import ichun.client.keybind.KeyBind;
import ichun.common.core.config.Config;
import ichun.common.core.config.ConfigHandler;
import ichun.common.core.config.IConfigUser;
import ichun.common.core.updateChecker.ModVersionChecker;
import ichun.common.core.updateChecker.ModVersionInfo;
import ichun.common.iChunUtil;
import java.io.File;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sync.common.core.ChunkLoadHandler;
import sync.common.core.CommandSync;
import sync.common.core.CommonProxy;
import sync.common.core.EventHandler;
import sync.common.shell.ShellHandler;

@Mod(modid="Sync", name="Sync", version="4.0.0", dependencies="required-after:iChunUtil@[4.0.0,);after:CoFHCore;after:Waila", acceptableRemoteVersions="[4.0.0,4.1.0)")
public class Sync
implements IConfigUser {
    public static final String version = "4.0.0";
    @Mod.Instance(value="Sync")
    public static Sync instance;
    @SidedProxy(clientSide="sync.client.core.ClientProxy", serverSide="sync.common.core.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static EnumMap<Side, FMLEmbeddedChannel> channels;
    public static CreativeTabs creativeTabSync;
    public static Config config;
    public static Block blockDualVertical;
    public static Item itemBlockPlacer;
    public static Item itemPlaceholder;
    public static boolean hasMorphMod;
    public static boolean hasCoFHCore;
    public static final HashMap<Class, Integer> treadmillEntityHashMap;

    public boolean onConfigChange(Config cfg, Property prop) {
        return true;
    }

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        config = ConfigHandler.createConfig((File)event.getSuggestedConfigurationFile(), (String)"sync", (String)"Sync", (Logger)logger, (IConfigUser)instance);
        config.setCurrentCategory("gameplay", "sync.config.cat.gameplay.name", "sync.config.cat.gameplay.comment");
        config.createIntProperty("shellConstructionPowerRequirement", "sync.config.prop.shellConstructionPowerRequirement.name", "sync.config.prop.shellConstructionPowerRequirement.comment", true, true, 48000, 0, Integer.MAX_VALUE);
        config.createIntProperty("shellStoragePowerRequirement", "sync.config.prop.shellStoragePowerRequirement.name", "sync.config.prop.shellStoragePowerRequirement.comment", true, false, 0, 0, Integer.MAX_VALUE);
        config.createIntProperty("allowCrossDimensional", "sync.config.prop.allowCrossDimensional.name", "sync.config.prop.allowCrossDimensional.comment", true, true, 1, 0, 2);
        config.createIntProperty("damageGivenOnShellConstruction", "sync.config.prop.damageGivenOnShellConstruction.name", "sync.config.prop.damageGivenOnShellConstruction.comment", true, false, 2, 0, Integer.MAX_VALUE);
        config.createIntProperty("overrideDeathIfThereAreAvailableShells", "sync.config.prop.overrideDeathIfThereAreAvailableShells.name", "sync.config.prop.overrideDeathIfThereAreAvailableShells.comment", true, true, 1, 0, 2);
        config.createIntBoolProperty("prioritizeHomeShellOnDeath", "sync.config.prop.prioritizeHomeShellOnDeath.name", "sync.config.prop.prioritizeHomeShellOnDeath.comment", true, false, true);
        config.createIntBoolProperty("crossDimensionalSyncingOnDeath", "sync.config.prop.crossDimensionalSyncingOnDeath.name", "sync.config.prop.crossDimensionalSyncingOnDeath.comment", true, false, true);
        config.createIntBoolProperty("allowChunkLoading", "sync.config.prop.allowChunkLoading.name", "sync.config.prop.allowChunkLoading.comment", true, false, true);
        config.createIntProperty("hardcoreMode", "sync.config.prop.hardcoreMode.name", "sync.config.prop.hardcoreMode.comment", true, true, 2, 0, 2);
        config.createIntProperty("ratioRF", "sync.config.prop.ratioRF.name", "sync.config.prop.ratioRF.comment", true, false, 2, 0, Integer.MAX_VALUE);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            iChunUtil.proxy.registerKeyBind(new KeyBind(-100, false, false, false, false), null);
            iChunUtil.proxy.registerKeyBind(new KeyBind(-99, false, false, false, false), null);
            config.setCurrentCategory("clientOnly", "sync.config.cat.clientOnly.name", "sync.config.cat.clientOnly.comment");
            config.createIntProperty("showAllShellInfoInGui", "sync.config.prop.showAllShellInfoInGui.name", "sync.config.prop.showAllShellInfoInGui.comment", true, false, 1, 0, 2);
        }
        EventHandler handler = new EventHandler();
        FMLCommonHandler.instance().bus().register((Object)handler);
        MinecraftForge.EVENT_BUS.register((Object)handler);
        proxy.initMod();
        ModVersionChecker.register_iChunMod((ModVersionInfo)new ModVersionInfo("Sync", "1.7.10", version, false));
        FMLInterModComms.sendMessage((String)"BackTools", (String)"blacklist", (ItemStack)new ItemStack(itemBlockPlacer, 1));
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.initTickHandlers();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ChunkLoadHandler());
        hasMorphMod = Loader.isModLoaded((String)"Morph");
        hasCoFHCore = Loader.isModLoaded((String)"CoFHCore");
        FMLInterModComms.sendMessage((String)"AppliedEnergistics", (String)"movabletile", (String)"sync.common.tileentity.TileEntityDualVertical");
        FMLInterModComms.sendMessage((String)"AppliedEnergistics", (String)"movabletile", (String)"sync.common.tileentity.TileEntityTreadmill");
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"sync.client.HUDHandlerSync.callbackRegister");
        treadmillEntityHashMap.put(EntityWolf.class, 4);
        treadmillEntityHashMap.put(EntityPig.class, 2);
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandSync());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        config.resetSession();
        config.updateSession("hardMode", (Object)(config.getSessionInt("hardcoreMode") == 1 || config.getSessionInt("hardcoreMode") == 2 && DimensionManager.getWorld((int)0).func_72912_H().func_76093_s() ? 1 : 0));
        Sync.mapHardmodeRecipe();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        ChunkLoadHandler.shellTickets.clear();
        ShellHandler.syncInProgress.clear();
        ShellHandler.playerShells.clear();
    }

    @Mod.EventHandler
    public void processIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.isStringMessage() || !message.key.equals("treadmill")) continue;
            String[] s = message.getStringValue().split(":");
            if (s.length != 2) {
                logger.log(Level.WARN, "Invalid IMC treadmill register (incorrect length) received from " + message.getSender());
                continue;
            }
            try {
                String entityClassName = s[0];
                int entityPower = Integer.valueOf(s[1]);
                Class<?> entityClass = Class.forName(entityClassName);
                if (EntityPlayer.class.isAssignableFrom(entityClass)) {
                    logger.log(Level.WARN, "Seriously? You're gonna try that?");
                    continue;
                }
                treadmillEntityHashMap.put(entityClass, entityPower);
                logger.info(String.format("Registered IMC treadmill register from %s for %s with power %s", message.getSender(), entityClassName, entityPower));
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARN, "Invalid IMC treadmill register (power not integer) received from " + message.getSender());
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.WARN, "Invalid IMC treadmill register (class not found) received from " + message.getSender());
            }
        }
    }

    public static void mapHardmodeRecipe() {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (int i = recipes.size() - 1; i >= 0; --i) {
            ShapedRecipes recipe;
            if (!(recipes.get(i) instanceof ShapedRecipes) || !(recipe = (ShapedRecipes)recipes.get(i)).func_77571_b().func_77969_a(new ItemStack(itemPlaceholder))) continue;
            recipes.remove(i);
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemPlaceholder), (Object[])new Object[]{"DLD", "QEQ", "MRM", Character.valueOf('D'), Blocks.field_150453_bW, Character.valueOf('L'), Blocks.field_150368_y, Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('E'), config.getSessionInt("hardMode") == 1 ? Blocks.field_150461_bJ : Items.field_151079_bi, Character.valueOf('M'), Items.field_151166_bC, Character.valueOf('R'), Blocks.field_150451_bX});
    }

    static {
        logger = LogManager.getLogger((String)"Sync");
        treadmillEntityHashMap = new HashMap();
    }
}

