/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.tileentities.abstraction;

import appeng.api.config.Actionable;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectSource;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.integration.tc.IEssentiaTransportWithSimulate;
import thaumicenergistics.util.EffectiveSide;

public abstract class TileEVCBase
extends AENetworkTile
implements IEssentiaTransportWithSimulate,
IAspectSource {
    public static final String NBTKEY_STORED = "StoredEssentia";
    public static final int MAX_ESSENTIA_STORED = 64;
    protected AspectStack storedEssentia = null;

    public static boolean acceptsAspect(Aspect aspect) {
        return aspect == Aspect.FIRE || aspect == Aspect.ENERGY;
    }

    protected abstract int addEssentia(Aspect var1, int var2, Actionable var3);

    protected ItemStack getItemFromTile(Object obj) {
        return ThEApi.instance().blocks().EssentiaVibrationChamber.getStack();
    }

    protected boolean hasStoredEssentia() {
        return this.storedEssentia != null && !this.storedEssentia.isEmpty();
    }

    protected abstract void NBTRead(NBTTagCompound var1);

    protected abstract void NBTWrite(NBTTagCompound var1);

    @SideOnly(value=Side.CLIENT)
    protected abstract void networkRead(ByteBuf var1);

    protected abstract void networkWrite(ByteBuf var1);

    public int addEssentia(Aspect aspect, int amount, ForgeDirection side) {
        return this.addEssentia(aspect, amount, Actionable.MODULATE);
    }

    @Override
    public int addEssentia(Aspect aspect, int amount, ForgeDirection side, Actionable mode) {
        return this.addEssentia(aspect, amount, mode);
    }

    public int addToContainer(Aspect aspect, int amount) {
        return this.addEssentia(aspect, amount, Actionable.MODULATE);
    }

    public boolean canInputFrom(ForgeDirection side) {
        return side != this.getForward();
    }

    public boolean canOutputTo(ForgeDirection side) {
        return false;
    }

    public int containerContains(Aspect aspect) {
        int storedAmount = 0;
        if (this.hasStoredEssentia() && this.storedEssentia.aspect == aspect) {
            storedAmount = (int)this.storedEssentia.stackSize;
        }
        return storedAmount;
    }

    public boolean doesContainerAccept(Aspect aspect) {
        if (this.hasStoredEssentia()) {
            return aspect == this.storedEssentia.aspect;
        }
        return TileEVCBase.acceptsAspect(aspect);
    }

    @Deprecated
    public boolean doesContainerContain(AspectList aspectList) {
        if (!this.hasStoredEssentia()) {
            return false;
        }
        return aspectList.aspects.containsKey(this.storedEssentia.aspect);
    }

    public boolean doesContainerContainAmount(Aspect aspect, int amount) {
        if (this.storedEssentia == null || this.storedEssentia.aspect != aspect) {
            return false;
        }
        return this.storedEssentia.stackSize >= (long)amount;
    }

    public AspectList getAspects() {
        AspectList aspectList = new AspectList();
        if (this.hasStoredEssentia()) {
            aspectList.add(this.storedEssentia.aspect, (int)this.storedEssentia.stackSize);
        }
        return aspectList;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    public int getEssentiaAmount(ForgeDirection side) {
        return this.hasStoredEssentia() ? (int)this.storedEssentia.stackSize : 0;
    }

    public Aspect getEssentiaType(ForgeDirection side) {
        return this.hasStoredEssentia() ? this.storedEssentia.aspect : null;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public int getMinimumSuction() {
        return 0;
    }

    public int getSuctionAmount(ForgeDirection side) {
        int suction = 0;
        if (this.storedEssentia != null) {
            if (this.storedEssentia.stackSize < 64L) {
                suction = 128;
            }
        } else {
            suction = 100;
        }
        return suction;
    }

    public Aspect getSuctionType(ForgeDirection side) {
        Aspect suction = Aspect.FIRE;
        if (this.hasStoredEssentia()) {
            suction = this.storedEssentia.aspect;
        } else if (MinecraftServer.func_71276_C().func_71259_af() % 200 > 100) {
            suction = Aspect.ENERGY;
        }
        return suction;
    }

    public boolean isConnectable(ForgeDirection side) {
        return side != this.getForward();
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public final void onNBTLoad(NBTTagCompound data) {
        if (data.func_74764_b(NBTKEY_STORED)) {
            this.storedEssentia = AspectStack.loadAspectStackFromNBT(data.func_74775_l(NBTKEY_STORED));
        }
        this.NBTRead(data);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public final void onNBTSave(NBTTagCompound data) {
        if (this.hasStoredEssentia()) {
            NBTTagCompound stack = new NBTTagCompound();
            this.storedEssentia.writeToNBT(stack);
            data.func_74782_a(NBTKEY_STORED, (NBTBase)stack);
        }
        this.NBTWrite(data);
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    @SideOnly(value=Side.CLIENT)
    public final boolean onNetworkRead(ByteBuf stream) {
        if (stream.readBoolean()) {
            if (this.storedEssentia == null) {
                this.storedEssentia = AspectStack.loadAspectStackFromStream(stream);
            } else {
                this.storedEssentia.readFromStream(stream);
            }
        } else {
            this.storedEssentia = null;
        }
        this.networkRead(stream);
        return true;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public final void onNetworkWrite(ByteBuf stream) throws IOException {
        boolean hasStored = this.storedEssentia != null;
        stream.writeBoolean(hasStored);
        if (hasStored) {
            this.storedEssentia.writeToStream(stream);
        }
        this.networkWrite(stream);
    }

    public void onReady() {
        super.onReady();
        if (EffectiveSide.isServerSide()) {
            this.getProxy().setIdlePowerUsage(0.0);
        }
    }

    public boolean renderExtendedTube() {
        return false;
    }

    public void setAspects(AspectList aspectList) {
    }

    public void setOwner(EntityPlayer player) {
        this.getProxy().setOwner(player);
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection side) {
        return 0;
    }

    public boolean takeFromContainer(Aspect aspect, int amount) {
        return false;
    }

    @Deprecated
    public boolean takeFromContainer(AspectList arg0) {
        return false;
    }
}

