/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.tileentities;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.me.GridAccessException;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.container.ContainerEssentiaVibrationChamber;
import thaumicenergistics.integration.IWailaSource;
import thaumicenergistics.integration.tc.EssentiaTransportHelper;
import thaumicenergistics.network.packet.ThEBasePacket;
import thaumicenergistics.registries.ThEStrings;
import thaumicenergistics.tileentities.abstraction.TileEVCBase;

public class TileEssentiaVibrationChamber
extends TileEVCBase
implements IGridTickable,
IWailaSource {
    private static String NBTKEY_TIME_REMAINING = "TRemain";
    private static String NBTKEY_PROCESSING_SPEED = "ProcSpeed";
    private static String NBTKEY_POWER_PER_TICK = "PwrPerTick";
    private static String NBTKEY_PROCESSING_ASPECT = "ProcAspect";
    private static final double BASE_POWER_PER_TICK = 5.0;
    private static final int TICKRATE_MIN = 10;
    private static final int TICKRATE_MAX = 40;
    private static final int PROCESS_SPEED_MAX = 200;
    private static final int PROCESS_SPEED_MIN = 20;
    private static final double DILATATION_DIVISOR = 100.0;
    private static int coalBurnTime = 0;
    private double dilation = 1.0;
    private int processingTicksRemaining = 0;
    private int processingSpeed = 0;
    private double powerProducedPerProcessingTick = 0.0;
    private Aspect processingAspect = null;
    private boolean processingChanged = false;
    private int sync_totalProcessingTicks = 0;
    private double sync_powerPerTick = 0.0;
    private final Set<ContainerEssentiaVibrationChamber> listeners = new HashSet<ContainerEssentiaVibrationChamber>();

    private int adjustProcessingValues() {
        int pTime = 0;
        if (coalBurnTime == 0) {
            coalBurnTime = TileEntityFurnace.func_145952_a((ItemStack)new ItemStack(Items.field_151044_h));
        }
        if (this.storedEssentia.aspect == Aspect.FIRE) {
            pTime = coalBurnTime / 2;
            this.powerProducedPerProcessingTick = 5.0;
        } else if (this.storedEssentia.aspect == Aspect.ENERGY) {
            pTime = (int)((float)coalBurnTime / 1.6f);
            this.powerProducedPerProcessingTick = 8.0;
        }
        this.sync_totalProcessingTicks = pTime;
        return pTime;
    }

    private void clampProcessingSpeed() {
        this.processingSpeed = Math.max(20, Math.min(200, this.processingSpeed));
    }

    private boolean consumeEssentia() {
        int pTime;
        if (this.hasStoredEssentia() && (pTime = this.adjustProcessingValues()) > 0) {
            this.processingAspect = this.storedEssentia.aspect;
            this.processingChanged = true;
            --this.storedEssentia.stackSize;
            this.func_70296_d();
            this.markForUpdate();
            this.processingTicksRemaining += pTime;
            return true;
        }
        return false;
    }

    private TickRateModulation doProcessingTick(int ticksSinceLastCall) {
        if (this.processingTicksRemaining == 0) {
            return TickRateModulation.IDLE;
        }
        this.clampProcessingSpeed();
        this.dilation = (double)this.processingSpeed / 100.0;
        double processingTicks = (double)ticksSinceLastCall * this.dilation;
        this.processingTicksRemaining = (int)((double)this.processingTicksRemaining - processingTicks);
        this.sync_powerPerTick = processingTicks * this.powerProducedPerProcessingTick / (double)ticksSinceLastCall;
        if (this.processingTicksRemaining <= 0) {
            processingTicks += (double)this.processingTicksRemaining;
            this.processingTicksRemaining = 0;
            this.processingAspect = null;
            this.processingChanged = true;
            this.markForUpdate();
            this.func_70296_d();
        }
        double producedPower = processingTicks * this.powerProducedPerProcessingTick;
        TickRateModulation rate = TickRateModulation.SLOWER;
        try {
            IEnergyGrid eGrid = this.getProxy().getEnergy();
            double rejectedPower = eGrid.injectPower(producedPower, Actionable.SIMULATE);
            if (rejectedPower > 0.0) {
                producedPower = Math.max(0.0, producedPower - rejectedPower);
                this.processingSpeed -= ticksSinceLastCall;
            } else {
                rate = TickRateModulation.FASTER;
                this.processingSpeed += ticksSinceLastCall;
            }
            if (producedPower > 0.0) {
                eGrid.injectPower(producedPower, Actionable.MODULATE);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return rate;
    }

    private void updateListeners() {
        if (this.listeners.isEmpty()) {
            return;
        }
        float powerPerTick = (float)this.sync_powerPerTick;
        float maxPowerPerTick = (float)(this.powerProducedPerProcessingTick * 2.0);
        this.clampProcessingSpeed();
        int ticksRemaining = (int)((double)this.processingTicksRemaining / this.dilation);
        int totalTicks = (int)((double)this.sync_totalProcessingTicks / this.dilation);
        for (ContainerEssentiaVibrationChamber listener : this.listeners) {
            listener.onChamberUpdate(powerPerTick, maxPowerPerTick, ticksRemaining, totalTicks);
        }
    }

    @Override
    protected int addEssentia(Aspect aspect, int amount, Actionable mode) {
        if (this.hasStoredEssentia() && this.storedEssentia.aspect != aspect) {
            return 0;
        }
        int storedAmount = this.storedEssentia == null ? 0 : (int)this.storedEssentia.stackSize;
        Aspect storedAspect = this.storedEssentia == null ? null : this.storedEssentia.aspect;
        int addedAmount = Math.min(amount, 64 - storedAmount);
        if (addedAmount > 0 && mode == Actionable.MODULATE) {
            if (storedAspect == null) {
                this.storedEssentia = new AspectStack(aspect, 0L);
            } else {
                this.storedEssentia.aspect = aspect;
            }
            this.storedEssentia.stackSize += (long)addedAmount;
            this.markForUpdate();
            this.func_70296_d();
        }
        return addedAmount;
    }

    @Override
    protected void NBTRead(NBTTagCompound data) {
        if (data.func_74764_b(NBTKEY_TIME_REMAINING)) {
            this.processingTicksRemaining = data.func_74762_e(NBTKEY_TIME_REMAINING);
        }
        if (this.processingTicksRemaining > 0) {
            if (data.func_74764_b(NBTKEY_PROCESSING_SPEED)) {
                this.processingSpeed = data.func_74762_e(NBTKEY_PROCESSING_SPEED);
            }
            if (data.func_74764_b(NBTKEY_POWER_PER_TICK)) {
                this.powerProducedPerProcessingTick = data.func_74769_h(NBTKEY_POWER_PER_TICK);
            }
            if (data.func_74764_b(NBTKEY_PROCESSING_ASPECT)) {
                String aspectTag = data.func_74779_i(NBTKEY_PROCESSING_ASPECT);
                this.processingAspect = (Aspect)Aspect.aspects.get(aspectTag);
                this.processingChanged = true;
            }
            this.markForUpdate();
        }
    }

    @Override
    protected void NBTWrite(NBTTagCompound data) {
        if (this.processingTicksRemaining > 0) {
            data.func_74768_a(NBTKEY_TIME_REMAINING, this.processingTicksRemaining);
            data.func_74768_a(NBTKEY_PROCESSING_SPEED, this.processingSpeed);
            data.func_74780_a(NBTKEY_POWER_PER_TICK, this.powerProducedPerProcessingTick);
            if (this.processingAspect != null) {
                data.func_74778_a(NBTKEY_PROCESSING_ASPECT, this.processingAspect.getTag());
            }
        }
    }

    @Override
    protected void networkRead(ByteBuf stream) {
        if (stream.readBoolean()) {
            this.processingAspect = ThEBasePacket.readAspect(stream);
        }
    }

    @Override
    protected void networkWrite(ByteBuf stream) {
        stream.writeBoolean(this.processingChanged);
        if (this.processingChanged) {
            ThEBasePacket.writeAspect(this.processingAspect, stream);
        }
        this.processingChanged = false;
    }

    @Override
    public void addWailaInformation(List<String> tooltip) {
        if (this.hasStoredEssentia()) {
            tooltip.add(String.format(ThEStrings.GUi_VibrationChamber_Stored.getLocalized(), this.storedEssentia.stackSize, this.storedEssentia.aspect.getName()));
        }
        if (this.processingAspect != null) {
            tooltip.add(String.format(ThEStrings.GUi_VibrationChamber_Processing.getLocalized(), this.processingAspect.getName()));
        }
    }

    public Aspect getProcessingAspect() {
        return this.processingAspect;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(10, 40, false, false);
    }

    public boolean hasSaveDataForDismanle() {
        if (this.storedEssentia != null && this.storedEssentia.stackSize > 0L) {
            return true;
        }
        return this.processingTicksRemaining > 0;
    }

    public void registerListener(ContainerEssentiaVibrationChamber listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ContainerEssentiaVibrationChamber listener) {
        this.listeners.remove((Object)listener);
    }

    public void resetForDismantle() {
        this.processingSpeed = 20;
        this.processingTicksRemaining = 0;
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        boolean replenish = false;
        TickRateModulation rate = TickRateModulation.IDLE;
        if (this.processingTicksRemaining > 0) {
            rate = this.doProcessingTick(ticksSinceLastCall);
        } else {
            this.sync_powerPerTick = 0.0;
            this.processingSpeed = 20;
        }
        if (this.hasStoredEssentia()) {
            if (this.processingTicksRemaining == 0 && this.consumeEssentia()) {
                rate = TickRateModulation.URGENT;
            }
            if (this.storedEssentia.stackSize < 64L) {
                replenish = true;
            }
        } else {
            replenish = true;
        }
        if (replenish) {
            EssentiaTransportHelper.INSTANCE.takeEssentiaFromTransportNeighbors(this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.updateListeners();
        return rate;
    }
}

