/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.proxy;

import appeng.api.AEApi;
import appeng.api.movable.IMovableRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import thaumicenergistics.fluids.GaseousEssentia;
import thaumicenergistics.items.ItemMaterial;
import thaumicenergistics.registries.BlockEnum;
import thaumicenergistics.registries.FeatureRegistry;
import thaumicenergistics.registries.ItemEnum;
import thaumicenergistics.registries.TileEnum;

public class CommonProxy {
    public void registerBlocks() {
        for (BlockEnum block : BlockEnum.VALUES) {
            GameRegistry.registerBlock((Block)block.getBlock(), block.getItemClass(), (String)block.getUnlocalizedName());
        }
    }

    public void registerFeatures() {
        FeatureRegistry.instance().registerFeatures();
    }

    public void registerFluids() {
        GaseousEssentia.registerGases();
    }

    public void registerItems() {
        for (ItemEnum item : ItemEnum.VALUES) {
            GameRegistry.registerItem((Item)item.getItem(), (String)item.getInternalName());
        }
        OreDictionary.registerOre((String)"gearIron", (ItemStack)ItemMaterial.MaterialTypes.IRON_GEAR.getStack());
    }

    public void registerRenderers() {
    }

    public void registerSpatialIOMovables() {
        IMovableRegistry movableRegistry = AEApi.instance().registries().movable();
        for (TileEnum tile : TileEnum.values()) {
            movableRegistry.whiteListTileEntity(tile.getTileClass());
        }
    }

    public void registerTileEntities() {
        for (TileEnum tile : TileEnum.values()) {
            GameRegistry.registerTileEntity((Class)tile.getTileClass(), (String)tile.getTileID());
        }
    }
}

