/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.parts;

import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.container.ContainerPartEssentiaLevelEmitter;
import thaumicenergistics.grid.IEssentiaWatcher;
import thaumicenergistics.grid.IEssentiaWatcherHost;
import thaumicenergistics.grid.IMEEssentiaMonitor;
import thaumicenergistics.gui.GuiEssentiaLevelEmitter;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.network.IAspectSlotPart;
import thaumicenergistics.network.packet.client.Packet_C_AspectSlot;
import thaumicenergistics.network.packet.client.Packet_C_EssentiaEmitter;
import thaumicenergistics.parts.AbstractAEPartBase;
import thaumicenergistics.registries.AEPartsEnum;
import thaumicenergistics.registries.EnumCache;
import thaumicenergistics.texture.BlockTextureManager;
import thaumicenergistics.util.EffectiveSide;

public class AEPartEssentiaLevelEmitter
extends AbstractAEPartBase
implements IAspectSlotPart,
IEssentiaWatcherHost {
    private static final double IDLE_POWER_DRAIN = 0.3;
    private static final String NBT_KEY_ASPECT_FILTER = "aspect";
    private static final String NBT_KEY_REDSTONE_MODE = "mode";
    private static final String NBT_KEY_WANTED_AMOUNT = "wantedAmount";
    private static final String NBT_KEY_IS_EMITTING = "emitting";
    private static final RedstoneMode DEFAULT_REDSTONE_MODE = RedstoneMode.HIGH_SIGNAL;
    private Aspect trackedEssentia;
    private RedstoneMode redstoneMode = DEFAULT_REDSTONE_MODE;
    private long wantedAmount = 0L;
    private long currentAmount;
    private boolean isEmitting = false;
    private IEssentiaWatcher essentiaWatcher;

    public AEPartEssentiaLevelEmitter() {
        super(AEPartsEnum.EssentiaLevelEmitter);
    }

    private void configureWatcher() {
        boolean didSet = false;
        if (this.essentiaWatcher != null) {
            this.essentiaWatcher.clear();
            if (this.trackedEssentia != null) {
                this.essentiaWatcher.add(this.trackedEssentia);
                IMEEssentiaMonitor essMon = this.getGridBlock().getEssentiaMonitor();
                if (essMon != null) {
                    this.setCurrentAmount(essMon.getEssentiaAmount(this.trackedEssentia));
                    didSet = true;
                }
            }
        }
        if (!didSet) {
            this.setCurrentAmount(0L);
        }
    }

    private void setCurrentAmount(long amount) {
        if (amount != this.currentAmount) {
            this.currentAmount = amount;
            this.updateEmittingState();
        }
    }

    private void updateEmittingState() {
        boolean emitting = false;
        if (!this.isActive()) {
            return;
        }
        switch (this.redstoneMode) {
            case HIGH_SIGNAL: {
                emitting = this.currentAmount >= this.wantedAmount;
                break;
            }
            case LOW_SIGNAL: {
                emitting = this.currentAmount < this.wantedAmount;
                break;
            }
        }
        if (emitting != this.isEmitting) {
            this.isEmitting = emitting;
            this.markForSave();
            this.markForUpdate();
            TileEntity hte = this.getHostTile();
            ForgeDirection side = this.getSide();
            Platform.notifyBlocksOfNeighbors((World)hte.func_145831_w(), (int)hte.field_145851_c, (int)hte.field_145848_d, (int)hte.field_145849_e);
            Platform.notifyBlocksOfNeighbors((World)hte.func_145831_w(), (int)(hte.field_145851_c + side.offsetX), (int)(hte.field_145848_d + side.offsetX), (int)(hte.field_145849_e + side.offsetX));
        }
    }

    @Override
    public int cableConnectionRenderTo() {
        return 8;
    }

    @Override
    public boolean doesPlayerHavePermissionToOpenGui(EntityPlayer player) {
        return this.doesPlayerHavePermission(player, SecurityPermissions.BUILD);
    }

    @Override
    public void getBoxes(IPartCollisionHelper helper) {
        helper.addBox(7.0, 7.0, 11.0, 9.0, 9.0, 16.0);
    }

    @Override
    public IIcon getBreakingTexture() {
        return BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[1];
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiEssentiaLevelEmitter(this, player);
    }

    @Override
    public double getIdlePowerUsage() {
        return 0.3;
    }

    @Override
    public int getLightLevel() {
        return this.isEmitting ? 7 : 0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerPartEssentiaLevelEmitter(this, player);
    }

    @Override
    public int isProvidingStrongPower() {
        return this.isEmitting ? 15 : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.isProvidingStrongPower();
    }

    public void onClientAdjustWantedAmount(int adjustmentAmount, EntityPlayer player) {
        this.onClientSetWantedAmount(this.wantedAmount + (long)adjustmentAmount, player);
    }

    public void onClientSetWantedAmount(long wantedAmount, EntityPlayer player) {
        this.wantedAmount = wantedAmount;
        if (this.wantedAmount < 0L) {
            this.wantedAmount = 0L;
        } else if (this.wantedAmount > 9999999999L) {
            this.wantedAmount = 9999999999L;
        }
        this.markForSave();
        Packet_C_EssentiaEmitter.setWantedAmount(this.wantedAmount, player);
        this.updateEmittingState();
    }

    public void onClientToggleRedstoneMode(EntityPlayer player) {
        switch (this.redstoneMode) {
            case HIGH_SIGNAL: {
                this.redstoneMode = RedstoneMode.LOW_SIGNAL;
                break;
            }
            case LOW_SIGNAL: {
                this.redstoneMode = RedstoneMode.HIGH_SIGNAL;
                break;
            }
        }
        this.updateEmittingState();
        Packet_C_EssentiaEmitter.sendRedstoneMode(this.redstoneMode, player);
    }

    public void onClientUpdateRequest(EntityPlayer player) {
        Packet_C_EssentiaEmitter.sendEmitterState(this.redstoneMode, this.wantedAmount, player);
        ArrayList<Aspect> filter = new ArrayList<Aspect>();
        filter.add(this.trackedEssentia);
        Packet_C_AspectSlot.setFilterList(filter, player);
    }

    @Override
    public void onEssentiaChange(Aspect aspect, long storedAmount, long changeAmount) {
        this.setCurrentAmount(storedAmount);
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random r) {
        if (this.isEmitting) {
            ForgeDirection side = this.getSide();
            double particleX = (double)((float)side.offsetX * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double particleY = (double)((float)side.offsetY * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double particleZ = (double)((float)side.offsetZ * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            world.func_72869_a("reddust", 0.5 + (double)x + particleX, 0.5 + (double)y + particleY, 0.5 + (double)z + particleZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(NBT_KEY_ASPECT_FILTER)) {
            this.trackedEssentia = (Aspect)Aspect.aspects.get(data.func_74779_i(NBT_KEY_ASPECT_FILTER));
        }
        if (data.func_74764_b(NBT_KEY_REDSTONE_MODE)) {
            this.redstoneMode = EnumCache.AE_REDSTONE_MODES[data.func_74762_e(NBT_KEY_REDSTONE_MODE)];
        }
        if (data.func_74764_b(NBT_KEY_WANTED_AMOUNT)) {
            this.wantedAmount = data.func_74763_f(NBT_KEY_WANTED_AMOUNT);
        }
        if (data.func_74764_b(NBT_KEY_IS_EMITTING)) {
            this.isEmitting = data.func_74767_n(NBT_KEY_IS_EMITTING);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean readFromStream(ByteBuf stream) throws IOException {
        boolean redraw = false;
        boolean oldEmit = this.isEmitting;
        redraw |= super.readFromStream(stream);
        this.isEmitting = stream.readBoolean();
        return redraw |= this.isEmitting != oldEmit;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper helper, RenderBlocks renderer) {
        helper.setTexture(BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[0]);
        helper.setBounds(7.0f, 1.0f, 14.0f, 9.0f, 7.0f, 16.0f);
        helper.renderInventoryBox(renderer);
        helper.setTexture(BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[1]);
        helper.setBounds(7.0f, 7.0f, 14.0f, 9.0f, 9.0f, 16.0f);
        helper.renderInventoryBox(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper helper, RenderBlocks renderer) {
        helper.setTexture(BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[0]);
        helper.setBounds(7.0f, 7.0f, 11.0f, 9.0f, 9.0f, 14.0f);
        helper.renderBlock(x, y, z, renderer);
        if (this.isEmitting) {
            helper.setTexture(BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[1]);
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
        } else {
            helper.setTexture(BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[2]);
        }
        helper.setBounds(7.0f, 7.0f, 14.0f, 9.0f, 9.0f, 16.0f);
        helper.renderBlock(x, y, z, renderer);
    }

    @Override
    public void setAspect(int index, Aspect aspect, EntityPlayer player) {
        if (this.trackedEssentia != aspect) {
            this.trackedEssentia = aspect;
            if (EffectiveSide.isClientSide()) {
                return;
            }
            this.markForSave();
            this.configureWatcher();
            ArrayList<Aspect> filter = new ArrayList<Aspect>();
            filter.add(aspect);
            Packet_C_AspectSlot.setFilterList(filter, player);
        }
    }

    public boolean setFilteredAspectFromItemstack(EntityPlayer player, ItemStack itemStack) {
        Aspect itemAspect = EssentiaItemContainerHelper.INSTANCE.getFilterAspectFromItem(itemStack);
        if (itemAspect == null) {
            return false;
        }
        this.setAspect(0, itemAspect, player);
        return true;
    }

    @Override
    public void updateWatcher(IEssentiaWatcher newWatcher) {
        this.essentiaWatcher = newWatcher;
        this.configureWatcher();
    }

    @Override
    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        super.writeToNBT(data, saveType);
        if (this.trackedEssentia != null) {
            data.func_74778_a(NBT_KEY_ASPECT_FILTER, this.trackedEssentia.getTag());
        }
        if (this.redstoneMode != DEFAULT_REDSTONE_MODE) {
            data.func_74768_a(NBT_KEY_REDSTONE_MODE, this.redstoneMode.ordinal());
        }
        if (this.wantedAmount > 0L) {
            data.func_74772_a(NBT_KEY_WANTED_AMOUNT, this.wantedAmount);
        }
        if (saveType != PartItemStack.Wrench && this.isEmitting) {
            data.func_74757_a(NBT_KEY_IS_EMITTING, true);
        }
    }

    @Override
    public void writeToStream(ByteBuf stream) throws IOException {
        super.writeToStream(stream);
        stream.writeBoolean(this.isEmitting);
    }
}

