/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.parts;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.client.texture.CableBusTextures;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.grid.IMEEssentiaMonitor;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.parts.AEPartEssentiaStorageMonitor;
import thaumicenergistics.registries.AEPartsEnum;
import thaumicenergistics.util.EffectiveSide;

public class AEPartEssentiaConversionMonitor
extends AEPartEssentiaStorageMonitor {
    private static long DOUBLE_CLICK_TICKS = 40L;
    private int depositedPlayerID = -1;
    private int depositedTick = 0;
    private Aspect depositedAspect = null;

    public AEPartEssentiaConversionMonitor() {
        super(AEPartsEnum.EssentiaConversionMonitor);
        this.darkCornerTexture = CableBusTextures.PartConversionMonitor_Colored;
        this.lightCornerTexture = CableBusTextures.PartConversionMonitor_Dark;
    }

    private boolean drainEssentiaContainer(EntityPlayer player, int slotIndex, Aspect mustMatchAspect) {
        ItemStack container = player.field_71071_by.func_70301_a(slotIndex);
        AspectStack request = EssentiaItemContainerHelper.INSTANCE.getAspectStackFromContainer(container);
        if (request == null) {
            return false;
        }
        if (mustMatchAspect != null && request.aspect != mustMatchAspect) {
            return false;
        }
        IMEEssentiaMonitor essMonitor = this.getGridBlock().getEssentiaMonitor();
        if (essMonitor == null) {
            return false;
        }
        long rejected = essMonitor.injectEssentia(request.aspect, request.stackSize, Actionable.MODULATE, (BaseActionSource)new PlayerSource(player, (IActionHost)this), true);
        request.stackSize -= rejected;
        if (request.stackSize <= 0L) {
            return false;
        }
        ImmutablePair<Integer, ItemStack> drained = EssentiaItemContainerHelper.INSTANCE.extractFromContainer(container, request);
        player.field_71071_by.func_70298_a(slotIndex, 1);
        if (drained != null) {
            player.field_71071_by.func_70441_a((ItemStack)drained.right);
        }
        this.depositedAspect = request.aspect;
        return true;
    }

    private boolean fillEssentiaContainer(EntityPlayer player, ItemStack heldItem, EssentiaItemContainerHelper.AspectItemType itemType) {
        Aspect containerAspect;
        if (itemType == EssentiaItemContainerHelper.AspectItemType.JarLabel) {
            EssentiaItemContainerHelper.INSTANCE.setLabelAspect(heldItem, this.trackedEssentia.getAspectStack().aspect);
            return true;
        }
        if (itemType != EssentiaItemContainerHelper.AspectItemType.EssentiaContainer) {
            return false;
        }
        if (!this.doesPlayerHavePermission(player, SecurityPermissions.EXTRACT)) {
            return false;
        }
        int containerAmount = EssentiaItemContainerHelper.INSTANCE.getContainerStoredAmount(heldItem);
        if (containerAmount > 0 && this.trackedEssentia.getAspectStack().aspect != (containerAspect = EssentiaItemContainerHelper.INSTANCE.getAspectInContainer(heldItem))) {
            return false;
        }
        Aspect jarLabelAspect = EssentiaItemContainerHelper.INSTANCE.getJarLabelAspect(heldItem);
        if (jarLabelAspect != null && this.trackedEssentia.getAspectStack().aspect != jarLabelAspect) {
            return false;
        }
        IMEEssentiaMonitor essMonitor = this.getGridBlock().getEssentiaMonitor();
        if (essMonitor == null) {
            return false;
        }
        int containerCapacity = EssentiaItemContainerHelper.INSTANCE.getContainerCapacity(heldItem);
        AspectStack fillRequest = new AspectStack(this.trackedEssentia.getAspectStack().aspect, containerCapacity - containerAmount);
        if (fillRequest.stackSize <= 0L) {
            return false;
        }
        PlayerSource playerSource = new PlayerSource(player, (IActionHost)this);
        long extractedAmount = essMonitor.extractEssentia(fillRequest.aspect, fillRequest.stackSize, Actionable.SIMULATE, (BaseActionSource)playerSource, true);
        if (extractedAmount <= 0L) {
            return false;
        }
        fillRequest.stackSize = extractedAmount;
        ImmutablePair<Integer, ItemStack> filledContainer = EssentiaItemContainerHelper.INSTANCE.injectIntoContainer(heldItem, fillRequest);
        if (filledContainer == null) {
            return false;
        }
        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
        InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
        ItemStack rejectedItem = adaptor.addItems((ItemStack)filledContainer.right);
        if (rejectedItem != null) {
            TileEntity te = this.getHostTile();
            ForgeDirection side = this.getSide();
            List<ItemStack> list = Collections.singletonList(rejectedItem);
            Platform.spawnDrops((World)player.field_70170_p, (int)(te.field_145851_c + side.offsetX), (int)(te.field_145848_d + side.offsetY), (int)(te.field_145849_e + side.offsetZ), list);
        }
        if (player.field_71070_bA != null) {
            player.field_71070_bA.func_75142_b();
        }
        essMonitor.extractEssentia(fillRequest.aspect, fillRequest.stackSize, Actionable.MODULATE, (BaseActionSource)playerSource, true);
        return true;
    }

    private void insertAllEssentiaIntoNetwork(EntityPlayer player) {
        ItemStack tracking = null;
        int prevStackSize = 0;
        for (int slotIndex = 0; slotIndex < player.field_71071_by.func_70302_i_(); ++slotIndex) {
            tracking = player.field_71071_by.func_70301_a(slotIndex);
            if (tracking == null || (prevStackSize = tracking.field_77994_a) == 0) continue;
            this.drainEssentiaContainer(player, slotIndex, this.depositedAspect);
            tracking = player.field_71071_by.func_70301_a(slotIndex);
            if (tracking == null || tracking.field_77994_a <= 0 || prevStackSize == tracking.field_77994_a) continue;
            --slotIndex;
        }
    }

    private void markFirstClick(EntityPlayer player) {
        this.depositedPlayerID = AEApi.instance().registries().players().getID(player.func_146103_bH());
        this.depositedTick = MinecraftServer.func_71276_C().func_71259_af();
    }

    private boolean wasDoubleClick(EntityPlayer player) {
        if (this.depositedPlayerID != -1 && this.depositedPlayerID == AEApi.instance().registries().players().getID(player.func_146103_bH()) && (long)(MinecraftServer.func_71276_C().func_71259_af() - this.depositedTick) <= DOUBLE_CLICK_TICKS) {
            this.depositedPlayerID = -1;
            this.depositedTick = 0;
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivateWithAspectItem(EntityPlayer player, ItemStack heldItem, EssentiaItemContainerHelper.AspectItemType itemType) {
        if (!this.trackedEssentia.isValid() || !this.isLocked()) {
            return super.onActivateWithAspectItem(player, heldItem, itemType);
        }
        return this.fillEssentiaContainer(player, heldItem, itemType);
    }

    @Override
    public boolean onShiftActivate(EntityPlayer player, Vec3 position) {
        if (EffectiveSide.isClientSide()) {
            return true;
        }
        if (!this.activationCheck(player)) {
            return false;
        }
        if (!this.doesPlayerHavePermission(player, SecurityPermissions.INJECT)) {
            return false;
        }
        ItemStack heldItem = player.func_71045_bC();
        if (EssentiaItemContainerHelper.INSTANCE.getItemType(heldItem) != EssentiaItemContainerHelper.AspectItemType.EssentiaContainer) {
            return false;
        }
        if (this.wasDoubleClick(player)) {
            this.insertAllEssentiaIntoNetwork(player);
            return true;
        }
        boolean didDrain = this.drainEssentiaContainer(player, player.field_71071_by.field_70461_c, null);
        if (didDrain) {
            this.markFirstClick(player);
        }
        return didDrain;
    }
}

