/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import thaumicenergistics.container.ContainerPriority;
import thaumicenergistics.network.NetworkHandler;
import thaumicenergistics.network.packet.ThEServerPacket;

public class Packet_S_Priority
extends ThEServerPacket {
    private static final byte MODE_SET = 0;
    private static final byte MODE_ADJUST = 1;
    private static final byte MODE_REQUEST = 2;
    private int priority;

    private static Packet_S_Priority newPacket(EntityPlayer player, byte mode) {
        Packet_S_Priority packet = new Packet_S_Priority();
        packet.player = player;
        packet.mode = mode;
        return packet;
    }

    public static void sendPriority(int priority, EntityPlayer player) {
        Packet_S_Priority packet = Packet_S_Priority.newPacket(player, (byte)0);
        packet.priority = priority;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendPriorityDelta(int priority, EntityPlayer player) {
        Packet_S_Priority packet = Packet_S_Priority.newPacket(player, (byte)1);
        packet.priority = priority;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendPriorityRequest(EntityPlayer player) {
        Packet_S_Priority packet = Packet_S_Priority.newPacket(player, (byte)2);
        NetworkHandler.sendPacketToServer(packet);
    }

    @Override
    protected void readData(ByteBuf stream) {
        switch (this.mode) {
            case 0: 
            case 1: {
                this.priority = stream.readInt();
            }
        }
    }

    @Override
    protected void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 0: 
            case 1: {
                stream.writeInt(this.priority);
            }
        }
    }

    @Override
    public void execute() {
        if (this.player == null) {
            return;
        }
        if (!(this.player.field_71070_bA instanceof ContainerPriority)) {
            return;
        }
        switch (this.mode) {
            case 0: {
                ((ContainerPriority)this.player.field_71070_bA).onClientRequestSetPriority(this.priority);
                break;
            }
            case 1: {
                ((ContainerPriority)this.player.field_71070_bA).onClientRequestAdjustPriority(this.priority);
                break;
            }
            case 2: {
                ((ContainerPriority)this.player.field_71070_bA).onClientRequestPriority();
            }
        }
    }
}

