/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import thaumicenergistics.network.NetworkHandler;
import thaumicenergistics.network.packet.ThEBasePacket;
import thaumicenergistics.network.packet.ThEServerPacket;
import thaumicenergistics.parts.AEPartEssentiaStorageBus;

public class Packet_S_EssentiaStorageBus
extends ThEServerPacket {
    private static final byte MODE_REQUEST_FULL_UPDATE = 0;
    private static final byte MODE_REQUEST_SET_VOID = 1;
    private AEPartEssentiaStorageBus part;
    private boolean isVoidAllowed;

    private static Packet_S_EssentiaStorageBus newPacket(EntityPlayer player, byte mode, AEPartEssentiaStorageBus part) {
        Packet_S_EssentiaStorageBus packet = new Packet_S_EssentiaStorageBus();
        packet.player = player;
        packet.mode = mode;
        packet.part = part;
        return packet;
    }

    public static void sendFullUpdateRequest(EntityPlayer player, AEPartEssentiaStorageBus part) {
        Packet_S_EssentiaStorageBus packet = Packet_S_EssentiaStorageBus.newPacket(player, (byte)0, part);
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void setVoidAllowed(EntityPlayer player, AEPartEssentiaStorageBus part, boolean isVoidAllowed) {
        Packet_S_EssentiaStorageBus packet = Packet_S_EssentiaStorageBus.newPacket(player, (byte)1, part);
        packet.isVoidAllowed = isVoidAllowed;
        NetworkHandler.sendPacketToServer(packet);
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                this.part.onClientRequestFullUpdate(this.player);
                break;
            }
            case 1: {
                this.part.onClientRequestSetVoidMode(this.player, this.isVoidAllowed);
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                this.part = (AEPartEssentiaStorageBus)ThEBasePacket.readPart(stream);
                break;
            }
            case 1: {
                this.part = (AEPartEssentiaStorageBus)ThEBasePacket.readPart(stream);
                this.isVoidAllowed = stream.readBoolean();
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                ThEBasePacket.writePart(this.part, stream);
                break;
            }
            case 1: {
                ThEBasePacket.writePart(this.part, stream);
                stream.writeBoolean(this.isVoidAllowed);
            }
        }
    }
}

