/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import thaumicenergistics.network.NetworkHandler;
import thaumicenergistics.network.packet.ThEBasePacket;
import thaumicenergistics.network.packet.ThEServerPacket;
import thaumicenergistics.parts.AEPartEssentiaLevelEmitter;

public class Packet_S_EssentiaEmitter
extends ThEServerPacket {
    private static final byte MODE_REQUEST_UPDATE = 0;
    private static final byte MODE_SEND_WANTED = 1;
    private static final byte MODE_ADJUST_WANTED = 2;
    private static final byte MODE_TOGGLE_REDSTONE = 3;
    private AEPartEssentiaLevelEmitter part;
    private long wantedAmount;
    private int adjustmentAmount;

    private static Packet_S_EssentiaEmitter newPacket(EntityPlayer player, byte mode) {
        Packet_S_EssentiaEmitter packet = new Packet_S_EssentiaEmitter();
        packet.player = player;
        packet.mode = mode;
        return packet;
    }

    public static void sendRedstoneModeToggle(AEPartEssentiaLevelEmitter part, EntityPlayer player) {
        Packet_S_EssentiaEmitter packet = Packet_S_EssentiaEmitter.newPacket(player, (byte)3);
        packet.part = part;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendUpdateRequest(AEPartEssentiaLevelEmitter part, EntityPlayer player) {
        Packet_S_EssentiaEmitter packet = Packet_S_EssentiaEmitter.newPacket(player, (byte)0);
        packet.part = part;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendWantedAmount(long wantedAmount, AEPartEssentiaLevelEmitter part, EntityPlayer player) {
        Packet_S_EssentiaEmitter packet = Packet_S_EssentiaEmitter.newPacket(player, (byte)1);
        packet.part = part;
        packet.wantedAmount = wantedAmount;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendWantedAmountDelta(int adjustmentAmount, AEPartEssentiaLevelEmitter part, EntityPlayer player) {
        Packet_S_EssentiaEmitter packet = Packet_S_EssentiaEmitter.newPacket(player, (byte)2);
        packet.part = part;
        packet.adjustmentAmount = adjustmentAmount;
        NetworkHandler.sendPacketToServer(packet);
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                this.part.onClientUpdateRequest(this.player);
                break;
            }
            case 1: {
                this.part.onClientSetWantedAmount(this.wantedAmount, this.player);
                break;
            }
            case 2: {
                this.part.onClientAdjustWantedAmount(this.adjustmentAmount, this.player);
                break;
            }
            case 3: {
                this.part.onClientToggleRedstoneMode(this.player);
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                this.part = (AEPartEssentiaLevelEmitter)ThEBasePacket.readPart(stream);
                break;
            }
            case 1: {
                this.part = (AEPartEssentiaLevelEmitter)ThEBasePacket.readPart(stream);
                this.wantedAmount = stream.readLong();
                break;
            }
            case 2: {
                this.part = (AEPartEssentiaLevelEmitter)ThEBasePacket.readPart(stream);
                this.adjustmentAmount = stream.readInt();
                break;
            }
            case 3: {
                this.part = (AEPartEssentiaLevelEmitter)ThEBasePacket.readPart(stream);
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                ThEBasePacket.writePart(this.part, stream);
                break;
            }
            case 1: {
                ThEBasePacket.writePart(this.part, stream);
                stream.writeLong(this.wantedAmount);
                break;
            }
            case 2: {
                ThEBasePacket.writePart(this.part, stream);
                stream.writeInt(this.adjustmentAmount);
                break;
            }
            case 3: {
                ThEBasePacket.writePart(this.part, stream);
            }
        }
    }
}

