/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.network.NetworkHandler;
import thaumicenergistics.network.packet.ThEBasePacket;
import thaumicenergistics.network.packet.ThEServerPacket;
import thaumicenergistics.tileentities.TileEssentiaCellWorkbench;

public class Packet_S_EssentiaCellWorkbench
extends ThEServerPacket {
    private static final byte MODE_REQUEST_ADD_ASPECT = 0;
    private static final byte MODE_REQUEST_REMOVE_ASPECT = 1;
    private static final byte MODE_REQUEST_REPLACE_ASPECT = 2;
    private static final byte MODE_REQUEST_FULL_LIST = 4;
    private static final byte MODE_REQUEST_CLEAR = 5;
    private static final byte MODE_REQUEST_PARITION_CONTENTS = 6;
    private Aspect arAspect;
    private Aspect replaceAspect;
    private TileEssentiaCellWorkbench workbench;

    private static Packet_S_EssentiaCellWorkbench newPacket(EntityPlayer player, byte mode) {
        Packet_S_EssentiaCellWorkbench packet = new Packet_S_EssentiaCellWorkbench();
        packet.player = player;
        packet.mode = mode;
        return packet;
    }

    public static void sendAddAspect(EntityPlayer player, TileEssentiaCellWorkbench workbench, Aspect aspect) {
        Packet_S_EssentiaCellWorkbench packet = Packet_S_EssentiaCellWorkbench.newPacket(player, (byte)0);
        packet.arAspect = aspect;
        packet.workbench = workbench;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendClearPartitioning(EntityPlayer player, TileEssentiaCellWorkbench workbench) {
        Packet_S_EssentiaCellWorkbench packet = Packet_S_EssentiaCellWorkbench.newPacket(player, (byte)5);
        packet.workbench = workbench;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendGetPartitionList(EntityPlayer player, TileEssentiaCellWorkbench workbench) {
        Packet_S_EssentiaCellWorkbench packet = Packet_S_EssentiaCellWorkbench.newPacket(player, (byte)4);
        packet.workbench = workbench;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendPartitionToContents(EntityPlayer player, TileEssentiaCellWorkbench workbench) {
        Packet_S_EssentiaCellWorkbench packet = Packet_S_EssentiaCellWorkbench.newPacket(player, (byte)6);
        packet.workbench = workbench;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendRemoveAspect(EntityPlayer player, TileEssentiaCellWorkbench workbench, Aspect aspect) {
        Packet_S_EssentiaCellWorkbench packet = Packet_S_EssentiaCellWorkbench.newPacket(player, (byte)1);
        packet.arAspect = aspect;
        packet.workbench = workbench;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendReplaceAspect(EntityPlayer player, TileEssentiaCellWorkbench workbench, Aspect originalAspect, Aspect newAspect) {
        Packet_S_EssentiaCellWorkbench packet = Packet_S_EssentiaCellWorkbench.newPacket(player, (byte)2);
        packet.arAspect = originalAspect;
        packet.replaceAspect = newAspect;
        packet.workbench = workbench;
        NetworkHandler.sendPacketToServer(packet);
    }

    @Override
    protected void readData(ByteBuf stream) {
        this.workbench = (TileEssentiaCellWorkbench)ThEBasePacket.readTileEntity(stream);
        switch (this.mode) {
            case 0: 
            case 1: {
                this.arAspect = ThEBasePacket.readAspect(stream);
                break;
            }
            case 2: {
                this.arAspect = ThEBasePacket.readAspect(stream);
                this.replaceAspect = ThEBasePacket.readAspect(stream);
            }
        }
    }

    @Override
    protected void writeData(ByteBuf stream) {
        ThEBasePacket.writeTileEntity(this.workbench, stream);
        switch (this.mode) {
            case 0: 
            case 1: {
                ThEBasePacket.writeAspect(this.arAspect, stream);
                break;
            }
            case 2: {
                ThEBasePacket.writeAspect(this.arAspect, stream);
                ThEBasePacket.writeAspect(this.replaceAspect, stream);
            }
        }
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                this.workbench.onClientRequestAddAspectToPartitionList(this.player, this.arAspect);
                break;
            }
            case 1: {
                this.workbench.onClientRequestRemoveAspectFromPartitionList(this.player, this.arAspect);
                break;
            }
            case 2: {
                this.workbench.onClientRequestReplaceAspectFromPartitionList(this.player, this.arAspect, this.replaceAspect);
                break;
            }
            case 4: {
                this.workbench.onClientRequestPartitionList(this.player);
                break;
            }
            case 5: {
                this.workbench.onClientRequestClearPartitioning(this.player);
                break;
            }
            case 6: {
                this.workbench.onClientRequestPartitionToContents(this.player);
            }
        }
    }
}

