/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.aspect.AspectStackComparator;
import thaumicenergistics.container.AbstractContainerCellTerminalBase;
import thaumicenergistics.network.NetworkHandler;
import thaumicenergistics.network.packet.ThEBasePacket;
import thaumicenergistics.network.packet.ThEServerPacket;

public class Packet_S_EssentiaCellTerminal
extends ThEServerPacket {
    private static final byte MODE_SELECTED_ASPECT = 0;
    private static final byte MODE_FULL_UPDATE = 1;
    private static final byte MODE_SORT_CHANGE = 2;
    private Aspect currentAspect;
    private AspectStackComparator.ComparatorMode sortMode;

    private static Packet_S_EssentiaCellTerminal newPacket(EntityPlayer player, byte mode) {
        Packet_S_EssentiaCellTerminal packet = new Packet_S_EssentiaCellTerminal();
        packet.player = player;
        packet.mode = mode;
        return packet;
    }

    public static void sendFullUpdateRequest(EntityPlayer player) {
        Packet_S_EssentiaCellTerminal packet = Packet_S_EssentiaCellTerminal.newPacket(player, (byte)1);
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendSelectedAspect(EntityPlayer player, Aspect currentAspect) {
        Packet_S_EssentiaCellTerminal packet = Packet_S_EssentiaCellTerminal.newPacket(player, (byte)0);
        packet.currentAspect = currentAspect;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendSortMode(EntityPlayer player, AspectStackComparator.ComparatorMode sortMode) {
        Packet_S_EssentiaCellTerminal packet = Packet_S_EssentiaCellTerminal.newPacket(player, (byte)2);
        packet.sortMode = sortMode;
        NetworkHandler.sendPacketToServer(packet);
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                if (this.player == null || !(this.player.field_71070_bA instanceof AbstractContainerCellTerminalBase)) break;
                ((AbstractContainerCellTerminalBase)this.player.field_71070_bA).onReceivedSelectedAspect(this.currentAspect);
                break;
            }
            case 1: {
                if (this.player == null || !(this.player.field_71070_bA instanceof AbstractContainerCellTerminalBase)) break;
                ((AbstractContainerCellTerminalBase)this.player.field_71070_bA).onClientRequestFullUpdate();
                break;
            }
            case 2: {
                if (this.player == null || !(this.player.field_71070_bA instanceof AbstractContainerCellTerminalBase)) break;
                ((AbstractContainerCellTerminalBase)this.player.field_71070_bA).onClientRequestSortModeChange(this.sortMode, this.player);
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                this.currentAspect = ThEBasePacket.readAspect(stream);
                break;
            }
            case 2: {
                this.sortMode = AspectStackComparator.ComparatorMode.VALUES[stream.readInt()];
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                ThEBasePacket.writeAspect(this.currentAspect, stream);
                break;
            }
            case 2: {
                stream.writeInt(this.sortMode.ordinal());
            }
        }
    }
}

