/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.server;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.core.AELog;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.Future;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.gui.ThEGuiHandler;
import thaumicenergistics.network.NetworkHandler;
import thaumicenergistics.network.packet.ThEServerPacket;

public class Packet_S_ConfirmCraftingJob
extends ThEServerPacket {
    private static final byte MODE_REQUEST_CONFIRM = 1;
    private long amount;
    private boolean heldShift;

    public static void sendConfirmAutoCraft(EntityPlayer player, long amount, boolean isShiftHeld) {
        Packet_S_ConfirmCraftingJob packet = new Packet_S_ConfirmCraftingJob();
        packet.player = player;
        packet.mode = 1;
        packet.amount = amount;
        packet.heldShift = isShiftHeld;
        NetworkHandler.sendPacketToServer(packet);
    }

    @Override
    protected void readData(ByteBuf stream) {
        this.amount = stream.readLong();
        this.heldShift = stream.readBoolean();
    }

    @Override
    protected void writeData(ByteBuf stream) {
        stream.writeLong(this.amount);
        stream.writeBoolean(this.heldShift);
    }

    @Override
    public void execute() {
        ContainerCraftAmount cca;
        Object target;
        if (this.mode != 1) {
            return;
        }
        if (this.player.field_71070_bA instanceof ContainerCraftAmount && (target = (cca = (ContainerCraftAmount)this.player.field_71070_bA).getTarget()) instanceof IGridHost) {
            IGridHost gh = (IGridHost)target;
            IGridNode gn = gh.getGridNode(ForgeDirection.UNKNOWN);
            if (gn == null) {
                return;
            }
            IGrid g = gn.getGrid();
            if (g == null || cca.getItemToCraft() == null) {
                return;
            }
            cca.getItemToCraft().setStackSize(this.amount);
            Future futureJob = null;
            try {
                ICraftingGrid cg = (ICraftingGrid)g.getCache(ICraftingGrid.class);
                futureJob = cg.beginCraftingJob(cca.getWorld(), cca.getGrid(), cca.getActionSrc(), cca.getItemToCraft(), null);
                ContainerOpenContext context = cca.getOpenContext();
                if (context != null) {
                    TileEntity te = context.getTile();
                    int GUI_ID = ThEGuiHandler.generateSidedID(90, context.getSide());
                    ThEGuiHandler.launchGui(GUI_ID, this.player, te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
                    if (this.player.field_71070_bA instanceof ContainerCraftConfirm) {
                        ContainerCraftConfirm ccc = (ContainerCraftConfirm)this.player.field_71070_bA;
                        ccc.setAutoStart(this.heldShift);
                        ccc.setJob(futureJob);
                        cca.func_75142_b();
                    }
                }
            }
            catch (Throwable e) {
                if (futureJob != null) {
                    futureJob.cancel(true);
                }
                AELog.error((Throwable)e);
            }
        }
    }
}

