/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.aspect.AspectStackComparator;
import thaumicenergistics.gui.GuiEssentiaCellTerminal;
import thaumicenergistics.network.NetworkHandler;
import thaumicenergistics.network.packet.ThEBasePacket;
import thaumicenergistics.network.packet.ThEClientPacket;

public class Packet_C_EssentiaCellTerminal
extends ThEClientPacket {
    private static final byte MODE_FULL_LIST = 0;
    private static final byte MODE_SELECTED_ASPECT = 1;
    private static final byte MODE_SORT_MODE_CHANGED = 2;
    private static final byte MODE_LIST_CHANGED = 3;
    private List<AspectStack> aspectStackList;
    private Aspect selectedAspect;
    private AspectStackComparator.ComparatorMode sortMode;
    private AspectStack change;

    private static Packet_C_EssentiaCellTerminal newPacket(EntityPlayer player, byte mode) {
        Packet_C_EssentiaCellTerminal packet = new Packet_C_EssentiaCellTerminal();
        packet.player = player;
        packet.mode = mode;
        return packet;
    }

    public static void sendFullList(EntityPlayer player, List<AspectStack> list) {
        Packet_C_EssentiaCellTerminal packet = Packet_C_EssentiaCellTerminal.newPacket(player, (byte)0);
        packet.useCompression = true;
        packet.aspectStackList = list;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void setAspectAmount(EntityPlayer player, AspectStack change) {
        Packet_C_EssentiaCellTerminal packet = Packet_C_EssentiaCellTerminal.newPacket(player, (byte)3);
        packet.change = change;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void setSelectedAspect(EntityPlayer player, Aspect selectedAspect) {
        Packet_C_EssentiaCellTerminal packet = Packet_C_EssentiaCellTerminal.newPacket(player, (byte)1);
        packet.selectedAspect = selectedAspect;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void setSortMode(EntityPlayer player, AspectStackComparator.ComparatorMode sortMode) {
        Packet_C_EssentiaCellTerminal packet = Packet_C_EssentiaCellTerminal.newPacket(player, (byte)2);
        packet.sortMode = sortMode;
        NetworkHandler.sendPacketToClient(packet);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void wrappedExecute() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof GuiEssentiaCellTerminal) {
            switch (this.mode) {
                case 0: {
                    ((GuiEssentiaCellTerminal)gui).onReceiveAspectList(this.aspectStackList);
                    break;
                }
                case 1: {
                    ((GuiEssentiaCellTerminal)gui).onReceiveSelectedAspect(this.selectedAspect);
                    break;
                }
                case 2: {
                    ((GuiEssentiaCellTerminal)gui).onSortModeChanged(this.sortMode);
                    break;
                }
                case 3: {
                    ((GuiEssentiaCellTerminal)gui).onReceiveAspectListChange(this.change);
                }
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                this.aspectStackList = new ArrayList<AspectStack>();
                while (stream.readableBytes() > 0) {
                    this.aspectStackList.add(new AspectStack(ThEBasePacket.readAspect(stream), stream.readLong()));
                }
                break;
            }
            case 1: {
                this.selectedAspect = ThEBasePacket.readAspect(stream);
                break;
            }
            case 2: {
                this.sortMode = AspectStackComparator.ComparatorMode.VALUES[stream.readInt()];
                break;
            }
            case 3: {
                this.change = new AspectStack(ThEBasePacket.readAspect(stream), stream.readLong());
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                for (AspectStack stack : this.aspectStackList) {
                    ThEBasePacket.writeAspect(stack.aspect, stream);
                    stream.writeLong(stack.stackSize);
                }
                break;
            }
            case 1: {
                ThEBasePacket.writeAspect(this.selectedAspect, stream);
                break;
            }
            case 2: {
                stream.writeInt(this.sortMode.ordinal());
                break;
            }
            case 3: {
                ThEBasePacket.writeAspect(this.change.aspect, stream);
                stream.writeLong(this.change.stackSize);
            }
        }
    }
}

