/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import thaumicenergistics.network.NetworkHandler;
import thaumicenergistics.network.packet.ThEBasePacket;
import thaumicenergistics.util.ThELog;

public abstract class WrapperPacket
implements IMessage {
    private ThEBasePacket embeddedPacket;

    public WrapperPacket() {
    }

    public WrapperPacket(ThEBasePacket packet) {
        this.embeddedPacket = packet;
    }

    public void execute() {
        if (this.embeddedPacket != null) {
            this.embeddedPacket.execute();
        }
    }

    public void fromBytes(ByteBuf stream) {
        int id = stream.readInt();
        if (id == -1) {
            ThELog.warning("Invalid packet ID detected", new Object[0]);
            return;
        }
        Class epClass = NetworkHandler.getPacketClassFromID(id);
        if (epClass == null) {
            return;
        }
        try {
            this.embeddedPacket = (ThEBasePacket)epClass.newInstance();
            this.embeddedPacket.fromBytes(stream);
        }
        catch (Exception e) {
            ThELog.warning("Unable to construct packet %s", epClass.getCanonicalName());
        }
    }

    public void toBytes(ByteBuf stream) {
        if (this.embeddedPacket != null) {
            int id = NetworkHandler.getPacketID(this.embeddedPacket);
            stream.writeInt(id);
            this.embeddedPacket.toBytes(stream);
        } else {
            stream.writeInt(-1);
        }
    }
}

